/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import net.lenni0451.lambdaevents.EventHandler;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_638;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointColor;
import xaero.hud.minimap.waypoint.set.WaypointSet;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.core.XaeroWorldMapCore;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.event.RespawnPointSetEvent;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.extensions.SyncedWaypoint;
import xaeroplus.feature.waypoint.WaypointAPI;
import xaeroplus.module.Module;
import xaeroplus.settings.Settings;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.FileUtil;

public class SpawnPoint
extends Module {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<UUID, SpawnPosition> respawnPoints = new ConcurrentHashMap<UUID, SpawnPosition>();
    private static final WeakReference nullRef = new WeakReference<Object>(null);
    private WeakReference<Waypoint> wpRef = nullRef;
    private WeakReference<WaypointSet> wpSetRef = nullRef;
    private SpawnPosition wpSpawnPoint = null;

    @Override
    public void onEnable() {
        if (this.mc.field_1687 == null) {
            return;
        }
        this.respawnPoints.clear();
        this.loadRespawnPoints();
    }

    @Override
    public void onDisable() {
        if (this.mc.field_1687 == null) {
            return;
        }
        this.saveRespawnPoints();
        this.respawnPoints.clear();
        this.clearWpAndState();
    }

    @EventHandler
    public void onRespawnPointSet(RespawnPointSetEvent event) {
        class_634 con = this.mc.method_1562();
        if (con == null) {
            return;
        }
        UUID activeUUID = con.method_2879().getId();
        this.respawnPoints.put(activeUUID, new SpawnPosition(ChunkUtils.getActualDimension().method_29177().toString(), event.pos().method_10263(), event.pos().method_10264(), event.pos().method_10260()));
        this.saveRespawnPointsAsync();
    }

    @EventHandler
    public void onXaeroWorldChange(XaeroWorldChangeEvent event) {
        switch (event.worldChangeType()) {
            case EXIT_WORLD: {
                this.saveRespawnPoints();
                this.clearWpAndState();
                this.respawnPoints.clear();
                break;
            }
            case ENTER_WORLD: {
                this.clearWpAndState();
                this.respawnPoints.clear();
                this.loadRespawnPoints();
            }
        }
    }

    @EventHandler
    public void onClientTick(ClientTickEvent.Post event) {
        MinimapWorld minimapWorld;
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession == null) {
            return;
        }
        MinimapWorld currentWorld = minimapSession.getWorldManager().getCurrentWorld();
        if (currentWorld == null) {
            return;
        }
        class_634 con = this.mc.method_1562();
        if (con == null) {
            return;
        }
        UUID uuid = con.method_2879().getId();
        SpawnPosition spawnPoint = this.respawnPoints.get(uuid);
        if (spawnPoint == null) {
            this.clearWpAndState();
            return;
        }
        class_5321 spawnPointDimension = spawnPoint.dimension();
        if (spawnPointDimension == null) {
            this.clearWpAndState();
            return;
        }
        if (Settings.REGISTRY.owAutoWaypointDimension.get() && spawnPointDimension == class_1937.field_25180) {
            spawnPointDimension = class_1937.field_25179;
            spawnPoint = new SpawnPosition(class_1937.field_25179.method_29177().toString(), spawnPoint.x() * 8, spawnPoint.y(), spawnPoint.z() * 8);
        }
        if ((minimapWorld = WaypointAPI.getMinimapWorld(spawnPointDimension)) == null) {
            this.clearWpAndState();
            return;
        }
        WaypointSet waypointSet = WaypointAPI.getOrCreateWaypointSetInWorld(minimapWorld, "gui.xaero_default");
        if (!Objects.equals(this.wpSpawnPoint, spawnPoint) || this.wpSetRef.get() == null || this.wpRef.get() == null) {
            this.clearWpAndState();
            this.wpSetRef = new WeakReference<WaypointSet>(waypointSet);
            SyncedWaypoint wp = SyncedWaypoint.create(spawnPoint.x(), spawnPoint.y(), spawnPoint.z(), "Spawn Point", "SP", WaypointColor.AQUA);
            waypointSet.add((Waypoint)wp);
            this.wpRef = new WeakReference<SyncedWaypoint>(wp);
            this.wpSpawnPoint = spawnPoint;
            XaeroPlus.LOGGER.info("[SpawnPoint] Spawn Point Waypoint Updated: {} {} {}", new Object[]{spawnPoint.x(), spawnPoint.y(), spawnPoint.z()});
        }
    }

    private synchronized void clearWpAndState() {
        if (this.wpRef.get() != null && this.wpSetRef.get() != null) {
            ((WaypointSet)this.wpSetRef.get()).remove((Waypoint)this.wpRef.get());
        }
        this.wpRef = nullRef;
        this.wpSetRef = nullRef;
        this.wpSpawnPoint = null;
    }

    private File getSaveFile() {
        WorldMapSession currentSession = XaeroWorldMapCore.currentSession;
        if (currentSession == null) {
            return null;
        }
        MapProcessor mapProcessor = currentSession.getMapProcessor();
        if (mapProcessor == null) {
            return null;
        }
        String worldId = mapProcessor.getCurrentWorldId();
        if (worldId == null) {
            return null;
        }
        if (WorldMap.saveFolder == null) {
            return null;
        }
        return WorldMap.saveFolder.toPath().resolve(worldId).resolve("xaeroplus-respawn-points.json").toFile();
    }

    public synchronized void loadRespawnPoints() {
        try {
            File saveFile = this.getSaveFile();
            if (saveFile == null) {
                return;
            }
            if (!saveFile.exists()) {
                return;
            }
            try (BufferedReader reader = Files.newBufferedReader(saveFile.toPath());){
                Map map = (Map)this.gson.fromJson((Reader)reader, new TypeToken<Map<UUID, SpawnPosition>>(){}.getType());
                if (map != null) {
                    this.respawnPoints.clear();
                    this.respawnPoints.putAll(map);
                }
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("[SpawnPoint] Failed to read respawn points file", (Throwable)e);
        }
    }

    public void saveRespawnPointsAsync() {
        ForkJoinPool.commonPool().execute(this::saveRespawnPoints);
    }

    public synchronized void saveRespawnPoints() {
        try {
            File saveFile = this.getSaveFile();
            if (saveFile == null) {
                return;
            }
            FileUtil.safeSave(saveFile, writer -> this.gson.toJson(this.respawnPoints, new TypeToken<Map<UUID, SpawnPosition>>(){}.getType(), (Appendable)writer));
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("[SpawnPoint] Failed to write respawn points file", (Throwable)e);
        }
    }

    public Map<UUID, SpawnPosition> getLoadedSpawnPositions() {
        return this.respawnPoints;
    }

    public record SpawnPosition(String dimensionKey, int x, int y, int z) {
        public class_2960 dimensionLocation() {
            return class_2960.method_12829((String)this.dimensionKey);
        }

        public class_5321<class_1937> dimension() {
            class_2960 dimensionLocation = this.dimensionLocation();
            if (dimensionLocation == null) {
                return null;
            }
            class_2960 ow = class_1937.field_25179.method_29177();
            class_2960 nether = class_1937.field_25180.method_29177();
            class_2960 end = class_1937.field_25181.method_29177();
            if (dimensionLocation.equals((Object)ow)) {
                return class_1937.field_25179;
            }
            if (dimensionLocation.equals((Object)nether)) {
                return class_1937.field_25180;
            }
            if (dimensionLocation.equals((Object)end)) {
                return class_1937.field_25181;
            }
            class_638 level = class_310.method_1551().field_1687;
            if (level != null && level.method_27983().method_29177().equals((Object)dimensionLocation)) {
                return level.method_27983();
            }
            return class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)dimensionLocation);
        }
    }
}

