/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.forge;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import xaero.map.gui.GuiWorldMapSettings;
import xaeroplus.XaeroPlus;
import xaeroplus.commands.XPClientCommandSource;
import xaeroplus.feature.extensions.GuiXaeroPlusWorldMapSettings;
import xaeroplus.settings.Settings;
import xaeroplus.shadow.caffeine.cache.RemovalCause;
import xaeroplus.util.XaeroPlusGameTest;

public class XaeroPlusForgeClient {
    public void init(FMLJavaModLoadingContext context, IEventBus modEventBus, IEventBus forgeEventBus) {
        modEventBus.addListener(this::onRegisterKeyMappingsEvent);
        forgeEventBus.addListener(this::onRegisterClientCommandsEvent);
        forgeEventBus.register((Object)modEventBus);
        RemovalCause explicit = RemovalCause.EXPLICIT;
        context.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> new GuiXaeroPlusWorldMapSettings((Screen)new GuiWorldMapSettings(screen), (Screen)screen)));
    }

    public void onRegisterKeyMappingsEvent(RegisterKeyMappingsEvent event) {
        if (XaeroPlus.initialized.compareAndSet(false, true)) {
            XaeroPlus.XP_VERSION = FMLLoader.getLoadingModList().getModFileById("xaeroplus").versionString();
            XaeroPlus.initializeSettings();
            Settings.REGISTRY.getKeybindings().forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
            if (System.getenv("XP_CI_TEST") != null) {
                Minecraft.getInstance().execute(XaeroPlusGameTest::applyMixinsTest);
            }
        }
    }

    public void onRegisterClientCommandsEvent(RegisterClientCommandsEvent event) {
        XaeroPlus.registerCommands((CommandDispatcher<XPClientCommandSource>)event.getDispatcher(), event.getBuildContext());
    }
}

