/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import xaeroplus.Globals;
import xaeroplus.event.ChunkDataEvent;
import xaeroplus.feature.highlights.SavableHighlightCacheInstance;
import xaeroplus.feature.render.DrawFeatureFactory;
import xaeroplus.module.Module;
import xaeroplus.shadow.lambdaevents.EventHandler;
import xaeroplus.util.ChunkScanner;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class LavaColumns
extends Module {
    public final SavableHighlightCacheInstance lavaColumnsCache = new SavableHighlightCacheInstance("XaeroPlusLavaColumns");
    private int minColumnHeight = 5;
    private int alphaStep = 8;
    private int alphaShift = 0;
    private int color = ColorHelper.getColor(0, 255, 0, 255);
    private static final ReferenceSet<Block> lavaFilter = ReferenceSet.of((Object)Blocks.LAVA);

    public void setDiskCache(boolean disk) {
        this.lavaColumnsCache.setDiskCache(disk, this.isEnabled());
    }

    @EventHandler
    public void onChunkData(ChunkDataEvent event) {
        ClientLevel level = this.mc.level;
        if (level == null || this.mc.levelRenderer.viewArea == null) {
            return;
        }
        LevelChunk chunk = event.chunk();
        ChunkPos chunkPos = chunk.getPos();
        if (ChunkUtils.getActualDimension() != Level.NETHER) {
            return;
        }
        if (this.lavaColumnsCache.get().isHighlighted(chunkPos.x, chunkPos.z, ChunkUtils.getActualDimension())) {
            return;
        }
        AtomicInteger maxHeight = new AtomicInteger(0);
        ChunkScanner.chunkScanBlockstatePredicate((ChunkAccess)chunk, lavaFilter, (c, state, relX, y, relZ) -> {
            int x = ChunkUtils.chunkCoordToCoord(c.getPos().x) + relX;
            int z = ChunkUtils.chunkCoordToCoord(c.getPos().z) + relZ;
            int maxY = level.getMaxBuildHeight();
            FluidState fluid = state.getFluidState();
            if (!fluid.isEmpty() && !fluid.isSource()) {
                FluidState aboveState;
                int columnHeight = 1;
                for (int yy = y + 1; yy <= maxY && !(aboveState = chunk.getFluidState(x, yy, z)).isEmpty() && !aboveState.isSource(); ++yy) {
                    ++columnHeight;
                }
                if (columnHeight >= maxHeight.get()) {
                    maxHeight.set(columnHeight);
                }
            }
            return false;
        }, 0);
        this.lavaColumnsCache.get().addHighlight(chunk.getPos().x, chunk.getPos().z, maxHeight.get());
    }

    @Override
    public void onEnable() {
        Globals.drawManager.registry().register(DrawFeatureFactory.multiColorChunkHighlights("LavaColumns", this::getLavaColumnHeightHighlights, this::colorFunction, 250));
        this.lavaColumnsCache.onEnable();
    }

    private Long2LongMap getLavaColumnHeightHighlights(ResourceKey<Level> dim) {
        return this.lavaColumnsCache.get().getCacheMap(dim);
    }

    private int colorFunction(long pos, long columnHeight) {
        if (columnHeight < (long)this.minColumnHeight) {
            return 0;
        }
        int alpha = Mth.clamp((int)(this.alphaShift + (int)columnHeight * this.alphaStep), (int)0, (int)255);
        return ColorHelper.getColorWithAlpha(this.color, alpha);
    }

    @Override
    public void onDisable() {
        this.lavaColumnsCache.onDisable();
        Globals.drawManager.registry().unregister("LavaColumns");
    }

    public void setMinColumnHeight(int minHeight) {
        this.minColumnHeight = minHeight;
    }

    public void setAlphaStep(int alphaStep) {
        this.alphaStep = alphaStep;
    }

    public void setRgbColor(int color) {
        this.color = color;
    }

    public void setAlphaShift(int alphaShift) {
        this.alphaShift = alphaShift;
    }
}

