/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.waypoint.eta;

import net.minecraft.client.Minecraft;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.shadow.kaptainwutax.mathutils.util.Mth;
import xaeroplus.shadow.lambdaevents.EventHandler;
import xaeroplus.util.timer.Timer;
import xaeroplus.util.timer.Timers;

public class WaypointEtaManager {
    public static final WaypointEtaManager INSTANCE = new WaypointEtaManager();
    private final Timer measurementTimer = Timers.tickTimer();
    private int measurementInterval = 20;
    private double lastX = 0.0;
    private double lastZ = 0.0;
    private double speedBlocksPerSecond = 0.0;

    private WaypointEtaManager() {
        XaeroPlus.EVENT_BUS.register(this);
    }

    @EventHandler
    public void onClickTick(ClientTickEvent.Post event) {
        if (!this.measurementTimer.tick(this.measurementInterval)) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        double currentX = mc.player.getX();
        double currentZ = mc.player.getZ();
        double dist = Math.hypot(currentX - this.lastX, currentZ - this.lastZ);
        this.lastX = currentX;
        this.lastZ = currentZ;
        double measurementMs = (double)(this.measurementInterval + 1) * 50.0;
        double measurementSeconds = measurementMs / 1000.0;
        if (measurementSeconds <= 0.0) {
            return;
        }
        this.speedBlocksPerSecond = dist / measurementSeconds;
    }

    public long getEtaSecondsToReachWaypoint(Waypoint waypoint) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return 0L;
        }
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession == null) {
            return 0L;
        }
        double dimDiv = minimapSession.getDimensionHelper().getDimensionDivision(minimapSession.getWorldManager().getCurrentWorld());
        int wpX = waypoint.getX(dimDiv);
        int wpZ = waypoint.getZ(dimDiv);
        double wpDist = Math.hypot((double)wpX - mc.player.getX(), (double)wpZ - mc.player.getZ());
        double etaSeconds = wpDist / this.speedBlocksPerSecond;
        if (etaSeconds == Double.POSITIVE_INFINITY || etaSeconds == Double.NEGATIVE_INFINITY || Double.isNaN(etaSeconds)) {
            return 0L;
        }
        return (long)etaSeconds;
    }

    public String getEtaTextSuffix(Waypoint waypoint) {
        long eta = this.getEtaSecondsToReachWaypoint(waypoint);
        if (eta <= 0L) {
            return "";
        }
        Object etaText = " - ";
        if (eta > 86400L) {
            int days = (int)(eta / 86400L);
            int hours = (int)(eta % 86400L / 3600L);
            etaText = (String)etaText + days + "d";
            if (hours > 0) {
                etaText = (String)etaText + " " + hours + "h";
            }
        } else if (eta > 3600L) {
            int hours = (int)(eta / 3600L);
            int minutes = (int)(eta % 3600L / 60L);
            etaText = (String)etaText + hours + "h";
            if (minutes > 0) {
                etaText = (String)etaText + " " + minutes + "m";
            }
        } else if (eta > 60L) {
            int minutes = (int)(eta / 60L);
            int seconds = (int)(eta % 60L);
            etaText = (String)etaText + minutes + "m";
            if (seconds > 0) {
                etaText = (String)etaText + " " + seconds + "s";
            }
        } else {
            etaText = (String)etaText + eta + "s";
        }
        return etaText;
    }

    public void updateMeasurementInterval(int interval) {
        this.measurementInterval = Mth.max(0, interval);
        this.measurementTimer.reset();
        this.speedBlocksPerSecond = 0.0;
    }
}

