/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.shaders;

import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.render.shaders.HighlightShader;
import xaeroplus.feature.render.shaders.MultiColorHighlightShader;

public class XaeroPlusShaders {
    public static HighlightShader HIGHLIGHT_SHADER = null;
    public static MultiColorHighlightShader MULTI_COLOR_HIGHLIGHT_SHADER = null;
    private static boolean firstReload = true;

    public static void onResourceReload(ResourceManager resourceManager) {
        try {
            if (HIGHLIGHT_SHADER != null) {
                HIGHLIGHT_SHADER.close();
            }
            if (MULTI_COLOR_HIGHLIGHT_SHADER != null) {
                MULTI_COLOR_HIGHLIGHT_SHADER.close();
            }
            HIGHLIGHT_SHADER = new HighlightShader((ResourceProvider)resourceManager);
            MULTI_COLOR_HIGHLIGHT_SHADER = new MultiColorHighlightShader((ResourceProvider)resourceManager);
            XaeroPlus.LOGGER.info("Reloaded Shaders");
        }
        catch (Exception e) {
            if (firstReload) {
                throw new RuntimeException("Failed reloading shaders");
            }
            XaeroPlus.LOGGER.error("Error in shader reloader", (Throwable)e);
        }
        firstReload = false;
    }

    public static void ensureShaders() {
        if ((HIGHLIGHT_SHADER == null || MULTI_COLOR_HIGHLIGHT_SHADER == null) && firstReload) {
            XaeroPlusShaders.onResourceReload(Minecraft.getInstance().getResourceManager());
        }
    }
}

