/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaeroplus.Globals;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.feature.highlights.SavableHighlightCacheInstance;
import xaeroplus.feature.render.DrawFeatureFactory;
import xaeroplus.module.Module;
import xaeroplus.settings.Settings;
import xaeroplus.shadow.lambdaevents.EventHandler;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class Breadcrumbs
extends Module {
    public final SavableHighlightCacheInstance breadcrumbsCache = new SavableHighlightCacheInstance("XaeroPlusBreadcrumbs");
    private int breadcrumbsColor = ColorHelper.getColor(0, 255, 0, 100);
    private int chunkRadius = 0;

    public void setDiskCache(boolean disk) {
        this.breadcrumbsCache.setDiskCache(disk, this.isEnabled());
    }

    @EventHandler
    public void onTick(ClientTickEvent.Post event) {
        ResourceKey<Level> dim = ChunkUtils.getActualDimension();
        int playerChunkX = ChunkUtils.actualPlayerChunkX();
        int playerChunkZ = ChunkUtils.actualPlayerChunkZ();
        for (int x = playerChunkX - this.chunkRadius; x <= playerChunkX + this.chunkRadius; ++x) {
            for (int z = playerChunkZ - this.chunkRadius; z <= playerChunkZ + this.chunkRadius; ++z) {
                if (this.breadcrumbsCache.get().isHighlighted(x, z, dim)) continue;
                this.breadcrumbsCache.get().addHighlight(x, z);
            }
        }
    }

    @Override
    public void onEnable() {
        Globals.drawManager.registry().register(DrawFeatureFactory.chunkHighlights("Breadcrumbs", this::getHighlightsState, this::getBreadcrumbsColor, 50));
        this.breadcrumbsCache.onEnable();
    }

    @Override
    public void onDisable() {
        this.breadcrumbsCache.onDisable();
        Globals.drawManager.registry().unregister("Breadcrumbs");
    }

    public Long2LongMap getHighlightsState(ResourceKey<Level> dimension) {
        return this.breadcrumbsCache.get().getCacheMap(dimension);
    }

    public int getBreadcrumbsColor() {
        return this.breadcrumbsColor;
    }

    public void setRgbColor(int color) {
        this.breadcrumbsColor = ColorHelper.getColorWithAlpha(color, Settings.REGISTRY.breadcrumbsOpacitySetting.getAsInt());
    }

    public void setAlpha(double alpha) {
        this.breadcrumbsColor = ColorHelper.getColorWithAlpha(this.breadcrumbsColor, (int)alpha);
    }

    public void setChunkRadius(double chunkRadius) {
        this.chunkRadius = (int)chunkRadius;
    }
}

