/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.buffered;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class Model {
    private final GpuBuffer vertexBuffer;
    private int indexCount = 0;

    public Model(Vector3f[] posMatrix, Vector2f[] texUvMatrix) {
        RenderSystem.assertOnRenderThread();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        for (int i = 0; i < posMatrix.length; ++i) {
            Vector3f pos = posMatrix[i];
            Vector2f uv = texUvMatrix[i];
            bufferbuilder.addVertex(pos.x(), pos.y(), pos.z()).setUv(uv.x(), uv.y());
        }
        try (MeshData renderedBuffer = bufferbuilder.buildOrThrow();){
            this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "XaeroPlus Buffered Minimap Model", BufferType.VERTICES, BufferUsage.STATIC_WRITE, renderedBuffer.vertexBuffer());
            this.indexCount = renderedBuffer.drawState().indexCount();
        }
    }

    public void draw(RenderPass renderPass, GpuBuffer indexBuffer, VertexFormat.IndexType indexType) {
        renderPass.setVertexBuffer(0, this.vertexBuffer);
        renderPass.setIndexBuffer(indexBuffer, indexType);
        renderPass.drawIndexed(0, this.indexCount);
    }

    public void close() {
        this.vertexBuffer.close();
    }

    public int getIndexCount() {
        return this.indexCount;
    }
}

