/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlight;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import xaeroplus.feature.render.DrawContext;
import xaeroplus.feature.render.highlight.AbstractHighlightVertexBuffer;
import xaeroplus.feature.render.shaders.XaeroPlusShaders;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class HighlightVertexBuffer
extends AbstractHighlightVertexBuffer {
    @Override
    public void preRender(DrawContext ctx, Long2LongMap highlights, int color) {
        super.preRender(ctx, highlights, color);
    }

    @Override
    public void refresh(DrawContext ctx, Long2LongMap highlights, int color) {
        this.stale = false;
        this.lastRefreshed = System.currentTimeMillis();
        this.flipped = ctx.worldmap();
        if (highlights.isEmpty() || ColorHelper.getA(color) == 0.0f) {
            this.close();
            return;
        }
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        for (Long highlight : highlights.keySet()) {
            int chunkPosX = ChunkUtils.longToChunkX(highlight);
            int chunkPosZ = ChunkUtils.longToChunkZ(highlight);
            float x1 = chunkPosX;
            float x2 = chunkPosX + 1;
            float y1 = this.flipped ? (float)(chunkPosZ + 1) : (float)chunkPosZ;
            float y2 = this.flipped ? (float)chunkPosZ : (float)(chunkPosZ + 1);
            bufferBuilder.addVertex(x1, y2, 0.0f);
            bufferBuilder.addVertex(x2, y2, 0.0f);
            bufferBuilder.addVertex(x2, y1, 0.0f);
            bufferBuilder.addVertex(x1, y1, 0.0f);
        }
        try (MeshData meshData = bufferBuilder.buildOrThrow();){
            this.close();
            this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Chunk Highlight Buffer", BufferType.VERTICES, BufferUsage.STATIC_WRITE, meshData.vertexBuffer());
            this.indexCount = meshData.drawState().indexCount();
        }
    }

    @Override
    public void render(DrawContext ctx, Long2LongMap highlights, int color) {
        if (this.vertexBuffer == null || this.vertexBuffer.isClosed()) {
            return;
        }
        RenderSystem.AutoStorageIndexBuffer autoIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS);
        VertexFormat.IndexType indexType = autoIndexBuffer.type();
        GpuBuffer indexBuffer = autoIndexBuffer.getBuffer(this.indexCount);
        try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(Minecraft.getInstance().getMainRenderTarget().getColorTexture(), OptionalInt.empty());){
            pass.setPipeline(XaeroPlusShaders.HIGHLIGHT_PIPELINE);
            pass.setUniform("MapViewMatrix", ctx.matrixStack().last().pose());
            pass.setUniform("ModelViewMat", RenderSystem.getModelViewMatrix());
            pass.setUniform("ProjMat", RenderSystem.getProjectionMatrix());
            float a = ColorHelper.getA(color);
            float r = ColorHelper.getR(color);
            float g = ColorHelper.getG(color);
            float b = ColorHelper.getB(color);
            pass.setUniform("HighlightColor", new float[]{r, g, b, a});
            pass.setIndexBuffer(indexBuffer, indexType);
            pass.setVertexBuffer(0, this.vertexBuffer);
            pass.drawIndexed(0, this.indexCount);
        }
    }
}

