/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlight;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import xaeroplus.feature.render.DrawContext;
import xaeroplus.feature.render.highlight.AbstractHighlightVertexBuffer;
import xaeroplus.feature.render.highlight.MultiColorHighlightColorFunction;
import xaeroplus.feature.render.shaders.XaeroPlusShaders;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class MultiColorHighlightVertexBuffer
extends AbstractHighlightVertexBuffer {
    private final MultiColorHighlightColorFunction colorFunction;

    public MultiColorHighlightVertexBuffer(MultiColorHighlightColorFunction colorFunction) {
        this.colorFunction = colorFunction;
    }

    @Override
    public void preRender(DrawContext ctx, Long2LongMap highlights, int color) {
        super.preRender(ctx, highlights, color);
    }

    @Override
    public void refresh(DrawContext ctx, Long2LongMap highlights, int colorAlpha) {
        this.stale = false;
        this.lastRefreshed = System.currentTimeMillis();
        this.flipped = ctx.worldmap();
        if (highlights.isEmpty()) {
            this.close();
            return;
        }
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        ObjectIterator it = Long2LongMaps.fastIterator((Long2LongMap)highlights);
        while (it.hasNext()) {
            long foundTime;
            Long2LongMap.Entry entry = (Long2LongMap.Entry)it.next();
            long pos = entry.getLongKey();
            int color = this.colorFunction.getColor(pos, foundTime = entry.getLongValue());
            int alpha = ColorHelper.getIntA(color);
            if (alpha == 0) continue;
            int chunkPosX = ChunkUtils.longToChunkX(pos);
            int chunkPosZ = ChunkUtils.longToChunkZ(pos);
            float x1 = chunkPosX;
            float x2 = chunkPosX + 1;
            float y1 = this.flipped ? (float)(chunkPosZ + 1) : (float)chunkPosZ;
            float y2 = this.flipped ? (float)chunkPosZ : (float)(chunkPosZ + 1);
            bufferBuilder.addVertex(x1, y2, 0.0f).setColor(color);
            bufferBuilder.addVertex(x2, y2, 0.0f).setColor(color);
            bufferBuilder.addVertex(x2, y1, 0.0f).setColor(color);
            bufferBuilder.addVertex(x1, y1, 0.0f).setColor(color);
        }
        MeshData meshData = bufferBuilder.build();
        if (meshData == null) {
            this.close();
            return;
        }
        try (MeshData meshData2 = meshData;){
            this.close();
            this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Multi Color Chunk Highlight Buffer", BufferType.VERTICES, BufferUsage.STATIC_WRITE, meshData.vertexBuffer());
            this.indexCount = meshData.drawState().indexCount();
        }
    }

    @Override
    public void render(DrawContext ctx, Long2LongMap highlights, int color) {
        if (this.vertexBuffer == null || this.vertexBuffer.isClosed()) {
            return;
        }
        RenderSystem.AutoStorageIndexBuffer autoIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS);
        VertexFormat.IndexType indexType = autoIndexBuffer.type();
        GpuBuffer indexBuffer = autoIndexBuffer.getBuffer(this.indexCount);
        try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(Minecraft.getInstance().getMainRenderTarget().getColorTexture(), OptionalInt.empty());){
            pass.setPipeline(XaeroPlusShaders.MULTI_COLOR_HIGHLIGHT_PIPELINE);
            pass.setUniform("MapViewMatrix", ctx.matrixStack().last().pose());
            pass.setUniform("ModelViewMat", RenderSystem.getModelViewMatrix());
            pass.setUniform("ProjMat", RenderSystem.getProjectionMatrix());
            pass.setIndexBuffer(indexBuffer, indexType);
            pass.setVertexBuffer(0, this.vertexBuffer);
            pass.drawIndexed(0, this.indexCount);
        }
    }
}

