/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.shadow.kaptainwutax.biomeutils.source;

import xaeroplus.shadow.kaptainwutax.biomeutils.biome.Biome;
import xaeroplus.shadow.kaptainwutax.biomeutils.source.EndBiomeSource;
import xaeroplus.shadow.kaptainwutax.biomeutils.source.NetherBiomeSource;
import xaeroplus.shadow.kaptainwutax.biomeutils.source.OverworldBiomeSource;
import xaeroplus.shadow.kaptainwutax.mcutils.state.Dimension;
import xaeroplus.shadow.kaptainwutax.mcutils.util.pos.BPos;
import xaeroplus.shadow.kaptainwutax.mcutils.version.MCVersion;

public abstract class BiomeSource {
    private final MCVersion version;
    private final long worldSeed;

    public BiomeSource(MCVersion version, long worldSeed) {
        this.version = version;
        this.worldSeed = worldSeed;
    }

    public static Factory factory(Dimension dimension) {
        if (dimension == Dimension.OVERWORLD) {
            return OverworldBiomeSource::new;
        }
        if (dimension == Dimension.NETHER) {
            return NetherBiomeSource::new;
        }
        if (dimension == Dimension.END) {
            return EndBiomeSource::new;
        }
        return null;
    }

    public static BiomeSource of(Dimension dimension, MCVersion version, long worldSeed) {
        Factory factory = BiomeSource.factory(dimension);
        return factory == null ? null : factory.create(version, worldSeed);
    }

    public MCVersion getVersion() {
        return this.version;
    }

    public long getWorldSeed() {
        return this.worldSeed;
    }

    public abstract Dimension getDimension();

    public abstract Biome getBiome(BPos var1);

    public abstract Biome getBiome(int var1, int var2, int var3);

    public abstract Biome getBiomeForNoiseGen(int var1, int var2, int var3);

    @FunctionalInterface
    public static interface Factory {
        public BiomeSource create(MCVersion var1, long var2);
    }
}

