/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.extensions;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import xaero.map.gui.ScreenSwitchSettingEntry;
import xaeroplus.module.impl.TickTaskExecutor;
import xaeroplus.settings.Settings;
import xaeroplus.util.ColorHelper;
import xaeroplus.util.DrawOrderHelper;

public class DrawOrderScreen
extends Screen {
    static Minecraft mc = Minecraft.m_91087_();
    Screen parent;
    DrawFeatureList drawFeatureList;
    List<String> drawFeatureIdOrder;
    int selected;

    public DrawOrderScreen(Screen parent, Screen escapeScreen) {
        super((Component)Component.m_237115_((String)"xaeroplus.gui.draw_order.title"));
        this.parent = parent;
        this.drawFeatureIdOrder = new ArrayList<String>();
        this.selected = -1;
    }

    public void m_7856_() {
        this.drawFeatureIdOrder = this.loadEntries();
        this.drawFeatureList = new DrawFeatureList(this);
        this.m_7787_((GuiEventListener)this.drawFeatureList);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), b -> mc.m_91152_(this.parent)).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 34, 200, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"xaeroplus.gui.draw_order.reset"), b -> TickTaskExecutor.INSTANCE.execute(() -> {
            Settings.REGISTRY.drawOrderSetting.setValue("");
            this.m_6575_(mc, this.f_96543_, this.f_96544_);
        })).m_252987_(this.f_96543_ - 82, 2, 80, 20).m_253136_());
        if (!this.drawFeatureIdOrder.isEmpty()) {
            this.selected = 0;
            this.drawFeatureList.m_7522_((GuiEventListener)this.drawFeatureList.m_264567_());
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.drawFeatureList != null) {
            this.drawFeatureList.releaseDrag();
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.drawFeatureList.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280653_(DrawOrderScreen.mc.f_91062_, this.f_96539_, this.f_96543_ / 2, 5, -1);
        guiGraphics.m_280653_(DrawOrderScreen.mc.f_91062_, (Component)Component.m_237115_((String)"xaeroplus.gui.draw_order.subtitle"), this.f_96543_ / 2, this.f_96544_ - 52, -1);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public List<String> loadEntries() {
        return DrawOrderHelper.load();
    }

    public void saveEntries(List<String> entries) {
        Settings.REGISTRY.drawOrderSetting.setValue(DrawOrderHelper.serialize(entries));
    }

    public static ScreenSwitchSettingEntry getScreenSwitchSettingEntry() {
        return new ScreenSwitchSettingEntry("Draw Order", DrawOrderScreen::new, null, true);
    }

    public static class DrawFeatureList
    extends ObjectSelectionList<DrawFeatureEntry> {
        boolean dragging;
        int dragStartX;
        int dragStartY;
        int dragged;
        int draggedOffsetX;
        int draggedOffsetY;
        DrawOrderScreen drawOrderScreen;

        public DrawFeatureList(DrawOrderScreen drawOrderScreen) {
            super(mc, drawOrderScreen.f_96543_, drawOrderScreen.f_96544_, 30, drawOrderScreen.f_96544_ - 61, 24);
            this.drawOrderScreen = drawOrderScreen;
            this.dragged = -1;
            this.createEntries().forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
            if (drawOrderScreen.selected != -1) {
                this.m_7522_((GuiEventListener)this.m_93500_(drawOrderScreen.selected));
            }
        }

        public boolean m_93696_() {
            return this.drawOrderScreen.m_7222_() == this;
        }

        public void m_7522_(GuiEventListener guiEventListener) {
            if (guiEventListener instanceof DrawFeatureEntry) {
                DrawFeatureEntry entry = (DrawFeatureEntry)guiEventListener;
                this.drawOrderScreen.selected = entry.index;
            }
            if (guiEventListener == null) {
                this.drawOrderScreen.selected = -1;
            }
            super.m_7522_(guiEventListener);
            if (this.m_7222_() == null) {
                this.m_6987_(null);
            }
        }

        List<DrawFeatureEntry> createEntries() {
            ArrayList<DrawFeatureEntry> entries = new ArrayList<DrawFeatureEntry>();
            for (int i = 0; i < this.drawOrderScreen.drawFeatureIdOrder.size(); ++i) {
                DrawFeatureEntry entry = new DrawFeatureEntry(this.drawOrderScreen, this, i);
                entries.add(entry);
            }
            return entries;
        }

        void releaseDrag() {
            this.dragging = false;
            this.dragged = -1;
            this.drawOrderScreen.saveEntries(this.drawOrderScreen.drawFeatureIdOrder);
        }

        public int m_5756_() {
            return this.f_93388_ / 2 + 164;
        }

        public int m_5759_() {
            return 300;
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            this.m_93488_(false);
            this.m_93496_(false);
            this.renderBackdrop(guiGraphics);
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            if (this.dragging) {
                int hoveredIndex;
                DrawFeatureEntry draggedEntry = (DrawFeatureEntry)this.m_93500_(this.dragged);
                draggedEntry.renderEntryText(guiGraphics, mouseX + this.draggedOffsetX, mouseY + this.draggedOffsetY);
                DrawFeatureEntry hoveredEntry = (DrawFeatureEntry)this.m_93412_(mouseX, mouseY);
                int n = hoveredIndex = hoveredEntry == null ? -1 : hoveredEntry.index;
                if (hoveredIndex != -1 && hoveredIndex != this.dragged) {
                    String draggedId = this.drawOrderScreen.drawFeatureIdOrder.get(this.dragged);
                    int slideDirection = hoveredIndex < this.dragged ? 1 : -1;
                    for (int i = this.dragged; i != hoveredIndex; i -= slideDirection) {
                        this.drawOrderScreen.drawFeatureIdOrder.set(i, this.drawOrderScreen.drawFeatureIdOrder.get(i - slideDirection));
                    }
                    this.drawOrderScreen.drawFeatureIdOrder.set(hoveredIndex, draggedId);
                    this.dragged = hoveredIndex;
                }
            } else if (this.dragged != -1 && (Math.abs(mouseX - this.dragStartX) > 5 || Math.abs(mouseY - this.dragStartY) > 5)) {
                this.dragging = true;
                this.m_7522_(null);
            }
        }

        public void renderBackdrop(GuiGraphics guiGraphics) {
            guiGraphics.m_280509_(0, 0, this.f_93388_, this.f_93389_, ColorHelper.getColor(0, 0, 0, 100));
        }
    }

    public static class DrawFeatureEntry
    extends ObjectSelectionList.Entry<DrawFeatureEntry> {
        DrawOrderScreen drawOrderScreen;
        DrawFeatureList drawFeatureList;
        int index;
        int lastRenderX;
        int lastRenderY;
        int lastMouseX;
        int lastMouseY;

        public DrawFeatureEntry(DrawOrderScreen drawOrderScreen, DrawFeatureList drawFeatureList, int index) {
            this.drawOrderScreen = drawOrderScreen;
            this.drawFeatureList = drawFeatureList;
            this.index = index;
        }

        public void renderEntryText(GuiGraphics guiGraphics, int x, int y) {
            String id = this.drawOrderScreen.drawFeatureIdOrder.get(this.index);
            guiGraphics.m_280488_(DrawOrderScreen.mc.f_91062_, id, x + 6, y + 6, -1);
        }

        public Component m_142172_() {
            return Component.m_237119_();
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.lastRenderX = x;
            this.lastRenderY = y;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            if (!this.drawFeatureList.dragging || this.drawFeatureList.dragged != index) {
                this.renderEntryText(guiGraphics, x, y);
            }
        }

        public void m_274437_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            if (this.drawFeatureList.m_93511_() != this) {
                guiGraphics.m_280509_(left - 2, top, left - 2 + width, top + height, ColorHelper.getColor(0, 0, 0, 150));
                guiGraphics.m_280637_(left - 2, top, width, height, ColorHelper.getColor(68, 68, 68, 255));
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.drawFeatureList.dragging = false;
                this.drawFeatureList.dragged = this.index;
                this.drawFeatureList.draggedOffsetX = (int)((double)this.lastRenderX - mouseX);
                this.drawFeatureList.draggedOffsetY = (int)((double)this.lastRenderY - mouseY);
                this.drawFeatureList.dragStartX = (int)mouseX;
                this.drawFeatureList.dragStartY = (int)mouseY;
                if (this.drawFeatureList.m_93511_() != this) {
                    return true;
                }
                this.drawFeatureList.m_7522_(null);
            } else {
                this.drawFeatureList.m_7522_(null);
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        public void m_94757_(double mouseX, double mouseY) {
            this.lastMouseX = (int)mouseX;
            this.lastMouseY = (int)mouseY;
            super.m_94757_(mouseX, mouseY);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            this.lastMouseX = (int)mouseX;
            this.lastMouseY = (int)mouseY;
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
    }
}

