/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.highlights;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaeroplus.XaeroPlus;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.highlights.ChunkHighlightBaseCacheHandler;

public class ChunkHighlightLocalCache
extends ChunkHighlightBaseCacheHandler {
    private static final int maxNumber = 5000;

    @Override
    public void addHighlight(int x, int z) {
        super.addHighlight(x, z);
        this.limitChunksSize();
    }

    @Override
    public void addHighlight(int x, int z, long foundTime) {
        super.addHighlight(x, z, foundTime);
        this.limitChunksSize();
    }

    private void limitChunksSize() {
        try {
            if (this.chunks.size() > 5000) {
                long[] toRemove = this.chunks.long2LongEntrySet().stream().sorted(Map.Entry.comparingByValue()).limit(500L).mapToLong(Long2LongMap.Entry::getLongKey).toArray();
                for (int i = 0; i < toRemove.length; ++i) {
                    this.chunks.remove(toRemove[i]);
                }
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error limiting local cache size", (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Long2LongMap> getHighlightsInCustomWindow(int windowRegionX, int windowRegionZ, int windowRegionSize, ResourceKey<Level> dimension) {
        return this.submitTickTask(() -> new Long2LongOpenHashMap(this.chunks));
    }

    @Override
    public void handleWorldChange(XaeroWorldChangeEvent event) {
        this.chunks.clear();
    }

    @Override
    public void handleTick() {
    }

    @Override
    public void onEnable() {
    }

    @Override
    public void onDisable() {
    }
}

