/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.settings;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import org.apache.commons.lang3.ArrayUtils;
import xaero.common.graphics.CursorBox;
import xaero.common.settings.ModOptions;
import xaeroplus.XaeroPlus;
import xaeroplus.mixin.client.AccessorMinimapModOptions;
import xaeroplus.mixin.client.AccessorWorldMapModOptions;
import xaeroplus.settings.XaeroPlusSetting;

public class EnumSetting<T extends Enum<T>>
extends XaeroPlusSetting {
    private final T[] enumValues;
    private T value;
    private Consumer<T> settingChangeConsumer;

    private EnumSetting(String settingName, String settingNameTranslationKey, String tooltipTranslationKey, KeyMapping keyBinding, T[] enumValues, T defaultValue, Consumer<T> settingChangeConsumer, BooleanSupplier visibilitySupplier) {
        super(settingName, settingNameTranslationKey, tooltipTranslationKey, keyBinding, visibilitySupplier);
        this.enumValues = enumValues;
        this.value = defaultValue;
        this.settingChangeConsumer = settingChangeConsumer;
    }

    public static <E extends Enum<E>> EnumSetting<E> create(String settingName, String settingNameTranslationKey, E[] values, E defaultValue) {
        return new EnumSetting("[XP] " + settingName, settingNameTranslationKey, EnumSetting.buildTooltipTranslationKey(settingNameTranslationKey), null, values, defaultValue, null, null);
    }

    public static <E extends Enum<E>> EnumSetting<E> create(String settingName, String settingNameTranslationKey, E[] values, E defaultValue, Consumer<E> settingChangeConsumer) {
        return new EnumSetting("[XP] " + settingName, settingNameTranslationKey, EnumSetting.buildTooltipTranslationKey(settingNameTranslationKey), null, values, defaultValue, settingChangeConsumer, null);
    }

    public static <E extends Enum<E>> EnumSetting<E> create(String settingName, String settingNameTranslationKey, E[] values, E defaultValue, Consumer<E> settingChangeConsumer, BooleanSupplier visibilitySupplier) {
        return new EnumSetting("[XP] " + settingName, settingNameTranslationKey, EnumSetting.buildTooltipTranslationKey(settingNameTranslationKey), null, values, defaultValue, settingChangeConsumer, visibilitySupplier);
    }

    @Override
    public String getSerializedValue() {
        return Integer.toString(this.getValueIndex());
    }

    @Override
    public void deserializeValue(String value) {
        int index = Integer.parseInt(value);
        if (index != this.getValueIndex()) {
            this.setValueIndex(index);
        }
    }

    @Override
    public ModOptions toMinimapModOptions() {
        return AccessorMinimapModOptions.createEnumSetting(this.getSettingName(), 0, this.getIndexMax(), new CursorBox(this.getTooltipTranslationKey()), this.isIngameOnly());
    }

    @Override
    public xaero.map.settings.ModOptions toWorldMapModOptions() {
        return AccessorWorldMapModOptions.createEnumSetting(this.getSettingName(), this.getIndexMax() + 1, new xaero.map.gui.CursorBox(this.getTooltipTranslationKey()), this.isIngameOnly(), this.isRequiresMinimap(), false);
    }

    public T get() {
        return this.value;
    }

    public void setValue(T newVal) {
        this.value = newVal;
        if (Objects.nonNull(this.getSettingChangeConsumer())) {
            try {
                this.getSettingChangeConsumer().accept(newVal);
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.error("Error applying setting change consumer for setting: {}, value: {}", new Object[]{this.getSettingName(), newVal, e});
            }
        }
    }

    public int getValueIndex() {
        return ArrayUtils.indexOf((Object[])this.enumValues, this.get());
    }

    public void setValueIndex(int index) {
        try {
            this.setValue(this.enumValues[index]);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Unable to set enum value setting for {}, index {}", new Object[]{this.getSettingName(), index, e});
        }
    }

    public int getIndexMax() {
        return this.enumValues.length - 1;
    }

    public void setSettingChangeConsumer(Consumer<T> settingChangeConsumer) {
        this.settingChangeConsumer = settingChangeConsumer;
    }

    public Consumer<T> getSettingChangeConsumer() {
        return this.settingChangeConsumer;
    }

    public T[] getEnumValues() {
        return this.enumValues;
    }

    @Override
    public void init() {
        if (Objects.nonNull(this.settingChangeConsumer)) {
            this.settingChangeConsumer.accept(this.value);
        }
    }
}

