/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.shadow.lambdaevents.generator;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import xaeroplus.shadow.lambdaevents.AHandler;
import xaeroplus.shadow.lambdaevents.EventHandler;
import xaeroplus.shadow.lambdaevents.IGenerator;
import xaeroplus.shadow.lambdaevents.handler.ConsumerHandler;
import xaeroplus.shadow.lambdaevents.handler.RunnableHandler;
import xaeroplus.shadow.lambdaevents.utils.LookupUtils;

public class LambdaMetaFactoryGenerator
implements IGenerator {
    private final MethodHandles.Lookup lookup;

    public LambdaMetaFactoryGenerator() {
        this(MethodHandles.lookup());
    }

    public LambdaMetaFactoryGenerator(@Nonnull MethodHandles.Lookup lookup) {
        this.lookup = lookup;
    }

    @Override
    @Nonnull
    public AHandler generate(Class<?> owner, @Nullable Object instance, EventHandler annotation, Method method, Class<?> arg) {
        Consumer consumer = this.generate(owner, instance, method, Consumer.class, "accept", MethodType.methodType(Void.TYPE, Object.class));
        return new ConsumerHandler(owner, instance, annotation, consumer);
    }

    @Override
    @Nonnull
    public AHandler generateVirtual(Class<?> owner, @Nullable Object instance, EventHandler annotation, Method method) {
        Runnable runnable = this.generate(owner, instance, method, Runnable.class, "run", MethodType.methodType(Void.TYPE));
        return new RunnableHandler(owner, instance, annotation, runnable);
    }

    private <T> T generate(Class<?> owner, @Nullable Object instance, Method method, Class<T> interfaceClass, String interfaceMethod, MethodType interfaceType) {
        MethodHandles.Lookup lookup = LookupUtils.resolveLookup(this.lookup, owner);
        MethodHandle handle = lookup.unreflect(method);
        if (instance == null) {
            return (T)LambdaMetafactory.metafactory(lookup, interfaceMethod, MethodType.methodType(interfaceClass), interfaceType, handle, handle.type()).getTarget().invoke();
        }
        return (T)LambdaMetafactory.metafactory(lookup, interfaceMethod, MethodType.methodType(interfaceClass, instance.getClass()), interfaceType, handle, handle.type().dropParameterTypes(0, 1)).getTarget().invoke(instance);
    }
}

