/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.buffered;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_9801;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class Model {
    private final GpuBuffer vertexBuffer;
    private int indexCount = 0;

    public Model(Vector3f[] posMatrix, Vector2f[] texUvMatrix) {
        RenderSystem.assertOnRenderThread();
        class_287 bufferbuilder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1585);
        for (int i = 0; i < posMatrix.length; ++i) {
            Vector3f pos = posMatrix[i];
            Vector2f uv = texUvMatrix[i];
            bufferbuilder.method_22912(pos.x(), pos.y(), pos.z()).method_22913(uv.x(), uv.y());
        }
        try (class_9801 renderedBuffer = bufferbuilder.method_60800();){
            this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "XaeroPlus Buffered Minimap Model", BufferType.VERTICES, BufferUsage.STATIC_WRITE, renderedBuffer.method_60818());
            this.indexCount = renderedBuffer.method_60822().comp_751();
        }
    }

    public void draw(RenderPass renderPass, GpuBuffer indexBuffer, VertexFormat.class_5595 indexType) {
        renderPass.setVertexBuffer(0, this.vertexBuffer);
        renderPass.setIndexBuffer(indexBuffer, indexType);
        renderPass.drawIndexed(0, this.indexCount);
    }

    public void close() {
        this.vertexBuffer.close();
    }

    public int getIndexCount() {
        return this.indexCount;
    }
}

