/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlight;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.OptionalInt;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_9801;
import xaeroplus.feature.render.DrawContext;
import xaeroplus.feature.render.highlight.AbstractHighlightVertexBuffer;
import xaeroplus.feature.render.highlight.MultiColorHighlightColorFunction;
import xaeroplus.feature.render.shaders.XaeroPlusShaders;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class MultiColorHighlightVertexBuffer
extends AbstractHighlightVertexBuffer {
    private final MultiColorHighlightColorFunction colorFunction;

    public MultiColorHighlightVertexBuffer(MultiColorHighlightColorFunction colorFunction) {
        this.colorFunction = colorFunction;
    }

    @Override
    public void preRender(DrawContext ctx, Long2LongMap highlights, int color) {
        super.preRender(ctx, highlights, color);
    }

    @Override
    public void refresh(DrawContext ctx, Long2LongMap highlights, int colorAlpha) {
        this.stale = false;
        this.lastRefreshed = System.currentTimeMillis();
        this.flipped = ctx.worldmap();
        if (highlights.isEmpty()) {
            this.close();
            return;
        }
        class_287 bufferBuilder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576);
        ObjectIterator it = Long2LongMaps.fastIterator((Long2LongMap)highlights);
        while (it.hasNext()) {
            long foundTime;
            Long2LongMap.Entry entry = (Long2LongMap.Entry)it.next();
            long pos = entry.getLongKey();
            int color = this.colorFunction.getColor(pos, foundTime = entry.getLongValue());
            int alpha = ColorHelper.getIntA(color);
            if (alpha == 0) continue;
            int chunkPosX = ChunkUtils.longToChunkX(pos);
            int chunkPosZ = ChunkUtils.longToChunkZ(pos);
            float x1 = chunkPosX;
            float x2 = chunkPosX + 1;
            float y1 = this.flipped ? (float)(chunkPosZ + 1) : (float)chunkPosZ;
            float y2 = this.flipped ? (float)chunkPosZ : (float)(chunkPosZ + 1);
            bufferBuilder.method_22912(x1, y2, 0.0f).method_39415(color);
            bufferBuilder.method_22912(x2, y2, 0.0f).method_39415(color);
            bufferBuilder.method_22912(x2, y1, 0.0f).method_39415(color);
            bufferBuilder.method_22912(x1, y1, 0.0f).method_39415(color);
        }
        class_9801 meshData = bufferBuilder.method_60794();
        if (meshData == null) {
            this.close();
            return;
        }
        try (class_9801 class_98012 = meshData;){
            this.close();
            this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Multi Color Chunk Highlight Buffer", BufferType.VERTICES, BufferUsage.STATIC_WRITE, meshData.method_60818());
            this.indexCount = meshData.method_60822().comp_751();
        }
    }

    @Override
    public void render(DrawContext ctx, Long2LongMap highlights, int color) {
        if (this.vertexBuffer == null || this.vertexBuffer.isClosed()) {
            return;
        }
        RenderSystem.class_5590 autoIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        VertexFormat.class_5595 indexType = autoIndexBuffer.method_31924();
        GpuBuffer indexBuffer = autoIndexBuffer.method_68274(this.indexCount);
        try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(class_310.method_1551().method_1522().method_30277(), OptionalInt.empty());){
            pass.setPipeline(XaeroPlusShaders.MULTI_COLOR_HIGHLIGHT_PIPELINE);
            pass.setUniform("MapViewMatrix", ctx.matrixStack().method_23760().method_23761());
            pass.setUniform("ModelViewMat", RenderSystem.getModelViewMatrix());
            pass.setUniform("ProjMat", RenderSystem.getProjectionMatrix());
            pass.setIndexBuffer(indexBuffer, indexType);
            pass.setVertexBuffer(0, this.vertexBuffer);
            pass.drawIndexed(0, this.indexCount);
        }
    }
}

