/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.misc.KeySortableByOther;
import xaero.common.misc.Misc;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointsSort;
import xaero.hud.minimap.world.MinimapWorld;
import xaeroplus.Globals;
import xaeroplus.feature.extensions.MinimapGuiTexturedButton;
import xaeroplus.settings.Settings;
import xaeroplus.util.ColorHelper;

@Mixin(value={GuiWaypoints.class}, remap=false)
public abstract class MixinGuiWaypoints
extends ScreenBase {
    @Unique
    private class_342 searchField;
    @Unique
    private MinimapGuiTexturedButton toggleAllButton;
    @Unique
    private String waypointsSearchFilter = "";
    @Shadow
    private MinimapWorld displayedWorld;
    @Shadow
    private ArrayList<Waypoint> waypointsSorted;
    @Shadow
    private MinimapSession session;
    @Shadow
    private ConcurrentSkipListSet<Integer> selectedListSet;

    @Shadow
    protected abstract boolean isOneSelected();

    protected MixinGuiWaypoints(IXaeroMinimap modMain, class_437 parent, class_437 escape, class_2561 titleIn) {
        super(modMain, parent, escape, titleIn);
    }

    @Inject(method={"method_25426()V"}, at={@At(value="HEAD")}, remap=true)
    public void initGui(CallbackInfo ci) {
        this.waypointsSearchFilter = "";
        this.searchField = new class_342(this.field_22793, this.field_22789 / 2 - 208, 64, 50, 20, (class_2561)class_2561.method_43471((String)"xaeroplus.gui.waypoints.search"));
        this.searchField.method_1852("");
        this.searchField.method_1883(0, false);
        this.searchField.method_1875(0);
        this.toggleAllButton = new MinimapGuiTexturedButton(this.field_22789 / 2 + 182, this.field_22790 - 29, 20, 20, 2, 18, 17, 17, Globals.guiTextures, b -> {
            this.waypointsSorted.stream().findFirst().ifPresent(firstWaypoint -> {
                boolean firstIsEnabled = firstWaypoint.isDisabled();
                this.waypointsSorted.forEach(waypoint -> waypoint.setDisabled(!firstIsEnabled));
            });
            this.updateSortedList();
        }, () -> new CursorBox((class_2561)class_2561.method_43470((String)"[XP] ").method_10852((class_2561)class_2561.method_43471((String)"xaeroplus.gui.waypoints.toggle_enable_all"))), 256, 256);
        if (!Settings.REGISTRY.waypointsListUIAdditions.get()) {
            return;
        }
        if (this.field_22789 > 590) {
            this.searchField.method_46421(this.field_22789 / 2 - 280);
            this.searchField.method_25358(64);
            this.searchField.method_46419(32);
        }
        this.method_25429((class_364)this.searchField);
        this.method_25395((class_364)this.searchField);
        this.method_37063((class_364)this.toggleAllButton);
    }

    @Inject(method={"method_25402(DDI)Z"}, at={@At(value="INVOKE", target="Lxaero/common/gui/ScreenBase;method_25402(DDI)Z", shift=At.Shift.AFTER)}, remap=true)
    public void mouseClickedInject(double x, double y, int button, CallbackInfoReturnable<Boolean> cir) {
        boolean dropDownClosed;
        if (!Settings.REGISTRY.waypointsListUIAdditions.get()) {
            return;
        }
        boolean bl = dropDownClosed = this.openDropdown == null;
        if (dropDownClosed) {
            if (this.searchField.method_25402(x, y, button)) {
                this.method_25395((class_364)this.searchField);
                this.searchField.method_1872(false);
                this.searchField.method_1888(true);
            } else {
                this.searchField.method_25365(false);
            }
        }
    }

    @Inject(method={"method_25404(III)Z"}, at={@At(value="INVOKE", target="Lxaero/common/gui/ScreenBase;method_25404(III)Z", shift=At.Shift.AFTER)}, remap=true, cancellable=true)
    public void keyTypedInject(int keycode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (!Settings.REGISTRY.waypointsListUIAdditions.get()) {
            return;
        }
        if (this.searchField.method_25370() && this.searchField.method_1885()) {
            this.updateSearch();
            cir.setReturnValue((Object)true);
        }
    }

    public boolean method_25400(char c, int i) {
        boolean result = super.method_25400(c, i);
        if (!Settings.REGISTRY.waypointsListUIAdditions.get()) {
            return result;
        }
        this.updateSearch();
        return result;
    }

    @Inject(method={"method_25394(Lnet/minecraft/class_332;IIF)V"}, at={@At(value="INVOKE", target="Lxaero/common/gui/ScreenBase;method_25394(Lnet/minecraft/class_332;IIF)V", shift=At.Shift.AFTER)}, remap=true)
    public void drawScreenInject(class_332 guiGraphics, int mouseX, int mouseY, float partial, CallbackInfo ci) {
        if (!Settings.REGISTRY.waypointsListUIAdditions.get()) {
            return;
        }
        if (!this.searchField.method_25370() && this.searchField.method_1882().isEmpty()) {
            Misc.setFieldText((class_342)this.searchField, (String)class_1074.method_4662((String)"gui.xaero_settings_search_placeholder", (Object[])new Object[0]), (int)ColorHelper.getColor(85, 85, 85, 255));
            this.searchField.method_1870(false);
        }
        this.searchField.method_25394(guiGraphics, mouseX, mouseY, partial);
        if (!this.searchField.method_25370()) {
            Misc.setFieldText((class_342)this.searchField, (String)this.waypointsSearchFilter);
        }
        super.renderTooltips(guiGraphics, mouseX, mouseY, partial);
    }

    @Redirect(method={"updateButtons()V"}, at=@At(value="INVOKE", target="Lxaero/common/gui/GuiWaypoints;isOneSelected()Z"))
    public boolean shareButtonRedirect(GuiWaypoints instance) {
        if (Settings.REGISTRY.disableWaypointSharing.get()) {
            return false;
        }
        return this.isOneSelected();
    }

    @Unique
    private void updateSearch() {
        String newValue = this.searchField.method_1882();
        if (!this.waypointsSearchFilter.equals(newValue)) {
            this.waypointsSearchFilter = this.searchField.method_1882();
            this.selectedListSet.clear();
            this.updateSortedList();
        }
    }

    @Overwrite
    private void updateSortedList() {
        WaypointsSort sortType = this.displayedWorld.getRootConfig().getSortType();
        Iterable waypointsList = this.displayedWorld.getCurrentWaypointSet().getWaypoints();
        GuiWaypoints.distanceDivided = this.session.getDimensionHelper().getDimensionDivision(this.displayedWorld);
        class_4184 camera = this.field_22787.field_1773.method_19418();
        ArrayList<Waypoint> disabledWaypoints = new ArrayList<Waypoint>();
        ArrayList<Waypoint> enabledWaypoints = new ArrayList<Waypoint>();
        for (Waypoint w : waypointsList) {
            if (w.isDisabled()) {
                disabledWaypoints.add(w);
                continue;
            }
            enabledWaypoints.add(w);
        }
        if (!this.waypointsSearchFilter.isEmpty()) {
            enabledWaypoints.removeIf(waypoint -> !waypoint.getName().toLowerCase().contains(this.waypointsSearchFilter.toLowerCase()));
            disabledWaypoints.removeIf(waypoint -> !waypoint.getName().toLowerCase().contains(this.waypointsSearchFilter.toLowerCase()));
        }
        this.waypointsSorted = new ArrayList();
        this.waypointsSorted.addAll(this.sortWaypoints(enabledWaypoints, sortType, camera));
        this.waypointsSorted.addAll(this.sortWaypoints(disabledWaypoints, sortType, camera));
    }

    @Unique
    private List<Waypoint> sortWaypoints(List<Waypoint> waypointsList, WaypointsSort sortType, class_4184 camera) {
        ArrayList<Waypoint> waypointsSorted = new ArrayList<Waypoint>();
        ArrayList<KeySortableByOther> sortableKeys = new ArrayList<KeySortableByOther>();
        for (Waypoint w : waypointsList) {
            Object sortVal = 0;
            switch (sortType) {
                case NONE: {
                    break;
                }
                case ANGLE: {
                    sortVal = -w.getComparisonAngleCos(camera, GuiWaypoints.distanceDivided);
                    break;
                }
                case COLOR: {
                    sortVal = w.getWaypointColor();
                    break;
                }
                case NAME: {
                    sortVal = w.getComparisonName();
                    break;
                }
                case SYMBOL: {
                    sortVal = w.getInitials();
                    break;
                }
                case DISTANCE: {
                    sortVal = w.getComparisonDistance(camera, GuiWaypoints.distanceDivided);
                }
            }
            sortableKeys.add(new KeySortableByOther((Object)w, new Comparable[]{sortVal}));
        }
        Collections.sort(sortableKeys);
        for (KeySortableByOther k : sortableKeys) {
            waypointsSorted.add((Waypoint)k.getKey());
        }
        if (this.displayedWorld.getContainer().getRootConfig().isSortReversed()) {
            Collections.reverse(waypointsSorted);
        }
        return waypointsSorted;
    }
}

