/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.line;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.Mth;
import xaeroplus.feature.render.line.Line;

public class LinePreProcessor {
    public static final int MAX_LINE_LENGTH = 500000;

    public static Line ensureOrientation(Line line) {
        if (line.z1() > line.z2()) {
            return new Line(line.x2(), line.z2(), line.x1(), line.z1());
        }
        return line;
    }

    public static List<Line> ensureLength(Line line) {
        double len = line.length();
        if (len <= 500000.0) {
            return Collections.emptyList();
        }
        ArrayList<Line> lines = new ArrayList<Line>((int)(len / 500000.0) + 1);
        int dx = line.x2() - line.x1();
        int dz = line.z2() - line.z1();
        if (dx == 0) {
            int x = line.x1();
            int minZ = Math.min(line.z1(), line.z2());
            int maxZ = Math.max(line.z1(), line.z2());
            int z1 = minZ;
            while (z1 < maxZ) {
                int z2 = Mth.clamp((int)(z1 + 500000), (int)minZ, (int)maxZ);
                Line l = new Line(x, z1, x, z2);
                lines.add(l);
                z1 = z2;
            }
        } else if (dz == 0) {
            int z = line.z1();
            int minX = Math.min(line.x1(), line.x2());
            int maxX = Math.max(line.x1(), line.x2());
            int x1 = minX;
            while (x1 < maxX) {
                int x2 = Mth.clamp((int)(x1 + 500000), (int)minX, (int)maxX);
                Line l = new Line(x1, z, x2, z);
                lines.add(l);
                x1 = x2;
            }
        } else {
            boolean positiveSlope;
            double slope = (double)dz / (double)dx;
            double intercept = (double)line.z1() - slope * (double)line.x1();
            boolean bl = positiveSlope = Math.abs(slope) > 1.0;
            if (positiveSlope) {
                int minZ = Math.min(line.z1(), line.z2());
                int maxZ = Math.max(line.z1(), line.z2());
                int z1 = minZ;
                while (z1 < maxZ) {
                    double x1 = ((double)z1 - intercept) / slope;
                    int z2 = Mth.clamp((int)(z1 + 500000), (int)minZ, (int)maxZ);
                    double x2 = ((double)z2 - intercept) / slope;
                    int xx1 = (int)Math.round(x1);
                    int xx2 = (int)Math.round(x2);
                    Line l = new Line(xx1, z1, xx2, z2);
                    lines.add(l);
                    z1 = z2;
                }
            } else {
                int minX = Math.min(line.x1(), line.x2());
                int maxX = Math.max(line.x1(), line.x2());
                int x1 = minX;
                while (x1 < maxX) {
                    double z1 = slope * (double)x1 + intercept;
                    int x2 = Mth.clamp((int)(x1 + 500000), (int)minX, (int)maxX);
                    double z2 = slope * (double)x2 + intercept;
                    int zz1 = (int)Math.round(z1);
                    int zz2 = (int)Math.round(z2);
                    Line l = new Line(x1, zz1, x2, zz2);
                    lines.add(l);
                    x1 = x2;
                }
            }
        }
        return lines;
    }
}

