/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.text;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import xaeroplus.Globals;
import xaeroplus.feature.render.DrawContext;
import xaeroplus.feature.render.DrawFeature;
import xaeroplus.feature.render.text.Text;

public abstract class AbstractTextDrawFeature
implements DrawFeature {
    public abstract Collection<Text> getTexts();

    @Override
    public void render(DrawContext ctx) {
        Font font = Minecraft.getInstance().font;
        Collection<Text> texts = this.getTexts();
        for (Text text : texts) {
            ctx.matrixStack().pushPose();
            float textScale = text.scale() * 2.0f * (float)Mth.clamp((double)((double)(ctx.worldmap() ? 1.0f : (float)Globals.minimapScaleMultiplier) / ctx.fboScale()), (double)(0.1f * (ctx.worldmap() ? 1.0f : (float)Globals.minimapScaleMultiplier)), (double)1000.0);
            float width = font.width(text.value());
            ctx.matrixStack().scale(textScale, textScale, 1.0f);
            ctx.matrixStack().translate((float)text.x() / textScale, (float)text.z() / textScale, 0.0f);
            PoseStack poseStack = ctx.matrixStack();
            float f = -width / 2.0f;
            Objects.requireNonNull(font);
            poseStack.translate(f, (float)(-9) / 2.0f, 0.0f);
            font.drawInBatch(text.value(), 0.0f, 0.0f, text.color(), true, ctx.matrixStack().last().pose(), (MultiBufferSource)ctx.renderTypeBuffers(), Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
            ctx.matrixStack().popPose();
        }
        if (!texts.isEmpty()) {
            RenderSystem.disableCull();
            ctx.renderTypeBuffers().endLastBatch();
        }
    }
}

