/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.drawing;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.drawing.db.DrawingDatabase;
import xaeroplus.feature.render.line.Line;
import xaeroplus.util.ChunkUtils;

public class DrawingLinesCacheDimensionHandler {
    private final ResourceKey<Level> dimension;
    private int windowRegionX = 0;
    private int windowRegionZ = 0;
    private int windowRegionSize = 0;
    private final DrawingDatabase database;
    private final ListeningExecutorService dbExecutor;
    private final Object2IntMap<Line> lines = new Object2IntOpenHashMap();
    public final Set<Line> staleLines = new HashSet<Line>();
    ListenableFuture<?> windowMoveFuture = Futures.immediateVoidFuture();
    Minecraft mc = Minecraft.m_91087_();

    public DrawingLinesCacheDimensionHandler(ResourceKey<Level> dimension, DrawingDatabase database, ListeningExecutorService dbExecutor) {
        this.dimension = dimension;
        this.database = database;
        this.dbExecutor = dbExecutor;
    }

    public void addLine(Line line, int color) {
        if (!this.mc.m_18695_()) {
            throw new RuntimeException("addLine must be called on the main thread!");
        }
        this.lines.put((Object)line, color);
        this.staleLines.add(line);
        this.writeStaleLinesToDatabase();
    }

    public void removeLine(Line line) {
        if (!this.mc.m_18695_()) {
            throw new RuntimeException("removeLine must be called on the main thread!");
        }
        if (this.lines.containsKey((Object)line)) {
            this.lines.removeInt((Object)line);
            this.staleLines.add(line);
            this.dbExecutor.execute(() -> this.database.removeLine(line.x1(), line.z1(), line.x2(), line.z2(), this.dimension));
        }
    }

    public Object2IntMap<Line> getLines() {
        return this.lines;
    }

    public synchronized void setWindow(int regionX, int regionZ, int regionSize) {
        boolean windowChanged;
        boolean bl = windowChanged = regionX != this.windowRegionX || regionZ != this.windowRegionZ || regionSize != this.windowRegionSize;
        if (windowChanged && !this.windowMoveFuture.isDone() && (regionX != 0 || regionZ != 0 || regionSize != 0)) {
            XaeroPlus.LOGGER.debug("Rejecting window move to: [{} {} {}] from: [{} {} {}]", new Object[]{regionX, regionZ, regionSize, this.windowRegionX, this.windowRegionZ, this.windowRegionSize});
            return;
        }
        int prevWindowRegionX = this.windowRegionX;
        int prevWindowRegionZ = this.windowRegionZ;
        int prevWindowRegionSize = this.windowRegionSize;
        this.windowRegionX = regionX;
        this.windowRegionZ = regionZ;
        this.windowRegionSize = regionSize;
        if (windowChanged) {
            try {
                this.windowMoveFuture = this.moveWindow0(regionX, regionZ, regionSize);
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.error("Failed submitting move window task for {} disk cache dimension: {}", new Object[]{this.database.databaseName, this.dimension.m_135782_(), e});
            }
        }
    }

    protected ListenableFuture<?> moveWindow0(int windowRegionX, int windowRegionZ, int windowRegionSize) {
        ListenableFuture loadDataFuture = this.dbExecutor.submit(() -> this.loadLinesFromDatabase(windowRegionX, windowRegionZ, windowRegionSize));
        Futures.addCallback((ListenableFuture)loadDataFuture, (FutureCallback)new LineDataLoadFutureCallback(), (Executor)this.mc);
        ListenableFuture<?> removeDataFuture = this.flushLinesOutsideWindow(windowRegionX, windowRegionZ, windowRegionSize);
        return Futures.allAsList((ListenableFuture[])new ListenableFuture[]{loadDataFuture, removeDataFuture});
    }

    private Object2IntMap<Line> loadLinesFromDatabase(int windowRegionX, int windowRegionZ, int windowRegionSize) {
        Object2IntOpenHashMap dataBuf = new Object2IntOpenHashMap();
        int windowXMin = ChunkUtils.regionCoordToCoord(windowRegionX - windowRegionSize);
        int windowZMin = ChunkUtils.regionCoordToCoord(windowRegionZ - windowRegionSize);
        int windowXMax = ChunkUtils.regionCoordToCoord(windowRegionX + windowRegionSize);
        int windowZMax = ChunkUtils.regionCoordToCoord(windowRegionZ + windowRegionSize);
        this.database.getLinesInDimension(this.dimension, (arg_0, arg_1, arg_2, arg_3, arg_4) -> DrawingLinesCacheDimensionHandler.lambda$loadLinesFromDatabase$2(windowXMin, windowXMax, windowZMin, windowZMax, (Object2IntMap)dataBuf, arg_0, arg_1, arg_2, arg_3, arg_4));
        return dataBuf;
    }

    private ListenableFuture<?> flushLinesOutsideWindow(int windowRegionX, int windowRegionZ, int windowRegionSize) {
        if (!this.mc.m_18695_()) {
            throw new RuntimeException("removeChunksOutsideWindow must be called on the main thread");
        }
        Object2IntOpenHashMap dataBuf = new Object2IntOpenHashMap();
        int windowXMin = ChunkUtils.regionCoordToCoord(windowRegionX - windowRegionSize);
        int windowZMin = ChunkUtils.regionCoordToCoord(windowRegionZ - windowRegionSize);
        int windowXMax = ChunkUtils.regionCoordToCoord(windowRegionX + windowRegionSize);
        int windowZMax = ChunkUtils.regionCoordToCoord(windowRegionZ + windowRegionSize);
        ObjectIterator it = this.lines.keySet().iterator();
        while (it.hasNext()) {
            Line line = (Line)it.next();
            if (line.lineClip(windowXMin, windowXMax, windowZMin, windowZMax)) continue;
            if (this.staleLines.contains(line)) {
                dataBuf.put((Object)line, this.lines.getInt((Object)line));
            }
            it.remove();
        }
        return this.dbExecutor.submit(() -> this.lambda$flushLinesOutsideWindow$3((Object2IntMap)dataBuf));
    }

    public ListenableFuture<?> writeStaleLinesToDatabase() {
        if (!this.mc.m_18695_()) {
            throw new RuntimeException("writeStaleHighlightsToDatabase must be called on the main thread");
        }
        Object2IntMap<Line> toWrite = this.collectStaleLinesToWrite();
        if (toWrite.isEmpty()) {
            return Futures.immediateVoidFuture();
        }
        return this.writeDataToDatabase(toWrite);
    }

    public Object2IntMap<Line> collectStaleLinesToWrite() {
        if (!this.mc.m_18695_()) {
            throw new RuntimeException("collectStaleHighlightsToWrite must be called on the main thread");
        }
        if (this.staleLines.isEmpty()) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap linesToWrite = new Object2IntOpenHashMap(this.staleLines.size());
        Iterator<Line> it = this.staleLines.iterator();
        while (it.hasNext()) {
            Line line = it.next();
            int color = this.lines.getOrDefault((Object)line, Integer.MIN_VALUE);
            if (color != Integer.MIN_VALUE) {
                linesToWrite.put((Object)line, color);
            }
            it.remove();
        }
        return linesToWrite;
    }

    public ListenableFuture<?> writeDataToDatabase(Object2IntMap<Line> toWrite) {
        try {
            return this.dbExecutor.submit(() -> this.database.insertLinesList(toWrite, this.dimension));
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed to submit db write task for {} disk cache dimension: {}", new Object[]{this.database.databaseName, this.dimension.m_135782_(), e});
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    private /* synthetic */ void lambda$flushLinesOutsideWindow$3(Object2IntMap dataBuf) {
        this.database.insertLinesList((Object2IntMap<Line>)dataBuf, this.dimension);
    }

    private static /* synthetic */ void lambda$loadLinesFromDatabase$2(int windowXMin, int windowXMax, int windowZMin, int windowZMax, Object2IntMap dataBuf, int x1, int z1, int x2, int z2, int color) {
        Line line = new Line(x1, z1, x2, z2);
        if (line.lineClip(windowXMin, windowXMax, windowZMin, windowZMax)) {
            dataBuf.put((Object)line, color);
        }
    }

    private final class LineDataLoadFutureCallback
    implements FutureCallback<Object2IntMap<Line>> {
        private LineDataLoadFutureCallback() {
        }

        public void onSuccess(Object2IntMap<Line> dataBuf) {
            if (!DrawingLinesCacheDimensionHandler.this.mc.m_18695_()) {
                XaeroPlus.LOGGER.error("LineDataLoadFutureCallback must be called on the main thread");
            }
            if (dataBuf.isEmpty()) {
                return;
            }
            DrawingLinesCacheDimensionHandler.this.lines.putAll(dataBuf);
        }

        public void onFailure(Throwable t) {
            XaeroPlus.LOGGER.error("Error loading lines {} disk cache dimension: {}", new Object[]{DrawingLinesCacheDimensionHandler.this.database.databaseName, DrawingLinesCacheDimensionHandler.this.dimension.m_135782_(), t});
        }
    }
}

