/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.settings;

import java.io.ByteArrayOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import xaero.common.HudMod;
import xaero.map.WorldMapSession;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.waypoint.WaypointAPI;
import xaeroplus.feature.waypoint.eta.WaypointEtaManager;
import xaeroplus.module.ModuleManager;
import xaeroplus.module.impl.BaritoneGoalSync;
import xaeroplus.module.impl.Breadcrumbs;
import xaeroplus.module.impl.Drawing;
import xaeroplus.module.impl.FpsLimiter;
import xaeroplus.module.impl.Highways;
import xaeroplus.module.impl.LavaColumns;
import xaeroplus.module.impl.LiquidNewChunks;
import xaeroplus.module.impl.MapArtGrid;
import xaeroplus.module.impl.OldBiomes;
import xaeroplus.module.impl.OldChunks;
import xaeroplus.module.impl.PaletteNewChunks;
import xaeroplus.module.impl.Pearls;
import xaeroplus.module.impl.PortalSkipDetection;
import xaeroplus.module.impl.Portals;
import xaeroplus.module.impl.RegionGrid;
import xaeroplus.module.impl.RenderDistance;
import xaeroplus.module.impl.SpawnChunks;
import xaeroplus.module.impl.SpawnChunksPlayer;
import xaeroplus.module.impl.SpawnPoint;
import xaeroplus.module.impl.TeleportFailNotifier;
import xaeroplus.module.impl.WaystoneSync;
import xaeroplus.module.impl.WorldBorder;
import xaeroplus.module.impl.WorldTools;
import xaeroplus.settings.BooleanSetting;
import xaeroplus.settings.DoubleSetting;
import xaeroplus.settings.EnumSetting;
import xaeroplus.settings.SettingLocation;
import xaeroplus.settings.SettingRegistry;
import xaeroplus.settings.StringSetting;
import xaeroplus.settings.TranslatableSettingEnum;
import xaeroplus.util.BaritoneHelper;
import xaeroplus.util.ColorHelper;
import xaeroplus.util.WaystonesHelper;
import xaeroplus.util.WorldToolsHelper;

public final class Settings
extends SettingRegistry {
    public static final Settings REGISTRY = new Settings();
    public final BooleanSetting fastMapSetting = this.register(BooleanSetting.create("Fast Mapping", "xaeroplus.setting.fast_mapping", false), SettingLocation.WORLD_MAP_MAIN);
    public final DoubleSetting fastMapWriterDelaySetting = this.register(DoubleSetting.create("Fast Mapping Delay", "xaeroplus.setting.fast_mapping_delay", 10.0, 1000.0, 10.0, 250.0, this.fastMapSetting::get), SettingLocation.WORLD_MAP_MAIN);
    public final DoubleSetting fastMapMaxTilesPerCycle = this.register(DoubleSetting.create("Fast Mapping Rate Limit", "xaeroplus.setting.fast_mapping_rate_limit", 10.0, 120.0, 10.0, 25.0, this.fastMapSetting::get), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting fastZipWrite = this.register(BooleanSetting.create("Fast Zip Writes", "xaeroplus.setting.fast_zip_writes", true, b -> {
        if (!b) {
            Globals.zipFastByteBuffer = new ByteArrayOutputStream();
        }
    }), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting writesWhileDimSwitched = this.register(BooleanSetting.create("Region Writes While Dim Switched", "xaeroplus.setting.region_write_while_dimension_switched", false), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting baritoneWaypointSyncSetting = this.register(BooleanSetting.create("Baritone Goal Waypoint", "xaeroplus.setting.baritone_waypoint", true, b -> {
        if (BaritoneHelper.isBaritonePresent()) {
            ModuleManager.getModule(BaritoneGoalSync.class).setEnabled(b);
        }
    }, BaritoneHelper::isBaritonePresent), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting waystonesWaypointSyncSetting = this.register(BooleanSetting.create("Waystones Sync", "xaeroplus.setting.waystones_sync", true, b -> {
        if (WaystonesHelper.isAnyWaystonesPresent()) {
            ModuleManager.getModule(WaystoneSync.class).setEnabled(b);
        }
    }, WaystonesHelper::isAnyWaystonesPresent), SettingLocation.WORLD_MAP_MAIN);
    public final EnumSetting<ColorHelper.WaystoneColor> waystoneColorSetting = this.register(EnumSetting.create((String)"Waystone Color", (String)"xaeroplus.setting.waystone_color", (Enum[])ColorHelper.WaystoneColor.values(), (Enum)ColorHelper.WaystoneColor.RANDOM, b -> {
        if (WaystonesHelper.isAnyWaystonesPresent()) {
            ModuleManager.getModule(WaystoneSync.class).setColor((ColorHelper.WaystoneColor)b);
        }
    }, () -> WaystonesHelper.isAnyWaystonesPresent() && ModuleManager.getModule(WaystoneSync.class).isEnabled()), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting waystoneWaypointSetSetting = this.register(BooleanSetting.create("Waystone Waypoint Set", "xaeroplus.setting.waystone_waypoint_set", false, b -> {
        if (WaystonesHelper.isAnyWaystonesPresent()) {
            ModuleManager.getModule(WaystoneSync.class).setWaypointSet(b);
        }
    }, () -> WaystonesHelper.isAnyWaystonesPresent() && ModuleManager.getModule(WaystoneSync.class).isEnabled()), SettingLocation.WORLD_MAP_MAIN);
    public final EnumSetting<WaystoneWpVisibilityType> waystoneWaypointVisibilityModeSetting = this.register(EnumSetting.create((String)"Waystone WP Visibility Type", (String)"xaeroplus.setting.waystone_visibility_type", (Enum[])WaystoneWpVisibilityType.values(), (Enum)WaystoneWpVisibilityType.LOCAL, mode -> {
        if (WaystonesHelper.isAnyWaystonesPresent()) {
            ModuleManager.getModule(WaystoneSync.class).setVisibilityType((WaystoneWpVisibilityType)mode);
        }
    }, () -> WaystonesHelper.isAnyWaystonesPresent() && ModuleManager.getModule(WaystoneSync.class).isEnabled()), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting spawnPointSetting = this.register(BooleanSetting.create("Spawn Point Waypoint", "xaeroplus.setting.spawn_point_waypoint", false, b -> ModuleManager.getModule(SpawnPoint.class).setEnabled(b)), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting pearlWaypointsSetting = this.register(BooleanSetting.create("Pearl Waypoints", "xaeroplus.setting.pearl_waypoints", false, b -> ModuleManager.getModule(Pearls.class).setEnabled(b)), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting persistMapDimensionSwitchSetting = this.register(BooleanSetting.create("Persist Dim Switch", "xaeroplus.setting.persist_dimension_switch", true), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting radarWhileDimensionSwitchedSetting = this.register(BooleanSetting.create("Radar While Dim Switched", "xaeroplus.setting.radar_while_dimension_switched", true), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting transparentObsidianRoofSetting = this.register(BooleanSetting.create("Transparent Obsidian Roof", "xaeroplus.setting.transparent_obsidian_roof", false, v -> Settings.markChunksDirtyInWriteDistance()), SettingLocation.WORLD_MAP_MAIN);
    public final DoubleSetting transparentObsidianRoofYSetting = this.register(DoubleSetting.create("Roof Y Level", "xaeroplus.setting.transparent_obsidian_roof_y", 0.0, 320.0, 1.0, 250.0, v -> Settings.markChunksDirtyInWriteDistance(), this.transparentObsidianRoofSetting::get), SettingLocation.WORLD_MAP_MAIN);
    public final DoubleSetting transparentObsidianRoofDarkeningSetting = this.register(DoubleSetting.create("Roof Obsidian Opacity", "xaeroplus.setting.transparent_obsidian_roof_darkening", 0.0, 255.0, 5.0, 150.0, v -> Settings.markChunksDirtyInWriteDistance(), this.transparentObsidianRoofSetting::get), SettingLocation.WORLD_MAP_MAIN);
    public final DoubleSetting transparentObsidianRoofSnowOpacitySetting = this.register(DoubleSetting.create("Roof Snow Opacity", "xaeroplus.setting.transparent_obsidian_roof_snow_opacity", 0.0, 255.0, 5.0, 10.0, v -> Settings.markChunksDirtyInWriteDistance(), this.transparentObsidianRoofSetting::get), SettingLocation.WORLD_MAP_MAIN);
    public final DoubleSetting worldMapMinZoomSetting = this.register(DoubleSetting.create("Min WorldMap Zoom", "xaeroplus.setting.min_zoom", 0.0, 0.625, 0.01, 0.1), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting crossDimensionCursorCoordinates = this.register(BooleanSetting.create("Cross Dim Cursor Coords", "xaeroplus.setting.cross_dimension_cursor_coordinates", false), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting owAutoWaypointDimension = this.register(BooleanSetting.create("Prefer Overworld Waypoints", "xaeroplus.setting.ow_auto_waypoint_dimension", false), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting showWaypointDistances = this.register(BooleanSetting.create("Show Waypoint Distances", "xaeroplus.setting.show_waypoint_distances", true), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting showCoordsInRightClickOptions = this.register(BooleanSetting.create("Show Coords In Right Click Options", "xaeroplus.setting.show_coords_in_right_click_options", true), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting nullOverworldDimensionFolder = this.register(BooleanSetting.create("null OW Dim Dir", "xaeroplus.setting.null_overworld_dimension_folder", true, Globals::setNullOverworldDimFolderIfAble, () -> false), SettingLocation.WORLD_MAP_MAIN);
    public final EnumSetting<DataFolderResolutionMode> dataFolderResolutionMode = this.register(EnumSetting.create((String)"Data Dir Mode", (String)"xaeroplus.setting.data_folder_resolution_mode", (Enum[])DataFolderResolutionMode.values(), (Enum)DataFolderResolutionMode.IP, Globals::setDataFolderResolutionModeIfAble), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting netherCaveFix = this.register(BooleanSetting.create("Nether Cave Fix", "xaeroplus.setting.nether_cave_fix", true), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting disableXaeroInternetAccess = this.register(BooleanSetting.create("Disable Xaero Internet Access", "xaeroplus.setting.disable_internet", false), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting expandSettingEntries = this.register(BooleanSetting.create("Expanded Setting Entries", "xaeroplus.setting.expanded_settings", false), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting teleportFailNotifier = this.register(BooleanSetting.create("Teleport Fail Notifier", "xaeroplus.setting.teleport_fail_notifier", true, b -> ModuleManager.getModule(TeleportFailNotifier.class).setEnabled(b)), SettingLocation.WORLD_MAP_MAIN);
    public final DoubleSetting teleportFailNotifierDelay = this.register(DoubleSetting.create("Teleport Fail Delay", "xaeroplus.setting.teleport_fail_notifier_delay", 1.0, 120.0, 1.0, 30.0, () -> ModuleManager.getModule(TeleportFailNotifier.class).isEnabled()), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting disableTeleportation = this.register(BooleanSetting.create("Disable Teleportation", "xaeroplus.setting.disable_teleportation", false), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting sodiumSettingIntegration = this.register(BooleanSetting.create("Sodium/Embeddium Setting Integration", "xaeroplus.setting.sodium_embeddium_integration", true), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting worldMapUIAdditions = this.register(BooleanSetting.create("WorldMap UI Additions", "xaeroplus.setting.world_map_ui_additions", true, false), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting waypointsListUIAdditions = this.register(BooleanSetting.create("Waypoints List UI Additions", "xaeroplus.setting.waypoints_list_ui_additions", true, false), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting fixWaypointLoad = this.register(BooleanSetting.create("Fix Waypoint Load Bug", "Fix Waypoint Load Bug", true, false), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting atomicMoveAndReplace = this.register(BooleanSetting.create("Atomic File Move And Replace", "Atomic File Move And Replace", true, false), SettingLocation.WORLD_MAP_MAIN);
    public final BooleanSetting paletteNewChunksEnabledSetting = this.register(BooleanSetting.create("Palette NewChunks", "xaeroplus.setting.palette_new_chunks_highlighting", false, true, b -> ModuleManager.getModule(PaletteNewChunks.class).setEnabled(b)), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting paletteNewChunksVersionUpgradedChunks = this.register(BooleanSetting.create("Palette NewChunks Version Upgraded", "xaeroplus.setting.palette_new_chunks_version_upgraded", true, () -> ModuleManager.getModule(PaletteNewChunks.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting paletteNewChunksSaveLoadToDisk = this.register(BooleanSetting.create("Save/Load Palette NewChunks to Disk", "xaeroplus.setting.palette_new_chunks_save_load_to_disk", true, b -> ModuleManager.getModule(PaletteNewChunks.class).setDiskCache(b), () -> ModuleManager.getModule(PaletteNewChunks.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final DoubleSetting paletteNewChunksAlphaSetting = this.register(DoubleSetting.create("Palette NewChunks Opacity", "xaeroplus.setting.palette_new_chunks_opacity", 0.0, 255.0, 10.0, 100.0, b -> ModuleManager.getModule(PaletteNewChunks.class).setAlpha(b), () -> ModuleManager.getModule(PaletteNewChunks.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final EnumSetting<ColorHelper.HighlightColor> paletteNewChunksColorSetting = this.register(EnumSetting.create((String)"Palette NewChunks Color", (String)"xaeroplus.setting.palette_new_chunks_color", (Enum[])ColorHelper.HighlightColor.values(), (Enum)ColorHelper.HighlightColor.RED, b -> ModuleManager.getModule(PaletteNewChunks.class).setRgbColor(b.getColor()), () -> ModuleManager.getModule(PaletteNewChunks.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting paletteNewChunksRenderInverse = this.register(BooleanSetting.create("Palette NewChunks Inverse", "xaeroplus.setting.palette_new_chunks_inverse", false, b -> ModuleManager.getModule(PaletteNewChunks.class).setInverse(b), () -> ModuleManager.getModule(PaletteNewChunks.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting oldChunksEnabledSetting = this.register(BooleanSetting.create("OldChunks Highlighting", "xaeroplus.setting.old_chunks_highlighting", false, true, b -> ModuleManager.getModule(OldChunks.class).setEnabled(b)), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting oldChunksInverse = this.register(BooleanSetting.create("OldChunks Inverse", "xaeroplus.setting.old_chunks_inverse", false, b -> ModuleManager.getModule(OldChunks.class).setInverse(b), () -> ModuleManager.getModule(OldChunks.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting oldChunksSaveLoadToDisk = this.register(BooleanSetting.create("Save/Load OldChunks to Disk", "xaeroplus.setting.old_chunks_save_load_to_disk", true, b -> ModuleManager.getModule(OldChunks.class).setDiskCache(b), () -> ModuleManager.getModule(OldChunks.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final DoubleSetting oldChunksAlphaSetting = this.register(DoubleSetting.create("Old Chunks Opacity", "xaeroplus.setting.old_chunks_opacity", 0.0, 255.0, 10.0, 100.0, b -> ModuleManager.getModule(OldChunks.class).setAlpha(b), () -> ModuleManager.getModule(OldChunks.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final EnumSetting<ColorHelper.HighlightColor> oldChunksColorSetting = this.register(EnumSetting.create((String)"Old Chunks Color", (String)"xaeroplus.setting.old_chunks_color", (Enum[])ColorHelper.HighlightColor.values(), (Enum)ColorHelper.HighlightColor.YELLOW, b -> ModuleManager.getModule(OldChunks.class).setRgbColor(b.getColor()), () -> ModuleManager.getModule(OldChunks.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting portalsEnabledSetting = this.register(BooleanSetting.create("Portal Highlights", "xaeroplus.setting.portals", false, true, b -> ModuleManager.getModule(Portals.class).setEnabled(b)), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting portalsSaveLoadToDisk = this.register(BooleanSetting.create("Save/Load Portals to Disk", "xaeroplus.setting.portals_save_load_to_disk", true, b -> ModuleManager.getModule(Portals.class).setDiskCache(b), () -> ModuleManager.getModule(Portals.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final DoubleSetting portalsAlphaSetting = this.register(DoubleSetting.create("Portal Highlights Opacity", "xaeroplus.setting.portals_opacity", 0.0, 255.0, 10.0, 100.0, b -> ModuleManager.getModule(Portals.class).setAlpha(b), () -> ModuleManager.getModule(Portals.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final EnumSetting<ColorHelper.HighlightColor> portalsColorSetting = this.register(EnumSetting.create((String)"Portal Highlights Color", (String)"xaeroplus.setting.portals_color", (Enum[])ColorHelper.HighlightColor.values(), (Enum)ColorHelper.HighlightColor.MAGENTA, b -> ModuleManager.getModule(Portals.class).setRgbColor(b.getColor()), () -> ModuleManager.getModule(Portals.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting lavaColumnsEnabledSetting = this.register(BooleanSetting.create("Lava Columns", "xaeroplus.setting.lava_columns", false, true, b -> ModuleManager.getModule(LavaColumns.class).setEnabled(b)), SettingLocation.CHUNK_HIGHLIGHTS);
    public final DoubleSetting lavaColumnsMinHeight = this.register(DoubleSetting.create("Min Lava Column Height", "xaeroplus.setting.lava_columns_min_height", 0.0, 20.0, 1.0, 5.0, b -> ModuleManager.getModule(LavaColumns.class).setMinColumnHeight((int)b), () -> ModuleManager.getModule(LavaColumns.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final DoubleSetting lavaColumnsAlphaShift = this.register(DoubleSetting.create("Lava Columns Base Alpha Shift", "xaeroplus.setting.lava_columns_alpha_shift", -200.0, 200.0, 1.0, 0.0, b -> ModuleManager.getModule(LavaColumns.class).setAlphaShift((int)b), () -> ModuleManager.getModule(LavaColumns.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final DoubleSetting lavaColumnsAlphaStep = this.register(DoubleSetting.create("Lava Columns Alpha Step", "xaeroplus.setting.lava_columns_alpha_step", 1.0, 30.0, 1.0, 8.0, b -> ModuleManager.getModule(LavaColumns.class).setAlphaStep((int)b), () -> ModuleManager.getModule(LavaColumns.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final EnumSetting<ColorHelper.HighlightColor> lavaColumnsColor = this.register(EnumSetting.create((String)"Lava Columns Color", (String)"xaeroplus.setting.lava_columns_color", (Enum[])ColorHelper.HighlightColor.values(), (Enum)ColorHelper.HighlightColor.GREEN, b -> ModuleManager.getModule(LavaColumns.class).setRgbColor(b.getColor()), () -> ModuleManager.getModule(LavaColumns.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting lavaColumnsSaveLoadToDisk = this.register(BooleanSetting.create("Save/Load Lava Columns to Disk", "xaeroplus.setting.lava_columns_save_load_to_disk", true, b -> ModuleManager.getModule(LavaColumns.class).setDiskCache(b), () -> ModuleManager.getModule(LavaColumns.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting oldBiomesSetting = this.register(BooleanSetting.create("Old Biomes", "xaeroplus.setting.old_biomes_enabled", false, true, b -> ModuleManager.getModule(OldBiomes.class).setEnabled(b)), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting oldBiomesSaveToDiskSetting = this.register(BooleanSetting.create("Save/Load OldBiomes To Disk", "xaeroplus.setting.old_biomes_save_load_to_disk", true, b -> ModuleManager.getModule(OldBiomes.class).setDiskCache(b), () -> ModuleManager.getModule(OldBiomes.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final DoubleSetting oldBiomesAlphaSetting = this.register(DoubleSetting.create("OldBiomes Opacity", "xaeroplus.setting.old_biomes_opacity", 0.0, 255.0, 10.0, 100.0, b -> ModuleManager.getModule(OldBiomes.class).setAlpha(b), () -> ModuleManager.getModule(OldBiomes.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final EnumSetting<ColorHelper.HighlightColor> oldBiomesColorSetting = this.register(EnumSetting.create((String)"OldBiomes Color", (String)"xaeroplus.setting.old_biomes_color", (Enum[])ColorHelper.HighlightColor.values(), (Enum)ColorHelper.HighlightColor.GREEN, b -> ModuleManager.getModule(OldBiomes.class).setRgbColor(b.getColor()), () -> ModuleManager.getModule(OldBiomes.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting liquidNewChunksEnabledSetting = this.register(BooleanSetting.create("NewChunks Highlighting", "xaeroplus.setting.new_chunks_highlighting", false, true, b -> ModuleManager.getModule(LiquidNewChunks.class).setEnabled(b)), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting liquidNewChunksSaveLoadToDisk = this.register(BooleanSetting.create("Save/Load NewChunks to Disk", "xaeroplus.setting.new_chunks_save_load_to_disk", true, b -> ModuleManager.getModule(LiquidNewChunks.class).setDiskCache(b), () -> ModuleManager.getModule(LiquidNewChunks.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final DoubleSetting liquidNewChunksAlphaSetting = this.register(DoubleSetting.create("New Chunks Opacity", "xaeroplus.setting.new_chunks_opacity", 0.0, 255.0, 10.0, 100.0, b -> ModuleManager.getModule(LiquidNewChunks.class).setAlpha(b), () -> ModuleManager.getModule(LiquidNewChunks.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final EnumSetting<ColorHelper.HighlightColor> liquidNewChunksColorSetting = this.register(EnumSetting.create((String)"New Chunks Color", (String)"xaeroplus.setting.new_chunks_color", (Enum[])ColorHelper.HighlightColor.values(), (Enum)ColorHelper.HighlightColor.RED, b -> ModuleManager.getModule(LiquidNewChunks.class).setRgbColor(b.getColor()), () -> ModuleManager.getModule(LiquidNewChunks.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting liquidNewChunksInverseHighlightsSetting = this.register(BooleanSetting.create("New Chunks Render Inverse", "xaeroplus.setting.new_chunks_inverse_enabled", false, b -> ModuleManager.getModule(LiquidNewChunks.class).setInverseRenderEnabled(b), () -> ModuleManager.getModule(LiquidNewChunks.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final EnumSetting<ColorHelper.HighlightColor> liquidNewChunksInverseColorSetting = this.register(EnumSetting.create((String)"New Chunks Inverse Color", (String)"xaeroplus.setting.new_chunks_inverse_color", (Enum[])ColorHelper.HighlightColor.values(), (Enum)ColorHelper.HighlightColor.GREEN, b -> ModuleManager.getModule(LiquidNewChunks.class).setInverseRgbColor(b.getColor()), () -> ModuleManager.getModule(LiquidNewChunks.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting liquidNewChunksOnlyAboveY0Setting = this.register(BooleanSetting.create("Liquid NewChunks Only Y > 0", "xaeroplus.setting.new_chunks_only_above_y0", false, () -> ModuleManager.getModule(LiquidNewChunks.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting worldToolsEnabledSetting = this.register(BooleanSetting.create("WorldTools Highlights", "xaeroplus.setting.world_tools", true, true, b -> ModuleManager.getModule(WorldTools.class).setEnabled(b), WorldToolsHelper::isWorldToolsPresent), SettingLocation.CHUNK_HIGHLIGHTS);
    public DoubleSetting worldToolsAlphaSetting = this.register(DoubleSetting.create("WorldTools Highlights Opacity", "xaeroplus.setting.world_tools_opacity", 0.0, 255.0, 10.0, 100.0, b -> ModuleManager.getModule(WorldTools.class).setAlpha(b), () -> WorldToolsHelper.isWorldToolsPresent() && ModuleManager.getModule(WorldTools.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final EnumSetting<ColorHelper.HighlightColor> worldToolsColorSetting = this.register(EnumSetting.create((String)"WorldTools Highlights Color", (String)"xaeroplus.setting.world_tools_color", (Enum[])ColorHelper.HighlightColor.values(), (Enum)ColorHelper.HighlightColor.GREEN, b -> ModuleManager.getModule(WorldTools.class).setRgbColor(b.getColor()), () -> WorldToolsHelper.isWorldToolsPresent() && ModuleManager.getModule(WorldTools.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting portalSkipDetectionEnabledSetting = this.register(BooleanSetting.create("PortalSkip Detection", "xaeroplus.setting.portal_skip_detection", false, true, b -> ModuleManager.getModule(PortalSkipDetection.class).setEnabled(b)), SettingLocation.CHUNK_HIGHLIGHTS);
    public final DoubleSetting portalSkipDetectionAlphaSetting = this.register(DoubleSetting.create("PortalSkip Opacity", "xaeroplus.setting.portal_skip_opacity", 0.0, 255.0, 10.0, 100.0, b -> ModuleManager.getModule(PortalSkipDetection.class).setAlpha(b), () -> ModuleManager.getModule(PortalSkipDetection.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final EnumSetting<ColorHelper.HighlightColor> portalSkipDetectionColorSetting = this.register(EnumSetting.create((String)"PortalSkip Color", (String)"xaeroplus.setting.portal_skip_color", (Enum[])ColorHelper.HighlightColor.values(), (Enum)ColorHelper.HighlightColor.WHITE, b -> ModuleManager.getModule(PortalSkipDetection.class).setRgbColor(b.getColor()), () -> ModuleManager.getModule(PortalSkipDetection.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final DoubleSetting portalSkipPortalRadius = this.register(DoubleSetting.create("PortalSkip Portal Radius", "xaeroplus.setting.portal_skip_portal_radius", 0.0, 32.0, 1.0, 15.0, b -> ModuleManager.getModule(PortalSkipDetection.class).setPortalRadius(b), () -> ModuleManager.getModule(PortalSkipDetection.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final DoubleSetting portalSkipDetectionSearchDelayTicksSetting = this.register(DoubleSetting.create("PortalSkip Search Delay", "xaeroplus.setting.portal_skip_search_delay", 0.0, 100.0, 1.0, 10.0, b -> ModuleManager.getModule(PortalSkipDetection.class).setSearchDelayTicks(b), () -> ModuleManager.getModule(PortalSkipDetection.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting portalSkipNewChunksSetting = this.register(BooleanSetting.create("PortalSkip NewChunks", "xaeroplus.setting.portal_skip_new_chunks", true, b -> ModuleManager.getModule(PortalSkipDetection.class).setNewChunks(b), () -> ModuleManager.getModule(PortalSkipDetection.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting portalSkipOldChunkInverseSetting = this.register(BooleanSetting.create("PortalSkip OldChunks Inverse", "xaeroplus.setting.portal_skip_old_chunks_inverse", true, b -> ModuleManager.getModule(PortalSkipDetection.class).setOldChunksInverse(b), () -> ModuleManager.getModule(PortalSkipDetection.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting breadcrumbsEnabledSetting = this.register(BooleanSetting.create("Breadcrumbs", "xaeroplus.setting.breadcrumbs", false, b -> ModuleManager.getModule(Breadcrumbs.class).setEnabled(b)), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting breadcrumbsSaveLoadToDiskSetting = this.register(BooleanSetting.create("Save/Load Breadcrumbs to Disk", "xaeroplus.setting.breadcrumbs_save_load_to_disk", true, b -> ModuleManager.getModule(Breadcrumbs.class).setDiskCache(b), () -> ModuleManager.getModule(Breadcrumbs.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final DoubleSetting breadcrumbsChunkRadiusSetting = this.register(DoubleSetting.create("Breadcrumbs Chunk Radius", "xaeroplus.setting.breadcrumbs_chunk_radius", 0.0, 16.0, 1.0, 0.0, d -> ModuleManager.getModule(Breadcrumbs.class).setChunkRadius(d), () -> ModuleManager.getModule(Breadcrumbs.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final EnumSetting<ColorHelper.HighlightColor> breadcrumbsColorSetting = this.register(EnumSetting.create((String)"Breadcrumbs Color", (String)"xaeroplus.setting.breadcrumbs_color", (Enum[])ColorHelper.HighlightColor.values(), (Enum)ColorHelper.HighlightColor.CYAN, b -> ModuleManager.getModule(Breadcrumbs.class).setRgbColor(b.getColor()), () -> ModuleManager.getModule(Breadcrumbs.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final DoubleSetting breadcrumbsOpacitySetting = this.register(DoubleSetting.create("Breadcrumbs Opacity", "xaeroplus.setting.breadcrumbs_opacity", 0.0, 255.0, 10.0, 100.0, b -> ModuleManager.getModule(Breadcrumbs.class).setAlpha(b), () -> ModuleManager.getModule(Breadcrumbs.class).isEnabled()), SettingLocation.CHUNK_HIGHLIGHTS);
    public final BooleanSetting highwayHighlightsSetting = this.register(BooleanSetting.create("2b2t Highways", "xaeroplus.setting.2b2t_highways_enabled", false, true, b -> ModuleManager.getModule(Highways.class).setEnabled(b)), SettingLocation.OVERLAYS);
    public final EnumSetting<HighwayWidth> highwayWidthSetting = this.register(EnumSetting.create((String)"2b2t Highways Width", (String)"xaeroplus.setting.2b2t_highways_width", (Enum[])HighwayWidth.values(), (Enum)HighwayWidth.ONE, v -> ModuleManager.getModule(Highways.class).setWidth((HighwayWidth)v), () -> ModuleManager.getModule(Highways.class).isEnabled()), SettingLocation.OVERLAYS);
    public final EnumSetting<ColorHelper.HighlightColor> highwaysColorSetting = this.register(EnumSetting.create((String)"2b2t Highways Color", (String)"xaeroplus.setting.2b2t_highways_color", (Enum[])ColorHelper.HighlightColor.values(), (Enum)ColorHelper.HighlightColor.BLUE, b -> ModuleManager.getModule(Highways.class).setRgbColor(b.getColor()), () -> ModuleManager.getModule(Highways.class).isEnabled()), SettingLocation.OVERLAYS);
    public final DoubleSetting highwaysColorAlphaSetting = this.register(DoubleSetting.create("2b2t Highways Opacity", "xaeroplus.setting.2b2t_highways_opacity", 0.0, 255.0, 10.0, 100.0, b -> ModuleManager.getModule(Highways.class).setAlpha(b), () -> ModuleManager.getModule(Highways.class).isEnabled()), SettingLocation.OVERLAYS);
    public final BooleanSetting showRenderDistanceSetting = this.register(BooleanSetting.create("Show Render Distance", "xaeroplus.setting.show_render_distance", false, true, b -> ModuleManager.getModule(RenderDistance.class).setEnabled(b)), SettingLocation.OVERLAYS);
    public final BooleanSetting showWorldBorderSetting = this.register(BooleanSetting.create("Show World Border", "xaeroplus.setting.show_world_border", false, b -> ModuleManager.getModule(WorldBorder.class).setEnabled(b)), SettingLocation.OVERLAYS);
    public final BooleanSetting spawnChunksEnabledSetting = this.register(BooleanSetting.create("Spawn Chunks", "xaeroplus.setting.spawn_chunks", false, true, b -> ModuleManager.getModule(SpawnChunks.class).setEnabled(b)), SettingLocation.OVERLAYS);
    public final BooleanSetting playerSpawnChunksEnabledSetting = this.register(BooleanSetting.create("Player Spawn Chunks", "xaeroplus.setting.player_spawn_chunks", false, true, b -> ModuleManager.getModule(SpawnChunksPlayer.class).setEnabled(b)), SettingLocation.OVERLAYS);
    public final BooleanSetting spawnChunksRedstoneProcessingEnabled = this.register(BooleanSetting.create("Spawn Chunks Redstone Processing", "xaeroplus.setting.spawn_chunks_redstone_processing", false, () -> ModuleManager.getModule(SpawnChunks.class).isEnabled() || ModuleManager.getModule(SpawnChunksPlayer.class).isEnabled()), SettingLocation.OVERLAYS);
    public final BooleanSetting spawnChunksOuterChunksEnabled = this.register(BooleanSetting.create("Spawn Chunks Outer Chunks", "xaeroplus.setting.spawn_chunks_outer_chunks", false, () -> ModuleManager.getModule(SpawnChunks.class).isEnabled() || ModuleManager.getModule(SpawnChunksPlayer.class).isEnabled()), SettingLocation.OVERLAYS);
    public final EnumSetting<ColorHelper.HighlightColor> spawnChunksEntityProcessingColor = this.register(EnumSetting.create((String)"Spawn Chunks Entity Processing Color", (String)"xaeroplus.setting.spawn_chunks_entity_processing_color", (Enum[])ColorHelper.HighlightColor.values(), (Enum)ColorHelper.HighlightColor.GREEN, b -> {
        ModuleManager.getModule(SpawnChunks.class).setEntityProcessingColor(b.getColor());
        ModuleManager.getModule(SpawnChunksPlayer.class).setEntityProcessingColor(b.getColor());
    }, () -> ModuleManager.getModule(SpawnChunks.class).isEnabled() || ModuleManager.getModule(SpawnChunksPlayer.class).isEnabled()), SettingLocation.OVERLAYS);
    public final EnumSetting<ColorHelper.HighlightColor> spawnChunksRedstoneProcessingColor = this.register(EnumSetting.create((String)"Spawn Chunks Redstone Processing Color", (String)"xaeroplus.setting.spawn_chunks_redstone_processing_color", (Enum[])ColorHelper.HighlightColor.values(), (Enum)ColorHelper.HighlightColor.RED, b -> {
        ModuleManager.getModule(SpawnChunks.class).setRedstoneProcessingColor(b.getColor());
        ModuleManager.getModule(SpawnChunksPlayer.class).setRedstoneProcessingColor(b.getColor());
    }, () -> ModuleManager.getModule(SpawnChunks.class).isEnabled() || ModuleManager.getModule(SpawnChunksPlayer.class).isEnabled()), SettingLocation.OVERLAYS);
    public final EnumSetting<ColorHelper.HighlightColor> spawnChunksLazyChunksColor = this.register(EnumSetting.create((String)"Spawn Chunks Lazy Chunks Color", (String)"xaeroplus.setting.spawn_chunks_lazy_chunks_color", (Enum[])ColorHelper.HighlightColor.values(), (Enum)ColorHelper.HighlightColor.BLUE, b -> {
        ModuleManager.getModule(SpawnChunks.class).setLazyChunksColor(b.getColor());
        ModuleManager.getModule(SpawnChunksPlayer.class).setLazyChunksColor(b.getColor());
    }, () -> ModuleManager.getModule(SpawnChunks.class).isEnabled() || ModuleManager.getModule(SpawnChunksPlayer.class).isEnabled()), SettingLocation.OVERLAYS);
    public final EnumSetting<ColorHelper.HighlightColor> spawnChunksOuterChunksColor = this.register(EnumSetting.create((String)"Spawn Chunks Outer Chunks Color", (String)"xaeroplus.setting.spawn_chunks_outer_chunks_color", (Enum[])ColorHelper.HighlightColor.values(), (Enum)ColorHelper.HighlightColor.YELLOW, b -> {
        ModuleManager.getModule(SpawnChunks.class).setOuterChunksColor(b.getColor());
        ModuleManager.getModule(SpawnChunksPlayer.class).setOuterChunksColor(b.getColor());
    }, () -> ModuleManager.getModule(SpawnChunks.class).isEnabled() || ModuleManager.getModule(SpawnChunksPlayer.class).isEnabled()), SettingLocation.OVERLAYS);
    public final BooleanSetting mapArtGridEnabledSetting = this.register(BooleanSetting.create("Map Art Grid", "xaeroplus.setting.map_art_grid", false, true, b -> ModuleManager.getModule(MapArtGrid.class).setEnabled(b)), SettingLocation.OVERLAYS);
    public final EnumSetting<ColorHelper.HighlightColor> mapArtGridColorSetting = this.register(EnumSetting.create((String)"Map Art Grid Color", (String)"xaeroplus.setting.map_art_grid_color", (Enum[])ColorHelper.HighlightColor.values(), (Enum)ColorHelper.HighlightColor.RED, b -> ModuleManager.getModule(MapArtGrid.class).setRgbColor(b.getColor()), () -> ModuleManager.getModule(MapArtGrid.class).isEnabled()), SettingLocation.OVERLAYS);
    public final BooleanSetting regionGridEnabledSetting = this.register(BooleanSetting.create("Region Grid", "xaeroplus.setting.region_grid", false, true, b -> ModuleManager.getModule(RegionGrid.class).setEnabled(b)), SettingLocation.OVERLAYS);
    public final EnumSetting<ColorHelper.HighlightColor> regionGridColorSetting = this.register(EnumSetting.create((String)"Region Grid Color", (String)"xaeroplus.setting.region_grid_color", (Enum[])ColorHelper.HighlightColor.values(), (Enum)ColorHelper.HighlightColor.RED, b -> ModuleManager.getModule(RegionGrid.class).setRgbColor(b.getColor()), () -> ModuleManager.getModule(RegionGrid.class).isEnabled()), SettingLocation.OVERLAYS);
    public final BooleanSetting regionGridTextSetting = this.register(BooleanSetting.create("Region Grid Text", "xaeroplus.setting.region_grid_text", false, false, b -> ModuleManager.getModule(RegionGrid.class).setTextEnabled(b), () -> ModuleManager.getModule(RegionGrid.class).isEnabled()), SettingLocation.OVERLAYS);
    public final DoubleSetting drawingOpacitySetting = this.register(DoubleSetting.create("Drawing Opacity", "xaeroplus.setting.drawing_opacity", 0.0, 255.0, 10.0, 150.0, b -> ModuleManager.getModule(Drawing.class).setOpacity((int)b)), SettingLocation.OVERLAYS);
    public final BooleanSetting minimapFpsLimiter = this.register(BooleanSetting.create("Minimap FPS Limiter", "xaeroplus.setting.fps_limiter", false, b -> ModuleManager.getModule(FpsLimiter.class).setEnabled(b)), SettingLocation.MINIMAP_MAIN);
    public final DoubleSetting minimapFpsLimit = this.register(DoubleSetting.create("Minimap FPS Limit", "xaeroplus.setting.fps_limiter_limit", 5.0, 120.0, 5.0, 60.0), SettingLocation.MINIMAP_MAIN);
    public final BooleanSetting transparentMinimapBackground = this.register(BooleanSetting.create("Transparent Background", "xaeroplus.setting.transparent_background", false), SettingLocation.MINIMAP_VIEW);
    public final DoubleSetting minimapScaleMultiplierSetting = this.register(DoubleSetting.create("Minimap Scaling Factor", "xaeroplus.setting.minimap_scaling", 1.0, 5.0, 1.0, 1.0, b -> {
        Globals.shouldResetFBO = true;
    }), SettingLocation.MINIMAP_VIEW);
    public final DoubleSetting minimapSizeMultiplierSetting = this.register(DoubleSetting.create("Minimap Size Multiplier", "xaeroplus.setting.minimap_size_multiplier", 1.0, 4.0, 1.0, 1.0, b -> {
        Globals.shouldResetFBO = true;
    }), SettingLocation.MINIMAP_VIEW);
    public final DoubleSetting minimapRenderZOffsetSetting = this.register(DoubleSetting.create("Minimap Render Z", "xaeroplus.setting.minimap_render_z_offset", -1000.0, 1000.0, 50.0, 0.0), SettingLocation.MINIMAP_VIEW);
    public final BooleanSetting alwaysRenderPlayerWithNameOnRadar = this.register(BooleanSetting.create("Always Render Player Name", "xaeroplus.setting.always_render_player_name", true), SettingLocation.MINIMAP_ENTITY_RADAR);
    public final BooleanSetting alwaysRenderPlayerIconOnRadar = this.register(BooleanSetting.create("Always Render Player Icon", "xaeroplus.setting.always_render_player_icon", true), SettingLocation.MINIMAP_ENTITY_RADAR);
    public final BooleanSetting fixMainEntityDot = this.register(BooleanSetting.create("Fix Main Entity Dot", "xaeroplus.setting.fix_main_entity_dot", true), SettingLocation.MINIMAP_ENTITY_RADAR);
    public final BooleanSetting radarHideInvisibleEntities = this.register(BooleanSetting.create("Hide Invisible Entities", "xaeroplus.setting.radar_hide_invisible_entities", true, b -> {
        if (!Globals.minimapSettingsInitialized) {
            return;
        }
        try {
            HudMod.INSTANCE.getSettings().radarHideInvisibleEntities = b;
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error updating radarHideInvisibleEntities", (Throwable)e);
        }
    }), SettingLocation.MINIMAP_ENTITY_RADAR);
    public final BooleanSetting waypointBeacons = this.register(BooleanSetting.create("Waypoint Beacons", "xaeroplus.setting.waypoint_beacons", false), SettingLocation.MINIMAP_WAYPOINTS);
    public final DoubleSetting waypointBeaconScaleMin = this.register(DoubleSetting.create("Waypoint Beacon Scale Min", "xaeroplus.setting.waypoint_beacon_scale_min", 0.0, 30.0, 1.0, 0.0, this.waypointBeacons::get), SettingLocation.MINIMAP_WAYPOINTS);
    public final DoubleSetting waypointBeaconDistanceMin = this.register(DoubleSetting.create("Waypoint Beacon Distance Min", "xaeroplus.setting.waypoint_beacon_distance_min", 0.0, 512.0, 8.0, 0.0, this.waypointBeacons::get), SettingLocation.MINIMAP_WAYPOINTS);
    public final BooleanSetting waypointEta = this.register(BooleanSetting.create("Waypoint ETA", "xaeroplus.setting.waypoint_eta", false), SettingLocation.MINIMAP_WAYPOINTS);
    public final DoubleSetting waypointEtaMeasurementInterval = this.register(DoubleSetting.create("Waypoint ETA Measurement Interval", "xaeroplus.setting.waypoint_eta_measurement_interval", 0.0, 120.0, 2.0, 10.0, v -> WaypointEtaManager.INSTANCE.updateMeasurementInterval((int)v), this.waypointEta::get), SettingLocation.MINIMAP_WAYPOINTS);
    public final BooleanSetting longWaypointInitials = this.register(BooleanSetting.create("Long Waypoint Initials", "xaeroplus.setting.allow_longer_waypoint_initials", false), SettingLocation.MINIMAP_WAYPOINTS);
    public final BooleanSetting disableWaypointSharing = this.register(BooleanSetting.create("Disable Waypoint Sharing", "xaeroplus.setting.disable_waypoint_sharing", false), SettingLocation.MINIMAP_WAYPOINTS);
    public final BooleanSetting plainWaypointSharing = this.register(BooleanSetting.create("Plain Waypoint Sharing", "xaeroplus.setting.plain_waypoint_sharing", false), SettingLocation.MINIMAP_WAYPOINTS);
    public final BooleanSetting disableReceivingWaypoints = this.register(BooleanSetting.create("Disable Receiving Waypoints", "xaeroplus.setting.disable_receiving_waypoints", false), SettingLocation.MINIMAP_WAYPOINTS);
    public final BooleanSetting limitDeathpointsRenderDistance = this.register(BooleanSetting.create("Deathpoints Render Distance", "xaeroplus.setting.deathpoints_render_distance", false), SettingLocation.MINIMAP_WAYPOINTS);
    public final BooleanSetting disableWaypointSetChangeTooltip = this.register(BooleanSetting.create("Disable Waypoint Set Change Tooltip", "xaeroplus.setting.waypoint_set_change_tooltip", false), SettingLocation.MINIMAP_WAYPOINTS);
    public final BooleanSetting switchToNetherSetting = this.register(BooleanSetting.create("Switch to Nether", "xaeroplus.keybind.switch_to_nether", false, true, b -> Globals.switchToDimension((ResourceKey<Level>)Level.NETHER)), SettingLocation.KEYBINDS);
    public final BooleanSetting switchToOverworldSetting = this.register(BooleanSetting.create("Switch to Overworld", "xaeroplus.keybind.switch_to_overworld", false, true, b -> Globals.switchToDimension((ResourceKey<Level>)Level.OVERWORLD)), SettingLocation.KEYBINDS);
    public final BooleanSetting switchToEndSetting = this.register(BooleanSetting.create("Switch to End", "xaeroplus.keybind.switch_to_end", false, true, b -> Globals.switchToDimension((ResourceKey<Level>)Level.END)), SettingLocation.KEYBINDS);
    public final BooleanSetting switchWaypointsToNetherSetting = this.register(BooleanSetting.create("Switch Waypoints to Nether", "xaeroplus.keybind.switch_waypoints_to_nether", false, true, b -> WaypointAPI.switchWaypointDimension((ResourceKey<Level>)Level.NETHER)), SettingLocation.KEYBINDS);
    public final BooleanSetting switchWaypointsToOverworldSetting = this.register(BooleanSetting.create("Switch Waypoints to Overworld", "xaeroplus.keybind.switch_waypoints_to_overworld", false, true, b -> WaypointAPI.switchWaypointDimension((ResourceKey<Level>)Level.OVERWORLD)), SettingLocation.KEYBINDS);
    public final BooleanSetting switchWaypointsToEndSetting = this.register(BooleanSetting.create("Switch Waypoints to End", "xaeroplus.keybind.switch_waypoints_to_end", false, true, b -> WaypointAPI.switchWaypointDimension((ResourceKey<Level>)Level.END)), SettingLocation.KEYBINDS);
    public final BooleanSetting worldMapBaritoneGoalHereKeybindSetting = this.register(BooleanSetting.create("WorldMap Baritone Goal Here", "xaeroplus.keybind.world_map_baritone_goal_here", false, true), SettingLocation.KEYBINDS);
    public final BooleanSetting worldMapBaritonePathHereKeybindSetting = this.register(BooleanSetting.create("WorldMap Baritone Path Here", "xaeroplus.keybind.world_map_baritone_path_here", false, true), SettingLocation.KEYBINDS);
    public final BooleanSetting worldMapBaritoneElytraHereKeybindSetting = this.register(BooleanSetting.create("WorldMap Baritone Elytra Here", "xaeroplus.keybind.world_map_baritone_elytra_here", false, true), SettingLocation.KEYBINDS);
    public final BooleanSetting worldMapToggleDrawingKeybindSetting = this.register(BooleanSetting.create("WorldMap Toggle Drawing", "xaeroplus.gui.world_map.start_drawing", false, true), SettingLocation.KEYBINDS);
    public final StringSetting drawOrderSetting = this.register(StringSetting.create("Draw Order", "xaeroplus.setting.draw_order", "", s -> Globals.drawManager.registry().loadOrder((String)s)), SettingLocation.CHUNK_HIGHLIGHTS);

    private Settings() {
    }

    static void markChunksDirtyInWriteDistance() {
        WorldMapSession session;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && mc.player != null && (session = WorldMapSession.getCurrentSession()) != null) {
            session.getMapProcessor().getMapWriter().setDirtyInWriteDistance((Player)mc.player, (Level)mc.level);
            session.getMapProcessor().getMapWriter().requestCachedColoursClear();
        }
    }

    public static enum WaystoneWpVisibilityType implements TranslatableSettingEnum
    {
        LOCAL("xaeroplus.gui.waystone_visibility_type.local"),
        GLOBAL("xaeroplus.gui.waystone_visibility_type.global"),
        WORLD_MAP_LOCAL("xaeroplus.gui.waystone_visibility_type.world_map_local"),
        WORLD_MAP_GLOBAL("xaeroplus.gui.waystone_visibility_type.world_map_global");

        private final String translationKey;

        private WaystoneWpVisibilityType(String translationKey) {
            this.translationKey = translationKey;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    public static enum DataFolderResolutionMode implements TranslatableSettingEnum
    {
        IP("xaeroplus.setting.data_folder_resolution_mode.ip"),
        SERVER_NAME("xaeroplus.setting.data_folder_resolution_mode.server_name"),
        BASE_DOMAIN("xaeroplus.setting.data_folder_resolution_mode.base_domain");

        private final String translationKey;

        private DataFolderResolutionMode(String translationKey) {
            this.translationKey = translationKey;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    public static enum HighwayWidth implements TranslatableSettingEnum
    {
        ONE(1),
        THREE(3),
        FIVE(5);

        private final int width;

        private HighwayWidth(int width) {
            this.width = width;
        }

        @Override
        public String getTranslationKey() {
            return String.valueOf(this.width);
        }

        public int getWidth() {
            return this.width;
        }
    }
}

