/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.highlights;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import xaeroplus.feature.highlights.ChunkHighlightCache;
import xaeroplus.util.ChunkUtils;

public abstract class ChunkHighlightBaseCacheHandler
implements ChunkHighlightCache {
    public final Long2LongMap chunks = new Long2LongOpenHashMap();
    public class_310 mc = class_310.method_1551();

    public ChunkHighlightBaseCacheHandler() {
        this.chunks.defaultReturnValue(-1L);
    }

    @Override
    public void addHighlight(int x, int z) {
        this.addHighlight(x, z, System.currentTimeMillis());
    }

    @Override
    public void addHighlight(int x, int z, class_5321<class_1937> dimensionId) {
        this.addHighlight(x, z);
    }

    @Override
    public void addHighlight(int x, int z, long foundTime) {
        if (!this.mc.method_18854()) {
            throw new RuntimeException("addHighlight must be called on the main thread!");
        }
        this.chunks.put(ChunkUtils.chunkPosToLong(x, z), foundTime);
    }

    @Override
    public void removeHighlight(int x, int z) {
        if (!this.mc.method_18854()) {
            throw new RuntimeException("removeHighlight must be called on the main thread!");
        }
        this.chunks.remove(ChunkUtils.chunkPosToLong(x, z));
    }

    @Override
    public void removeHighlight(int x, int z, class_5321<class_1937> dimensionId) {
        this.removeHighlight(x, z);
    }

    @Override
    public boolean isHighlighted(int x, int z, class_5321<class_1937> dimensionId) {
        return this.isHighlighted(ChunkUtils.chunkPosToLong(x, z));
    }

    @Override
    public Long2LongMap getCacheMap(class_5321<class_1937> dimension) {
        return this.chunks;
    }

    public boolean isHighlighted(long chunkPos) {
        return this.chunks.containsKey(chunkPos);
    }

    public void replaceState(Long2LongOpenHashMap state) {
        if (!this.mc.method_18854()) {
            throw new RuntimeException("replaceState must be called on the main thread!");
        }
        this.chunks.clear();
        this.chunks.putAll((Map)state);
    }

    public void reset() {
        if (!this.mc.method_18854()) {
            throw new RuntimeException("reset must be called on the main thread!");
        }
        this.chunks.clear();
    }
}

