/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.lenni0451.lambdaevents.EventHandler;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2814;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2834;
import net.minecraft.class_2837;
import net.minecraft.class_2841;
import net.minecraft.class_5321;
import net.minecraft.class_6490;
import net.minecraft.class_6880;
import net.minecraft.class_7522;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ChunkDataEvent;
import xaeroplus.feature.highlights.SavableHighlightCacheInstance;
import xaeroplus.feature.render.DrawFeatureFactory;
import xaeroplus.module.Module;
import xaeroplus.settings.Settings;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class PaletteNewChunks
extends Module {
    public final SavableHighlightCacheInstance newChunksCache = new SavableHighlightCacheInstance("XaeroPlusPaletteNewChunks");
    public final SavableHighlightCacheInstance newChunksInverseCache = new SavableHighlightCacheInstance("XaeroPlusPaletteNewChunksInverse");
    private int newChunksColor = ColorHelper.getColor(255, 0, 0, 100);
    private final IntSet presentStateIdsBuf = new IntOpenHashSet();
    private final IntList presentStateIdsOrderedBuf = new IntArrayList();
    private boolean renderInverse = false;

    public void setDiskCache(boolean disk) {
        this.newChunksCache.setDiskCache(disk, this.isEnabled());
        this.newChunksInverseCache.setDiskCache(disk, this.isEnabled());
    }

    @EventHandler
    public void onChunkData(ChunkDataEvent event) {
        if (event.seenChunk()) {
            return;
        }
        class_5321<class_1937> dim = ChunkUtils.getActualDimension();
        class_2818 chunk = event.chunk();
        int x = chunk.method_12004().field_9181;
        int z = chunk.method_12004().field_9180;
        try {
            if (this.newChunksCache.get().isHighlighted(x, z, dim)) {
                return;
            }
            if (this.newChunksInverseCache.get().isHighlighted(x, z, dim)) {
                return;
            }
            if (this.isNewChunk(dim, chunk)) {
                this.newChunksCache.get().addHighlight(x, z);
            } else {
                this.newChunksInverseCache.get().addHighlight(x, z);
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error checking palette NewChunk at [{} {}]", new Object[]{x, z, e});
        }
    }

    private boolean isNewChunk(class_5321<class_1937> dim, class_2818 chunk) {
        if (dim == class_1937.field_25179) {
            boolean bl;
            if (Settings.REGISTRY.paletteNewChunksVersionUpgradedChunks.get()) {
                bl = this.checkNewChunkBlockStatePalette(chunk);
            } else {
                switch (this.checkNewChunkBiomePalette(chunk, true).ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        bl = false;
                        break;
                    }
                    case 1: {
                        bl = true;
                        break;
                    }
                    case 2: {
                        bl = this.checkNewChunkBlockStatePalette(chunk);
                    }
                }
            }
            return bl;
        }
        if (dim == class_1937.field_25180) {
            return Settings.REGISTRY.paletteNewChunksVersionUpgradedChunks.get() ? this.checkNewChunkBlockStatePalette(chunk) : this.checkNewChunkBiomePalette(chunk, false) == BiomeCheckResult.PLAINS_IN_PALETTE;
        }
        if (dim == class_1937.field_25181) {
            return this.checkNewChunkBiomePalette(chunk, false) == BiomeCheckResult.PLAINS_IN_PALETTE;
        }
        return false;
    }

    private boolean checkNewChunkBlockStatePalette(class_2818 chunk) {
        class_2826[] sections = chunk.method_12006();
        if (sections.length == 0) {
            return false;
        }
        for (int i = 0; i < Math.min(sections.length, 8); ++i) {
            class_2826 section = sections[i];
            class_2841.class_6561 paletteContainerData = section.method_12265().field_34560;
            class_2837 palette = paletteContainerData.comp_119();
            if (palette.method_12197() < 2) continue;
            if (palette instanceof class_2834) {
                return this.checkLinearPaletteOrder((class_2837<class_2680>)palette, section);
            }
            if (!(palette instanceof class_2814) || !this.checkForExtraPaletteEntries((class_2841.class_6561<class_2680>)paletteContainerData)) continue;
            return true;
        }
        return false;
    }

    private boolean checkLinearPaletteOrder(class_2837<class_2680> palette, class_2826 section) {
        this.presentStateIdsOrderedBuf.clear();
        for (int id = 0; id < palette.method_12197(); ++id) {
            int blockStateId = class_2248.method_9507((class_2680)((class_2680)palette.method_12288(id)));
            this.presentStateIdsOrderedBuf.add(blockStateId);
        }
        this.presentStateIdsBuf.clear();
        AtomicInteger searchIndex = new AtomicInteger(0);
        AtomicBoolean isNewChunk = new AtomicBoolean(false);
        section.method_12265().field_34560.comp_118().method_21739(dataId -> {
            if (isNewChunk.get()) {
                return;
            }
            if (searchIndex.get() == this.presentStateIdsOrderedBuf.size()) {
                return;
            }
            int blockStateId = class_2248.method_9507((class_2680)((class_2680)palette.method_12288(dataId)));
            if (this.presentStateIdsBuf.contains(blockStateId)) {
                return;
            }
            int nextExpectedId = this.presentStateIdsOrderedBuf.getInt(searchIndex.get());
            if (blockStateId == nextExpectedId) {
                this.presentStateIdsBuf.add(blockStateId);
                searchIndex.incrementAndGet();
            } else {
                isNewChunk.set(true);
            }
        });
        return isNewChunk.get();
    }

    private BiomeCheckResult checkNewChunkBiomePalette(class_2818 chunk, boolean checkData) {
        class_2826[] sections = chunk.method_12006();
        if (sections.length == 0) {
            return BiomeCheckResult.NO_PLAINS;
        }
        class_2826 firstSection = sections[0];
        class_7522 biomes = firstSection.method_38294();
        if (biomes instanceof class_2841) {
            class_2841 biomesPaletteContainer = (class_2841)biomes;
            class_2837 palette = biomesPaletteContainer.field_34560.comp_119();
            boolean paletteContainsPlains = palette.method_19525(PaletteNewChunks::isPlainsBiome);
            if (paletteContainsPlains && checkData) {
                if (palette.method_12197() == 1) {
                    return BiomeCheckResult.PLAINS_PRESENT;
                }
                class_6490 storage = biomesPaletteContainer.field_34560.comp_118();
                this.presentStateIdsBuf.clear();
                storage.method_21739(arg_0 -> ((IntSet)this.presentStateIdsBuf).add(arg_0));
                IntIterator intIterator = this.presentStateIdsBuf.iterator();
                while (intIterator.hasNext()) {
                    int id = (Integer)intIterator.next();
                    if (!PaletteNewChunks.isPlainsBiome((class_6880<class_1959>)((class_6880)palette.method_12288(id)))) continue;
                    return BiomeCheckResult.PLAINS_PRESENT;
                }
            }
            if (paletteContainsPlains) {
                return BiomeCheckResult.PLAINS_IN_PALETTE;
            }
        }
        return BiomeCheckResult.NO_PLAINS;
    }

    private synchronized boolean checkForExtraPaletteEntries(class_2841.class_6561<class_2680> paletteContainer) {
        this.presentStateIdsBuf.clear();
        class_2837 palette = paletteContainer.comp_119();
        class_6490 storage = paletteContainer.comp_118();
        storage.method_21739(arg_0 -> ((IntSet)this.presentStateIdsBuf).add(arg_0));
        return palette.method_12197() > this.presentStateIdsBuf.size();
    }

    private static boolean isPlainsBiome(class_6880<class_1959> holder) {
        return holder.method_40225(class_1972.field_9451);
    }

    @Override
    public void onEnable() {
        Globals.drawManager.registry().register(DrawFeatureFactory.chunkHighlights("PaletteNewChunks", this::getHighlightsState, this::getNewChunksColor, 250));
        this.newChunksCache.onEnable();
        this.newChunksInverseCache.onEnable();
    }

    @Override
    public void onDisable() {
        this.newChunksCache.onDisable();
        this.newChunksInverseCache.onDisable();
        Globals.drawManager.registry().unregister("PaletteNewChunks");
    }

    public int getNewChunksColor() {
        return this.newChunksColor;
    }

    public void setRgbColor(int color) {
        this.newChunksColor = ColorHelper.getColorWithAlpha(color, Settings.REGISTRY.paletteNewChunksAlphaSetting.getAsInt());
    }

    public void setAlpha(double a) {
        this.newChunksColor = ColorHelper.getColorWithAlpha(this.newChunksColor, (int)a);
    }

    public void setInverse(boolean b) {
        this.renderInverse = b;
    }

    public boolean isHighlighted(int chunkPosX, int chunkPosZ, class_5321<class_1937> dimensionId) {
        return this.renderInverse ? this.isInverseNewChunk(chunkPosX, chunkPosZ, dimensionId) : this.isNewChunk(chunkPosX, chunkPosZ, dimensionId);
    }

    public Long2LongMap getHighlightsState(class_5321<class_1937> dimension) {
        return this.renderInverse ? this.newChunksInverseCache.get().getCacheMap(dimension) : this.newChunksCache.get().getCacheMap(dimension);
    }

    public boolean isNewChunk(int chunkPosX, int chunkPosZ, class_5321<class_1937> dimensionId) {
        return this.newChunksCache.get().isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    public boolean isInverseNewChunk(int chunkPosX, int chunkPosZ, class_5321<class_1937> dimensionId) {
        return this.newChunksInverseCache.get().isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    static enum BiomeCheckResult {
        NO_PLAINS,
        PLAINS_IN_PALETTE,
        PLAINS_PRESENT;

    }
}

