/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.fabric;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Optional;
import java.util.concurrent.Executor;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_437;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.set.WaypointSet;
import xaeroplus.XaeroPlus;
import xaeroplus.fabric.util.FabricWaystonesHelperInit;
import xaeroplus.fabric.util.XPShaderResourceReloadListener;
import xaeroplus.fabric.util.compat.IncompatibleMinimapWarningScreen;
import xaeroplus.fabric.util.compat.VersionCheckResult;
import xaeroplus.fabric.util.compat.XaeroPlusMinimapCompatibilityChecker;
import xaeroplus.feature.waypoint.WaypointAPI;
import xaeroplus.module.ModuleManager;
import xaeroplus.module.impl.TickTaskExecutor;
import xaeroplus.settings.Settings;
import xaeroplus.util.AtlasWaypointImport;
import xaeroplus.util.DataFolderResolveUtil;
import xaeroplus.util.XaeroPlusGameTest;

public class XaeroPlusFabric
implements ClientModInitializer {
    public static void initialize() {
        if (XaeroPlus.initialized.compareAndSet(false, true)) {
            XaeroPlus.LOGGER.info("Initializing XaeroPlus");
            if (!XaeroPlusMinimapCompatibilityChecker.versionCheckResult.minimapCompatible()) {
                XaeroPlus.LOGGER.error("Incompatible Xaero Minimap version detected! Expected: {} Actual: {}", (Object)XaeroPlusMinimapCompatibilityChecker.versionCheckResult.expectedVersion().getFriendlyString(), (Object)XaeroPlusMinimapCompatibilityChecker.versionCheckResult.anyPresentMinimapVersion().map(Version::getFriendlyString).orElse("None!"));
                return;
            }
            XaeroPlus.XP_VERSION = FabricLoader.getInstance().getModContainer("xaeroplus").map(ModContainer::getMetadata).map(ModMetadata::getVersion).map(Version::getFriendlyString).orElse("2.x");
            FabricWaystonesHelperInit.doInit();
            XaeroPlus.initializeSettings();
            Settings.REGISTRY.getKeybindings().forEach(KeyBindingHelper::registerKeyBinding);
            if (System.getenv("XP_CI_TEST") != null || System.getProperty("XP_CI_TEST") != null) {
                class_310.method_1551().execute(XaeroPlusGameTest::applyMixinsTest);
            }
        }
    }

    public void onInitializeClient() {
        XaeroPlusFabric.initialize();
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            VersionCheckResult versionCheckResult = XaeroPlusMinimapCompatibilityChecker.versionCheckResult;
            if (versionCheckResult.minimapCompatible()) {
                return;
            }
            Optional<Version> anyPresentVersion = versionCheckResult.minimapVersion().or(versionCheckResult::betterPvpVersion);
            class_310.method_1551().method_1507((class_437)new IncompatibleMinimapWarningScreen(anyPresentVersion, versionCheckResult.expectedVersion()));
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"xaeroDataDir").executes(c -> {
                ((FabricClientCommandSource)c.getSource()).sendFeedback(DataFolderResolveUtil.getCurrentDataDirPath());
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"xaeroWaypointDir").executes(c -> {
                ((FabricClientCommandSource)c.getSource()).sendFeedback(DataFolderResolveUtil.getCurrentWaypointDataDirPath());
                return 1;
            }));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"xaero2b2tAtlasImport").executes(c -> {
                ((FabricClientCommandSource)c.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Atlas import started..."));
                AtlasWaypointImport.importAtlasWaypoints().whenCompleteAsync((addedCount, e) -> {
                    if (e != null) {
                        XaeroPlus.LOGGER.error("Atlas import failed", e);
                        ((FabricClientCommandSource)c.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Atlas import failed! Check log for details."));
                    } else {
                        ((FabricClientCommandSource)c.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(addedCount + " waypoints imported to the \"atlas\" waypoint set!")));
                        MinimapSession session = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
                        boolean allSetsEnabled = session.getModMain().getSettings().renderAllSets;
                        boolean isAtlasSetActive = Optional.ofNullable(WaypointAPI.getCurrentWaypointSet()).map(WaypointSet::getName).filter(n -> n.equals("atlas")).isPresent();
                        if (!allSetsEnabled && !isAtlasSetActive) {
                            ((FabricClientCommandSource)c.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"To see the waypoints, enable rendering all waypoint sets or switch to the \"atlas\" set."));
                        }
                    }
                    ((FabricClientCommandSource)c.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Atlas Import Complete!"));
                }, (Executor)ModuleManager.getModule(TickTaskExecutor.class));
                return 1;
            }));
        });
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new XPShaderResourceReloadListener());
    }
}

