/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import java.util.concurrent.ThreadLocalRandom;
import xaeroplus.Globals;
import xaeroplus.feature.render.ChunkHighlightDrawFeature;
import xaeroplus.feature.render.DirectChunkHighlightProvider;
import xaeroplus.feature.render.HighlightDrawBuffer;

public class DirectChunkHighlightDrawFeature
implements ChunkHighlightDrawFeature {
    private final DirectChunkHighlightProvider chunkHighlightProvider;
    private final HighlightDrawBuffer drawBuffer = new HighlightDrawBuffer();
    private int lastRefreshedHighlightCount = 0;
    private final boolean refreshEveryTick;

    public DirectChunkHighlightDrawFeature(DirectChunkHighlightProvider chunkHighlightProvider, boolean refreshEveryTick) {
        this.chunkHighlightProvider = chunkHighlightProvider;
        this.refreshEveryTick = refreshEveryTick;
    }

    @Override
    public int colorInt() {
        return this.chunkHighlightProvider.colorSupplier().getAsInt();
    }

    @Override
    public void invalidateCache() {
        this.drawBuffer.markStale();
    }

    @Override
    public Long2LongMap getChunkHighlights() {
        return this.chunkHighlightProvider.chunkHighlightSupplier().getHighlights(Globals.getCurrentDimensionId());
    }

    @Override
    public void render(boolean worldmap) {
        Long2LongMap highlights = this.getChunkHighlights();
        if (this.refreshEveryTick) {
            if (System.currentTimeMillis() - this.drawBuffer.lastRefreshed >= 50L) {
                this.invalidateCache();
            }
        } else if (this.lastRefreshedHighlightCount != highlights.size() && System.currentTimeMillis() - this.drawBuffer.lastRefreshed > 500L + (long)ThreadLocalRandom.current().nextInt(0, 100)) {
            this.invalidateCache();
            this.lastRefreshedHighlightCount = highlights.size();
        }
        if (this.drawBuffer.needsRefresh(worldmap)) {
            this.drawBuffer.refresh(highlights, worldmap);
        }
        this.drawBuffer.render();
    }

    @Override
    public void close() {
        this.drawBuffer.close();
    }
}

