/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.minecraft.class_310;
import xaeroplus.feature.render.AsyncChunkHighlightDrawFeature;
import xaeroplus.feature.render.AsyncChunkHighlightProvider;
import xaeroplus.feature.render.AsyncChunkHighlightSupplier;
import xaeroplus.feature.render.ChunkHighlightDrawFeature;
import xaeroplus.feature.render.DirectChunkHighlightDrawFeature;
import xaeroplus.feature.render.DirectChunkHighlightProvider;
import xaeroplus.feature.render.DirectChunkHighlightSupplier;
import xaeroplus.feature.render.LineDrawFeature;
import xaeroplus.feature.render.LineProvider;
import xaeroplus.feature.render.LineSupplier;
import xaeroplus.util.FloatSupplier;

public class DrawFeatureRegistry {
    private final HashMap<String, ChunkHighlightDrawFeature> chunkHighlightDrawFeatures = new HashMap();
    private final HashMap<String, LineDrawFeature> lineDrawFeatures = new HashMap();
    private final List<String> sortedChunkHighlightKeySet = new ArrayList<String>();
    private final List<String> sortedLineKeySet = new ArrayList<String>();

    public synchronized void registerDirectChunkHighlightProvider(String id, DirectChunkHighlightSupplier chunkHighlightSupplier, IntSupplier colorSupplier) {
        this.registerChunkHighlightDrawFeature(id, new DirectChunkHighlightDrawFeature(new DirectChunkHighlightProvider(chunkHighlightSupplier, colorSupplier), false));
    }

    public synchronized void registerDirectChunkHighlightProvider(String id, boolean refreshEveryTick, DirectChunkHighlightSupplier chunkHighlightSupplier, IntSupplier colorSupplier) {
        this.registerChunkHighlightDrawFeature(id, new DirectChunkHighlightDrawFeature(new DirectChunkHighlightProvider(chunkHighlightSupplier, colorSupplier), refreshEveryTick));
    }

    public synchronized void registerAsyncChunkHighlightProvider(String id, AsyncChunkHighlightSupplier chunkHighlightSupplier, IntSupplier colorSupplier) {
        this.registerChunkHighlightDrawFeature(id, new AsyncChunkHighlightDrawFeature(new AsyncChunkHighlightProvider(chunkHighlightSupplier, colorSupplier)));
    }

    private synchronized void registerChunkHighlightDrawFeature(String id, ChunkHighlightDrawFeature drawFeature) {
        this.unregisterChunkHighlightProvider(id);
        this.chunkHighlightDrawFeatures.put(id, drawFeature);
        this.sortedChunkHighlightKeySet.add(id);
        this.sortedChunkHighlightKeySet.sort(Comparator.naturalOrder());
    }

    public synchronized void unregisterChunkHighlightProvider(String id) {
        this.sortedChunkHighlightKeySet.remove(id);
        ChunkHighlightDrawFeature feature = this.chunkHighlightDrawFeatures.remove(id);
        if (feature != null) {
            class_310.method_1551().execute(feature::close);
        }
    }

    public synchronized void registerLineProvider(String id, LineSupplier lineSupplier, IntSupplier colorSupplier, FloatSupplier lineWidthSupplier, int refreshIntervalMs) {
        this.unregisterLineProvider(id);
        this.lineDrawFeatures.put(id, new LineDrawFeature(new LineProvider(lineSupplier, colorSupplier, lineWidthSupplier), refreshIntervalMs));
        this.sortedLineKeySet.add(id);
        this.sortedLineKeySet.sort(Comparator.naturalOrder());
    }

    public synchronized void unregisterLineProvider(String id) {
        this.sortedLineKeySet.remove(id);
        this.lineDrawFeatures.remove(id);
    }

    protected synchronized void invalidateCaches() {
        this.chunkHighlightDrawFeatures.values().forEach(ChunkHighlightDrawFeature::invalidateCache);
        this.lineDrawFeatures.values().forEach(LineDrawFeature::invalidateCache);
    }

    protected synchronized void forEachChunkHighlightDrawFeature(Consumer<ChunkHighlightDrawFeature> consumer) {
        for (int i = 0; i < this.sortedChunkHighlightKeySet.size(); ++i) {
            ChunkHighlightDrawFeature feature = this.chunkHighlightDrawFeatures.get(this.sortedChunkHighlightKeySet.get(i));
            if (feature == null) continue;
            consumer.accept(feature);
        }
    }

    protected synchronized void forEachLineDrawFeature(Consumer<LineDrawFeature> consumer) {
        for (int i = 0; i < this.sortedLineKeySet.size(); ++i) {
            LineDrawFeature feature = this.lineDrawFeatures.get(this.sortedLineKeySet.get(i));
            if (feature == null) continue;
            consumer.accept(feature);
        }
    }
}

