/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_6379;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.animation.SlowingAnimation;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.element.MapElementRenderHandler;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.gui.IRightClickableElement;
import xaero.map.gui.MapTileSelection;
import xaero.map.gui.ScreenBase;
import xaero.map.gui.dropdown.rightclick.RightClickOption;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.world.MapDimension;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.mixin.client.AccessorRightClickOption;
import xaeroplus.settings.Settings;
import xaeroplus.util.BaritoneExecutor;
import xaeroplus.util.BaritoneHelper;
import xaeroplus.util.ChunkUtils;

@Mixin(value={GuiMap.class}, remap=false)
public abstract class MixinGuiMap
extends ScreenBase
implements IRightClickableElement {
    @Unique
    private static boolean follow = false;
    @Unique
    boolean pan;
    @Unique
    double panMouseStartX;
    @Unique
    double panMouseStartY;
    @Unique
    class_4185 coordinateGotoButton;
    @Unique
    class_342 xTextEntryField;
    @Unique
    class_342 zTextEntryField;
    @Unique
    class_4185 followButton;
    @Unique
    class_4185 switchToNetherButton;
    @Unique
    class_4185 switchToOverworldButton;
    @Unique
    class_4185 switchToEndButton;
    @Unique
    List<class_4185> guiMapButtonTempList = new ArrayList<class_4185>();
    @Unique
    class_2960 xpGuiTextures = new class_2960("xaeroplus", "gui/xpgui.png");
    @Shadow
    private double cameraX = 0.0;
    @Shadow
    private double cameraZ = 0.0;
    @Shadow
    private int[] cameraDestination = null;
    @Shadow
    private SlowingAnimation cameraDestinationAnimX = null;
    @Shadow
    private SlowingAnimation cameraDestinationAnimZ = null;
    @Shadow
    private double prevPlayerDimDiv;
    @Shadow
    private MapProcessor mapProcessor;
    @Shadow
    private class_4185 exportButton;
    @Shadow
    private class_4185 claimsButton;
    @Shadow
    private class_4185 zoomInButton;
    @Shadow
    private class_4185 zoomOutButton;
    @Shadow
    private class_4185 keybindingsButton;
    @Shadow
    private class_4185 dimensionToggleButton;
    @Shadow
    private int rightClickX;
    @Shadow
    private int rightClickY;
    @Shadow
    private int rightClickZ;
    @Shadow
    private int mouseBlockPosX;
    @Shadow
    private int mouseBlockPosZ;
    @Shadow
    private static double destScale;
    @Shadow
    private MapTileSelection mapTileSelection;

    protected MixinGuiMap(class_437 parent, class_437 escape, class_2561 titleIn) {
        super(parent, escape, titleIn);
    }

    @Shadow
    public abstract <T extends class_364 & class_4068> T addButton(T var1);

    @Shadow
    public abstract <T extends class_364 & class_6379> T method_25429(T var1);

    @ModifyExpressionValue(method={"changeZoom"}, at={@At(value="CONSTANT", args={"doubleValue=0.0625"})})
    public double customMinZoom(double original) {
        return Settings.REGISTRY.worldMapMinZoomSetting.get() / 10.0;
    }

    @Inject(method={"init"}, at={@At(value="RETURN")}, remap=true)
    public void customInitGui(CallbackInfo ci) {
        this.followButton = new GuiTexturedButton(0, this.dimensionToggleButton.method_46427() - 20, 20, 20, follow ? 133 : 149, 16, 16, 16, WorldMap.guiTextures, this::onFollowButton, () -> new CursorBox((class_2561)class_2561.method_43471((String)"xaeroplus.gui.world_map.toggle_follow_mode").method_27693(" " + class_1074.method_4662((String)(follow ? "xaeroplus.gui.off" : "xaeroplus.gui.on"), (Object[])new Object[0]))));
        this.addButton(this.followButton);
        this.coordinateGotoButton = new GuiTexturedButton(0, this.followButton.method_46427() - 20, 20, 20, 229, 16, 16, 16, WorldMap.guiTextures, this::onGotoCoordinatesButton, () -> new CursorBox((class_2561)class_2561.method_43471((String)"xaeroplus.gui.world_map.go_to_coordinates")));
        this.addButton(this.coordinateGotoButton);
        this.xTextEntryField = new class_342(class_310.method_1551().field_1772, 20, this.coordinateGotoButton.method_46427() - 10, 50, 20, class_2561.method_30163((String)"X:"));
        this.xTextEntryField.method_1862(false);
        this.xTextEntryField.method_1875(0);
        this.xTextEntryField.method_47404((class_2561)class_2561.method_43470((String)"X:").method_27692(class_124.field_1063));
        this.zTextEntryField = new class_342(class_310.method_1551().field_1772, 20, this.xTextEntryField.method_46427() + 20, 50, 20, class_2561.method_30163((String)"Z:"));
        this.zTextEntryField.method_1862(false);
        this.zTextEntryField.method_1875(0);
        this.zTextEntryField.method_47404((class_2561)class_2561.method_43470((String)"Z:").method_27692(class_124.field_1063));
        this.method_25429(this.xTextEntryField);
        this.method_25429(this.zTextEntryField);
        if (!SupportMods.pac()) {
            this.method_37066((class_364)this.claimsButton);
            this.exportButton.method_46419(this.claimsButton.method_46427());
            this.keybindingsButton.method_46419(this.claimsButton.method_46427() - 20);
            this.zoomOutButton.method_46419(this.keybindingsButton.method_46427() - 20);
            this.zoomInButton.method_46419(this.zoomOutButton.method_46427() - 20);
        }
        this.switchToEndButton = new GuiTexturedButton(this.field_22789 - 20, this.zoomInButton.method_46427() - 20, 20, 20, 31, 0, 16, 16, this.xpGuiTextures, button -> this.onSwitchDimensionButton((class_5321<class_1937>)class_1937.field_25181), () -> new CursorBox((class_2561)class_2561.method_43471((String)"xaeroplus.keybind.switch_to_end")));
        this.switchToOverworldButton = new GuiTexturedButton(this.field_22789 - 20, this.switchToEndButton.method_46427() - 20, 20, 20, 16, 0, 16, 16, this.xpGuiTextures, button -> this.onSwitchDimensionButton((class_5321<class_1937>)class_1937.field_25179), () -> new CursorBox((class_2561)class_2561.method_43471((String)"xaeroplus.keybind.switch_to_overworld")));
        this.switchToNetherButton = new GuiTexturedButton(this.field_22789 - 20, this.switchToOverworldButton.method_46427() - 20, 20, 20, 0, 0, 16, 16, this.xpGuiTextures, button -> this.onSwitchDimensionButton((class_5321<class_1937>)class_1937.field_25180), () -> new CursorBox((class_2561)class_2561.method_43471((String)"xaeroplus.keybind.switch_to_nether")));
        this.addButton(this.switchToEndButton);
        this.addButton(this.switchToOverworldButton);
        this.addButton(this.switchToNetherButton);
        this.pan = false;
    }

    protected void onExit(class_437 screen) {
        if (!Settings.REGISTRY.persistMapDimensionSwitchSetting.get()) {
            try {
                class_5321<class_1937> actualDimension = ChunkUtils.getActualDimension();
                if (Globals.getCurrentDimensionId() != actualDimension) {
                    Globals.switchToDimension(actualDimension);
                    if (!Settings.REGISTRY.radarWhileDimensionSwitchedSetting.get()) {
                        WorldMap.settings.minimapRadar = true;
                    }
                }
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.error("Failed to switch back to original dimension", (Throwable)e);
            }
        }
        super.onExit(screen);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/gui/GuiMap;init(Lnet/minecraft/client/Minecraft;II)V", ordinal=0, shift=At.Shift.AFTER)}, remap=true)
    public void toggleRadarWhileDimensionSwitched(class_332 guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci, @Local(name={"currentFutureDim"}) MapDimension currentFutureDim) {
        if (!Settings.REGISTRY.radarWhileDimensionSwitchedSetting.get()) {
            WorldMap.settings.minimapRadar = currentFutureDim.getDimId() == ChunkUtils.getActualDimension();
        }
    }

    @Redirect(method={"render"}, at=@At(value="FIELD", target="Lxaero/map/gui/GuiMap;cameraX:D", opcode=181, ordinal=1), remap=true)
    public void fixDimensionSwitchCameraCoordsX(GuiMap owner, double value, @Local(name={"playerDimDiv"}) double playerDimDiv) {
        this.cameraX *= this.prevPlayerDimDiv / playerDimDiv;
    }

    @Redirect(method={"render"}, at=@At(value="FIELD", target="Lxaero/map/gui/GuiMap;cameraZ:D", opcode=181, ordinal=1), remap=true)
    public void fixDimensionSwitchCameraCoordsZ(GuiMap owner, double value, @Local(name={"playerDimDiv"}) double playerDimDiv) {
        this.cameraZ *= this.prevPlayerDimDiv / playerDimDiv;
    }

    @Inject(method={"render"}, at={@At(value="FIELD", target="Lxaero/map/gui/GuiMap;lastStartTime:J", opcode=181, ordinal=0, shift=At.Shift.AFTER)}, remap=true)
    public void injectFollowMode(class_332 guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci) {
        if (follow && Objects.isNull(this.cameraDestination) && Objects.isNull(this.cameraDestinationAnimX) && Objects.isNull(this.cameraDestinationAnimZ)) {
            this.cameraDestination = new int[]{(int)ChunkUtils.getPlayerX(), (int)ChunkUtils.getPlayerZ()};
        }
    }

    @ModifyExpressionValue(method={"render"}, at={@At(value="FIELD", target="Lxaero/map/settings/ModSettings;debug:Z", opcode=180)}, remap=true)
    public boolean hideDebugRenderingOnF1(boolean original) {
        return original && !class_310.method_1551().field_1690.field_1842;
    }

    @Inject(method={"render"}, slice={@Slice(from=@At(value="FIELD", target="Lxaero/map/gui/GuiMap;prevLoadingLeaves:Z", opcode=181))}, at={@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;renderDynamicHighlight(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;IIIIIIFFFFFFFF)V", ordinal=0)}, remap=true)
    public void drawWorldMapFeatures(class_332 guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci, @Local(name={"flooredCameraX"}) int flooredCameraX, @Local(name={"flooredCameraZ"}) int flooredCameraZ, @Local(name={"matrixStack"}) class_4587 matrixStack, @Local(name={"renderTypeBuffers"}) class_4597.class_4598 renderTypeBuffers, @Local(name={"fboScale"}) double fboScale) {
        if (class_310.method_1551().field_1690.field_1842) {
            return;
        }
        Globals.drawManager.drawWorldMapFeatures(flooredCameraX, flooredCameraZ, matrixStack, fboScale, renderTypeBuffers);
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;renderDynamicHighlight(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;IIIIIIFFFFFFFF)V")}, remap=true)
    public boolean hideHighlightsOnF1(class_4587 matrixStack, class_4588 overlayBuffer, int flooredCameraX, int flooredCameraZ, int leftX, int rightX, int topZ, int bottomZ, float sideR, float sideG, float sideB, float sideA, float centerR, float centerG, float centerB, float centerA) {
        return !class_310.method_1551().field_1690.field_1842;
    }

    @WrapOperation(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/element/MapElementRenderHandler;render(Lxaero/map/gui/GuiMap;Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lxaero/map/graphics/renderer/multitexture/MultiTextureRenderTypeRendererProvider;DDIIDDDDDFZLxaero/map/element/HoveredMapElementHolder;Lnet/minecraft/client/Minecraft;F)Lxaero/map/element/HoveredMapElementHolder;")}, remap=true)
    public HoveredMapElementHolder<?, ?> hideMapElementsOnF1(MapElementRenderHandler handler, GuiMap mapScreen, class_332 guiGraphics, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, double cameraX, double cameraZ, int width, int height, double screenSizeBasedScale, double scale, double playerDimDiv, double mouseX, double mouseZ, float brightness, boolean cave, HoveredMapElementHolder<?, ?> oldHovered, class_310 mc, float partialTicks, Operation<HoveredMapElementHolder<?, ?>> original) {
        if (!class_310.method_1551().field_1690.field_1842) {
            return (HoveredMapElementHolder)original.call(new Object[]{handler, mapScreen, guiGraphics, renderTypeBuffers, rendererProvider, cameraX, cameraZ, width, height, screenSizeBasedScale, scale, playerDimDiv, mouseX, mouseZ, Float.valueOf(brightness), cave, oldHovered, mc, Float.valueOf(partialTicks)});
        }
        return null;
    }

    @ModifyExpressionValue(method={"render"}, at={@At(value="FIELD", target="Lxaero/map/settings/ModSettings;footsteps:Z", opcode=180)}, remap=true)
    public boolean hideFootstepsOnF1(boolean original) {
        return original && !class_310.method_1551().field_1690.field_1842;
    }

    @ModifyExpressionValue(method={"render"}, at={@At(value="FIELD", target="Lxaero/map/settings/ModSettings;renderArrow:Z", opcode=180)}, remap=true)
    public boolean hideArrowOnF1(boolean original) {
        return original && !class_310.method_1551().field_1690.field_1842;
    }

    @ModifyArg(method={"render"}, slice=@Slice(from=@At(value="FIELD", opcode=180, target="Lxaero/map/settings/ModSettings;coordinates:Z")), at=@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;drawCenteredStringWithBackground(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIFFFFLcom/mojang/blaze3d/vertex/VertexConsumer;)V", ordinal=0), index=2)
    public String renderCrossDimensionCursorCoordinates(String original) {
        if (!Settings.REGISTRY.crossDimensionCursorCoordinates.get()) {
            return original;
        }
        class_5321<class_1937> dim = Globals.getCurrentDimensionId();
        if (dim != class_1937.field_25179 && dim != class_1937.field_25180) {
            return original;
        }
        double dimDiv = dim == class_1937.field_25180 ? 0.125 : 8.0;
        int x = (int)((double)this.mouseBlockPosX / dimDiv);
        int z = (int)((double)this.mouseBlockPosZ / dimDiv);
        return original + " [" + x + ", " + z + "]";
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;drawCenteredStringWithBackground(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIFFFFLcom/mojang/blaze3d/vertex/VertexConsumer;)V")}, remap=true)
    public boolean hideRenderedStringsOnF1(class_332 guiGraphics, class_327 font, String string, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha, class_4588 backgroundVertexBuffer) {
        return !class_310.method_1551().field_1690.field_1842;
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lnet/minecraft/resources/ResourceLocation;IIIIII)V")}, remap=true)
    public boolean hideCompassOnF1(class_332 instance, class_2960 texture, int x, int y, int u, int v, int width, int height) {
        return !class_310.method_1551().field_1690.field_1842;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/gui/ScreenBase;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V")}, remap=true)
    public void hideButtonsOnF1(class_332 guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci) {
        if (class_310.method_1551().field_1690.field_1842) {
            List<class_4185> buttonList = this.getButtonList();
            if (!buttonList.isEmpty()) {
                this.guiMapButtonTempList.clear();
                this.guiMapButtonTempList.addAll(buttonList);
                this.xTextEntryField.method_1862(false);
                this.zTextEntryField.method_1862(false);
                this.clearButtons();
            }
        } else if (!this.guiMapButtonTempList.isEmpty()) {
            this.clearButtons();
            this.guiMapButtonTempList.forEach(this::addButton);
            this.guiMapButtonTempList.clear();
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;restoreDefaultShaderBlendState()V")}, remap=true)
    public void renderCoordinatesGotoTextEntryFields(class_332 guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 != null && mc.field_1755.getClass().equals(GuiMap.class) && this.xTextEntryField.method_1885() && this.zTextEntryField.method_1885()) {
            this.xTextEntryField.method_25394(guiGraphics, scaledMouseX, scaledMouseY, partialTicks);
            this.zTextEntryField.method_25394(guiGraphics, scaledMouseX, scaledMouseY, partialTicks);
        }
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;drawCenteredStringWithBackground(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;IIIFFFFLcom/mojang/blaze3d/vertex/VertexConsumer;)V")}, remap=true)
    public boolean hideMoreRenderedStringsOnF1(class_332 guiGraphics, class_327 font, class_2561 text, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha, class_4588 backgroundVertexBuffer) {
        return !class_310.method_1551().field_1690.field_1842;
    }

    @Inject(method={"onDimensionToggleButton"}, at={@At(value="RETURN")})
    public void onDimensionToggleAfter(class_4185 b, CallbackInfo ci) {
        if (!Settings.REGISTRY.radarWhileDimensionSwitchedSetting.get()) {
            WorldMap.settings.minimapRadar = this.mapProcessor.getMapWorld().getFutureDimensionId() == ChunkUtils.getActualDimension();
        }
    }

    @Inject(method={"onInputPress"}, at={@At(value="HEAD")})
    public void panMouseButtonClick(class_3675.class_307 type, int code, CallbackInfoReturnable<Boolean> cir) {
        if (type != class_3675.class_307.field_1672) {
            return;
        }
        if (code != 2) {
            return;
        }
        this.pan = true;
        class_310 mc = class_310.method_1551();
        this.panMouseStartX = Misc.getMouseX((class_310)mc, (boolean)true);
        this.panMouseStartY = Misc.getMouseY((class_310)mc, (boolean)true);
    }

    @Inject(method={"onInputRelease"}, at={@At(value="HEAD")})
    public void panMouseButtonRelease(class_3675.class_307 type, int code, CallbackInfoReturnable<Boolean> cir) {
        if (type != class_3675.class_307.field_1672) {
            return;
        }
        if (code != 2) {
            return;
        }
        this.pan = false;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void panMapOnRender(class_332 guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci) {
        if (!this.pan) {
            return;
        }
        class_310 mc = class_310.method_1551();
        double mouseX = Misc.getMouseX((class_310)mc, (boolean)true);
        double mouseY = Misc.getMouseY((class_310)mc, (boolean)true);
        double mouseDeltaX = mouseX - this.panMouseStartX;
        double mouseDeltaY = mouseY - this.panMouseStartY;
        double panDeltaX = (double)partialTicks * mouseDeltaX / destScale;
        double panDeltaZ = (double)partialTicks * mouseDeltaY / destScale;
        this.cameraX += panDeltaX;
        this.cameraZ += panDeltaZ;
    }

    @Inject(method={"render"}, at={@At(value="FIELD", target="Lxaero/map/settings/ModSettings;coordinates:Z", opcode=180, ordinal=0)}, remap=true)
    public void renderTileSelectionSize(class_332 guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci, @Local(name={"backgroundVertexBuffer"}) class_4588 backgroundVertexBuffer) {
        MapTileSelection selection = this.mapTileSelection;
        if (selection == null) {
            return;
        }
        int sideLen = Math.abs(selection.getRight() - selection.getLeft()) + 1;
        int heightLen = Math.abs(selection.getBottom() - selection.getTop()) + 1;
        if (sideLen <= 1 && heightLen <= 1) {
            return;
        }
        String string = sideLen + " x " + heightLen;
        Objects.requireNonNull(this.field_22793);
        MapRenderHelper.drawCenteredStringWithBackground((class_332)guiGraphics, (class_327)this.field_22793, (String)string, (int)scaledMouseX, (int)(scaledMouseY - 9), (int)-1, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f, (class_4588)backgroundVertexBuffer);
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    public void onInputPress(int code, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (code == 290) {
            class_310.method_1551().field_1690.field_1842 = !class_310.method_1551().field_1690.field_1842;
            cir.setReturnValue((Object)true);
            return;
        }
        if (this.xTextEntryField.method_1885() && this.zTextEntryField.method_1885() && (this.xTextEntryField.method_25370() || this.zTextEntryField.method_25370()) && code == 257) {
            this.onGotoCoordinatesButton(null);
            cir.setReturnValue((Object)true);
            return;
        }
        if (BaritoneHelper.isBaritonePresent()) {
            if (Settings.REGISTRY.worldMapBaritoneGoalHereKeybindSetting.getKeyBinding().method_1417(code, scanCode)) {
                BaritoneExecutor.goal(this.mouseBlockPosX, this.mouseBlockPosZ);
                cir.setReturnValue((Object)true);
            } else if (Settings.REGISTRY.worldMapBaritonePathHereKeybindSetting.getKeyBinding().method_1417(code, scanCode)) {
                BaritoneExecutor.path(this.mouseBlockPosX, this.mouseBlockPosZ);
                cir.setReturnValue((Object)true);
            } else if (BaritoneHelper.isBaritoneElytraPresent() && Settings.REGISTRY.worldMapBaritoneElytraHereKeybindSetting.getKeyBinding().method_1417(code, scanCode)) {
                BaritoneExecutor.elytra(this.mouseBlockPosX, this.mouseBlockPosZ);
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"getRightClickOptions"}, at={@At(value="RETURN")}, remap=false)
    public void getRightClickOptionsInject(CallbackInfoReturnable<ArrayList<RightClickOption>> cir) {
        ArrayList options = (ArrayList)cir.getReturnValue();
        int index = 3;
        options.add(index++, new RightClickOption("xaeroplus.gui.world_map.copy_coordinates", options.size(), this){

            public void onAction(class_437 screen) {
                class_310.method_1551().field_1774.method_1455(MixinGuiMap.this.rightClickX + " " + MixinGuiMap.this.rightClickY + " " + MixinGuiMap.this.rightClickZ);
            }
        });
        if (BaritoneHelper.isBaritonePresent()) {
            final int goalX = this.rightClickX;
            final int goalZ = this.rightClickZ;
            options.add(index++, new RightClickOption("xaeroplus.gui.world_map.baritone_goal_here", options.size(), this){

                public void onAction(class_437 screen) {
                    BaritoneExecutor.goal(goalX, goalZ);
                }
            }.setNameFormatArgs(new Object[]{Misc.getKeyName((class_304)Settings.REGISTRY.worldMapBaritoneGoalHereKeybindSetting.getKeyBinding())}));
            options.add(index++, new RightClickOption("xaeroplus.gui.world_map.baritone_path_here", options.size(), this){

                public void onAction(class_437 screen) {
                    BaritoneExecutor.path(goalX, goalZ);
                }
            }.setNameFormatArgs(new Object[]{Misc.getKeyName((class_304)Settings.REGISTRY.worldMapBaritonePathHereKeybindSetting.getKeyBinding())}));
            if (BaritoneHelper.isBaritoneElytraPresent()) {
                options.add(index++, new RightClickOption("xaeroplus.gui.world_map.baritone_elytra_here", options.size(), this){

                    public void onAction(class_437 screen) {
                        BaritoneExecutor.elytra(goalX, goalZ);
                    }
                }.setNameFormatArgs(new Object[]{Misc.getKeyName((class_304)Settings.REGISTRY.worldMapBaritoneElytraHereKeybindSetting.getKeyBinding())}));
            }
        }
        if (Settings.REGISTRY.disableWaypointSharing.get()) {
            options.removeIf(option -> ((AccessorRightClickOption)option).getName().equals("gui.xaero_right_click_map_share_location"));
        }
    }

    @Unique
    public void onFollowButton(class_4185 b) {
        follow = !follow;
        this.method_25423(class_310.method_1551(), this.field_22789, this.field_22790);
    }

    public void onGotoCoordinatesButton(class_4185 b) {
        if (this.xTextEntryField.method_1885() && this.zTextEntryField.method_1885()) {
            try {
                int x = Integer.parseInt(this.xTextEntryField.method_1882());
                int z = Integer.parseInt(this.zTextEntryField.method_1882());
                this.cameraX = x;
                this.cameraZ = z;
                follow = false;
                this.method_25423(class_310.method_1551(), this.field_22789, this.field_22790);
            }
            catch (NumberFormatException e) {
                this.xTextEntryField.method_1852("");
                this.zTextEntryField.method_1852("");
                WorldMap.LOGGER.warn("Go to coordinates failed", (Throwable)e);
            }
        } else {
            this.xTextEntryField.method_1862(true);
            this.zTextEntryField.method_1862(true);
            this.method_25395((class_364)this.xTextEntryField);
            this.xTextEntryField.method_1888(true);
            this.xTextEntryField.method_25365(true);
        }
    }

    @Unique
    private void onSwitchDimensionButton(class_5321<class_1937> newDimId) {
        Globals.switchToDimension(newDimId);
    }

    @Unique
    public List<class_4185> getButtonList() {
        return this.method_25396().stream().filter(child -> child instanceof class_4185).map(child -> (class_4185)child).collect(Collectors.toList());
    }

    @Unique
    public void clearButtons() {
        this.getButtonList().forEach(x$0 -> this.method_37066((class_364)x$0));
    }
}

