/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import net.lenni0451.lambdaevents.EventHandler;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2334;
import net.minecraft.class_2338;
import net.minecraft.class_2423;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2812;
import net.minecraft.class_2818;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import xaeroplus.Globals;
import xaeroplus.event.ChunkBlockUpdateEvent;
import xaeroplus.event.ChunkBlocksUpdateEvent;
import xaeroplus.event.ChunkDataEvent;
import xaeroplus.feature.render.highlights.SavableHighlightCacheInstance;
import xaeroplus.module.Module;
import xaeroplus.settings.Settings;
import xaeroplus.util.ChunkScanner;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class Portals
extends Module {
    public final SavableHighlightCacheInstance portalsCache = new SavableHighlightCacheInstance("XaeroPlusPortals");
    private int portalsColor = ColorHelper.getColor(0, 255, 0, 100);
    private static final ReferenceSet<class_2248> PORTAL_BLOCKS = ReferenceOpenHashSet.of((Object[])new class_2248[]{class_2246.field_10027, class_2246.field_10613, class_2246.field_10316, class_2246.field_10398});

    public void setDiskCache(boolean disk) {
        this.portalsCache.setDiskCache(disk, this.isEnabled());
    }

    @Override
    public void onEnable() {
        Globals.drawManager.registry().registerDirectChunkHighlightProvider(this.getClass().getName(), this::getHighlightsState, this::getPortalsColor);
        this.portalsCache.onEnable();
        this.searchAllLoadedChunks();
    }

    @Override
    public void onDisable() {
        this.portalsCache.onDisable();
        Globals.drawManager.registry().unregisterChunkHighlightProvider(this.getClass().getName());
    }

    @EventHandler
    public void onChunkData(ChunkDataEvent event) {
        this.findPortalInChunk((class_2791)event.chunk());
    }

    @EventHandler
    public void onMultiBlockUpdate(ChunkBlocksUpdateEvent event) {
        switch (event.phase()) {
            case PRE: {
                event.packet().method_30621(this::handleBlockChange);
                break;
            }
            case POST: {
                this.handleMultiBlockChangePost(event);
            }
        }
    }

    private void handleMultiBlockChangePost(ChunkBlocksUpdateEvent event) {
        class_638 level = this.mc.field_1687;
        if (level == null) {
            return;
        }
        event.packet().method_30621((blockPos, blockState) -> {
            if (!blockState.method_26215()) {
                return;
            }
            int chunkX = ChunkUtils.posToChunkPos(blockPos.method_10263());
            int chunkZ = ChunkUtils.posToChunkPos(blockPos.method_10260());
            if (!this.portalsCache.get().isHighlighted(chunkX, chunkZ, ChunkUtils.getActualDimension())) {
                return;
            }
            class_2818 chunk = level.method_2935().method_12126(chunkX, chunkZ, false);
            if (chunk instanceof class_2812 || chunk == null) {
                return;
            }
            this.findPortalInChunk((class_2791)chunk);
        });
    }

    @EventHandler
    public void onBlockUpdate(ChunkBlockUpdateEvent event) {
        switch (event.phase()) {
            case PRE: {
                this.handleBlockChange(event.packet().method_11309(), event.packet().method_11308());
                break;
            }
            case POST: {
                this.handleBlockChangePost(event);
            }
        }
    }

    private void handleBlockChangePost(ChunkBlockUpdateEvent event) {
        class_638 level = this.mc.field_1687;
        if (level == null) {
            return;
        }
        class_2338 blockPos = event.packet().method_11309();
        class_2680 blockState = event.packet().method_11308();
        if (!blockState.method_26215()) {
            return;
        }
        int chunkX = ChunkUtils.posToChunkPos(blockPos.method_10263());
        int chunkZ = ChunkUtils.posToChunkPos(blockPos.method_10260());
        if (!this.portalsCache.get().isHighlighted(chunkX, chunkZ, ChunkUtils.getActualDimension())) {
            return;
        }
        class_2818 chunk = level.method_2935().method_12126(chunkX, chunkZ, false);
        if (chunk instanceof class_2812 || chunk == null) {
            return;
        }
        this.findPortalInChunk((class_2791)chunk);
    }

    private void findPortalInChunk(class_2791 chunk) {
        boolean chunkHadPortal = this.portalsCache.get().isHighlighted(chunk.method_12004().field_9181, chunk.method_12004().field_9180, ChunkUtils.getActualDimension());
        boolean hasPortal = ChunkScanner.chunkContainsBlocks(chunk, PORTAL_BLOCKS, this.mc.field_1687.method_31607());
        if (hasPortal) {
            this.portalsCache.get().addHighlight(chunk.method_12004().field_9181, chunk.method_12004().field_9180);
        } else if (chunkHadPortal) {
            this.portalsCache.get().removeHighlight(chunk.method_12004().field_9181, chunk.method_12004().field_9180);
        }
    }

    private void searchAllLoadedChunks() {
        if (this.mc.field_1687 == null) {
            return;
        }
        int renderDist = (Integer)this.mc.field_1690.method_42503().method_41753();
        int xMin = ChunkUtils.getPlayerChunkX() - renderDist;
        int xMax = ChunkUtils.getPlayerChunkX() + renderDist;
        int zMin = ChunkUtils.getPlayerChunkZ() - renderDist;
        int zMax = ChunkUtils.getPlayerChunkZ() + renderDist;
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                class_2818 chunk = this.mc.field_1687.method_2935().method_12126(x, z, false);
                if (chunk instanceof class_2812 || chunk == null) continue;
                this.findPortalInChunk((class_2791)chunk);
            }
        }
    }

    private void handleBlockChange(class_2338 pos, class_2680 state) {
        int chunkX = ChunkUtils.posToChunkPos(pos.method_10263());
        int chunkZ = ChunkUtils.posToChunkPos(pos.method_10260());
        if (!(state.method_26204() instanceof class_2423) && !(state.method_26204() instanceof class_2334)) {
            return;
        }
        this.portalsCache.get().addHighlight(chunkX, chunkZ);
    }

    public int getPortalsColor() {
        return this.portalsColor;
    }

    public void setRgbColor(int color) {
        this.portalsColor = ColorHelper.getColorWithAlpha(color, Settings.REGISTRY.portalsAlphaSetting.getAsInt());
    }

    public void setAlpha(double a) {
        this.portalsColor = ColorHelper.getColorWithAlpha(this.portalsColor, (int)a);
    }

    public boolean isPortalChunk(int chunkPosX, int chunkPosZ, class_5321<class_1937> dimensionId) {
        return this.portalsCache.get().isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    public Long2LongMap getHighlightsState(class_5321<class_1937> dimension) {
        return this.portalsCache.get().getCacheMap(dimension);
    }
}

