/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlight;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexBuffer;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import net.minecraft.client.renderer.ShaderInstance;
import org.jetbrains.annotations.Nullable;
import xaeroplus.feature.render.DrawContext;

public abstract class AbstractHighlightVertexBuffer {
    protected boolean stale = true;
    @Nullable
    protected VertexBuffer vertexBuffer = null;
    protected boolean flipped = false;
    public long lastRefreshed = 0L;

    public boolean needsRefresh(DrawContext ctx) {
        return this.vertexBuffer == null || this.vertexBuffer.m_231230_() || this.stale || this.flipped != ctx.worldmap();
    }

    public abstract ShaderInstance shaderInstance();

    public void preRender(DrawContext ctx, Long2LongMap highlights, int color) {
        if (this.needsRefresh(ctx)) {
            this.refresh(ctx, highlights, color);
        }
    }

    public abstract void refresh(DrawContext var1, Long2LongMap var2, int var3);

    public void render() {
        if (this.vertexBuffer == null || this.vertexBuffer.m_231230_()) {
            return;
        }
        ShaderInstance shader = this.shaderInstance();
        if (shader == null) {
            return;
        }
        this.vertexBuffer.m_85921_();
        this.vertexBuffer.m_253207_(RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), shader);
    }

    public void markStale() {
        this.stale = true;
    }

    public void close() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
    }
}

