/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.level.Level;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointColor;
import xaero.hud.minimap.waypoint.set.WaypointSet;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.core.XaeroWorldMapCore;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.extensions.SyncedWaypoint;
import xaeroplus.feature.waypoint.WaypointAPI;
import xaeroplus.module.Module;
import xaeroplus.shadow.lambdaevents.EventHandler;
import xaeroplus.util.FileUtil;
import xaeroplus.util.timer.Timer;
import xaeroplus.util.timer.Timers;

public class Pearls
extends Module {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<UUID, Map<UUID, Pearl>> pearlsMap = new ConcurrentHashMap<UUID, Map<UUID, Pearl>>();
    private boolean stale = false;
    public static final String PEARL_WP_SET_ID = "xaeroplus.gui.pearl_waypoints_set";
    private final Timer updateTracksPearlsTimer = Timers.tickTimer();
    private final Timer trackedPearlRemovalTimer = Timers.tickTimer();

    @Override
    public void onEnable() {
        this.pearlsMap.clear();
        this.loadPearls();
    }

    @Override
    public void onDisable() {
        this.savePearls();
        this.deleteAllPearlWaypointSets();
        this.pearlsMap.clear();
    }

    @EventHandler
    public void updateTrackedPearls(ClientTickEvent.Post event) {
        if (!this.updateTracksPearlsTimer.tick(10L)) {
            return;
        }
        ClientLevel level = this.mc.f_91073_;
        if (level == null) {
            return;
        }
        ClientPacketListener con = this.mc.m_91403_();
        if (con == null) {
            return;
        }
        UUID selfUuid = con.m_105144_().getId();
        if (selfUuid == null) {
            return;
        }
        boolean updated = false;
        for (Entity entity : level.m_104735_()) {
            Map pearls;
            Pearl existingPearl;
            if (!(entity instanceof ThrownEnderpearl)) continue;
            ThrownEnderpearl thrownPearlEntity = (ThrownEnderpearl)entity;
            UUID pearlUUID = thrownPearlEntity.m_20148_();
            Entity pearlOwner = thrownPearlEntity.m_19749_();
            if (pearlOwner == null || !pearlOwner.m_20148_().equals(selfUuid) || thrownPearlEntity.f_19797_ < 20 || Math.abs(thrownPearlEntity.m_20184_().m_7096_()) > 0.01 || Math.abs(thrownPearlEntity.m_20184_().m_7098_()) > 1.0 || Math.abs(thrownPearlEntity.m_20184_().m_7094_()) > 0.01 || (existingPearl = (Pearl)(pearls = this.pearlsMap.computeIfAbsent(pearlOwner.m_20148_(), e -> new ConcurrentHashMap())).get(pearlUUID)) != null && !(thrownPearlEntity.m_20275_((double)existingPearl.x(), (double)existingPearl.y(), (double)existingPearl.z()) > 1.0)) continue;
            pearls.put(pearlUUID, new Pearl(pearlUUID, level.m_46472_().m_135782_().toString(), thrownPearlEntity.m_20183_().m_123341_(), thrownPearlEntity.m_20183_().m_123342_(), thrownPearlEntity.m_20183_().m_123343_()));
            updated = true;
        }
        if (updated) {
            this.savePearlsAsync();
        }
    }

    @EventHandler
    public void trackedPearlRemoval(ClientTickEvent.Post event) {
        if (!this.trackedPearlRemovalTimer.tick(11L)) {
            return;
        }
        ClientLevel level = this.mc.f_91073_;
        if (level == null) {
            return;
        }
        ClientPacketListener con = this.mc.m_91403_();
        if (con == null) {
            return;
        }
        UUID selfUuid = con.m_105144_().getId();
        if (selfUuid == null) {
            return;
        }
        LocalPlayer player = this.mc.f_91074_;
        if (player == null) {
            return;
        }
        int effectiveRenderDistance = this.mc.f_91066_.m_193772_();
        int trackedEntityRadius = Math.min(3, effectiveRenderDistance + 1) * 16;
        int trackedEntityRadiusSq = trackedEntityRadius * trackedEntityRadius;
        Map savedPearls = this.pearlsMap.getOrDefault(selfUuid, Collections.emptyMap());
        boolean updated = false;
        Iterator it = savedPearls.values().iterator();
        while (it.hasNext()) {
            Pearl savedPearl = (Pearl)it.next();
            if (savedPearl.dimension() != level.m_46472_() || !(player.m_20275_((double)savedPearl.x(), player.m_20186_(), (double)savedPearl.z()) <= (double)trackedEntityRadiusSq) || level.f_171631_.m_157645_().m_142694_(savedPearl.uuid) != null) continue;
            it.remove();
            updated = true;
        }
        if (updated) {
            this.savePearlsAsync();
        }
    }

    @EventHandler
    public void onXaeroWorldChange(XaeroWorldChangeEvent event) {
        switch (event.worldChangeType()) {
            case EXIT_WORLD: {
                this.savePearls();
                this.pearlsMap.clear();
                break;
            }
            case ENTER_WORLD: {
                this.pearlsMap.clear();
                this.loadPearls();
            }
        }
    }

    @EventHandler
    public void syncPearlsToWaypoints(ClientTickEvent.Post event) {
        if (!this.stale) {
            return;
        }
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession == null) {
            return;
        }
        MinimapWorld currentWorld = minimapSession.getWorldManager().getCurrentWorld();
        if (currentWorld == null) {
            return;
        }
        ClientPacketListener con = this.mc.m_91403_();
        if (con == null) {
            return;
        }
        UUID selfUuid = con.m_105144_().getId();
        if (selfUuid == null) {
            return;
        }
        this.clearAllPearlWaypoints();
        Map<UUID, Pearl> pearls = this.pearlsMap.get(selfUuid);
        if (pearls == null) {
            return;
        }
        for (Pearl pearl : pearls.values()) {
            ResourceKey<Level> pearlDim = pearl.dimension();
            MinimapWorld minimapWorld = WaypointAPI.getMinimapWorld(pearlDim);
            if (minimapWorld == null) {
                return;
            }
            WaypointSet wpSet = WaypointAPI.getOrCreateWaypointSetInWorld(minimapWorld, PEARL_WP_SET_ID);
            SyncedWaypoint wp = SyncedWaypoint.create(pearl.x(), pearl.y(), pearl.z(), "Pearl", "P", this.getPearlWaypointColor(pearl));
            wpSet.add((Waypoint)wp);
        }
        this.stale = false;
    }

    private WaypointColor getPearlWaypointColor(Pearl pearl) {
        int index = Math.abs(pearl.uuid().hashCode() % WaypointColor.values().length);
        return WaypointColor.fromIndex((int)index);
    }

    private void clearAllPearlWaypoints() {
        WaypointAPI.forEachWaypointSetInAllMinimapWorlds(wpSet -> {
            if (PEARL_WP_SET_ID.equals(wpSet.getName())) {
                wpSet.clear();
            }
        });
    }

    private void deleteAllPearlWaypointSets() {
        WaypointAPI.forEachMinimapWorld(world -> {
            String currentWpSet = world.getCurrentWaypointSetId();
            if (currentWpSet != null && currentWpSet.equals(PEARL_WP_SET_ID)) {
                world.setCurrentWaypointSetId("gui.xaero_default");
            }
            world.removeWaypointSet(PEARL_WP_SET_ID);
        });
    }

    private File getSaveFile() {
        WorldMapSession currentSession = XaeroWorldMapCore.currentSession;
        if (currentSession == null) {
            return null;
        }
        MapProcessor mapProcessor = currentSession.getMapProcessor();
        if (mapProcessor == null) {
            return null;
        }
        String worldId = mapProcessor.getCurrentWorldId();
        if (worldId == null) {
            return null;
        }
        if (WorldMap.saveFolder == null) {
            return null;
        }
        return WorldMap.saveFolder.toPath().resolve(worldId).resolve("xaeroplus-pearls.json").toFile();
    }

    public synchronized void loadPearls() {
        try {
            File saveFile = this.getSaveFile();
            if (saveFile == null) {
                return;
            }
            if (!saveFile.exists()) {
                return;
            }
            try (BufferedReader reader = Files.newBufferedReader(saveFile.toPath());){
                Map map = (Map)this.gson.fromJson((Reader)reader, new TypeToken<Map<UUID, Map<UUID, Pearl>>>(){}.getType());
                if (map != null) {
                    this.pearlsMap.clear();
                    this.pearlsMap.putAll(map);
                }
                this.stale = true;
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("[Pearls] Failed to read pearls file", (Throwable)e);
        }
    }

    public void savePearlsAsync() {
        this.stale = true;
        ForkJoinPool.commonPool().execute(this::savePearls);
    }

    public synchronized void savePearls() {
        try {
            File saveFile = this.getSaveFile();
            if (saveFile == null) {
                return;
            }
            FileUtil.safeSave(saveFile, writer -> this.gson.toJson(this.pearlsMap, new TypeToken<Map<UUID, Map<UUID, Pearl>>>(){}.getType(), (Appendable)writer));
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("[Pearls] Failed to write pearls file", (Throwable)e);
        }
    }

    public Map<UUID, Map<UUID, Pearl>> getLoadedPearls() {
        return this.pearlsMap;
    }

    public record Pearl(UUID uuid, String dimensionKey, int x, int y, int z) {
        public ResourceLocation dimensionLocation() {
            return ResourceLocation.m_135820_((String)this.dimensionKey);
        }

        public ResourceKey<Level> dimension() {
            ResourceLocation dimensionLocation = this.dimensionLocation();
            if (dimensionLocation == null) {
                return null;
            }
            ResourceLocation ow = Level.f_46428_.m_135782_();
            ResourceLocation nether = Level.f_46429_.m_135782_();
            ResourceLocation end = Level.f_46430_.m_135782_();
            if (dimensionLocation.equals((Object)ow)) {
                return Level.f_46428_;
            }
            if (dimensionLocation.equals((Object)nether)) {
                return Level.f_46429_;
            }
            if (dimensionLocation.equals((Object)end)) {
                return Level.f_46430_;
            }
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && level.m_46472_().m_135782_().equals((Object)dimensionLocation)) {
                return level.m_46472_();
            }
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimensionLocation);
        }
    }
}

