/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.buffered;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalInt;
import java.util.function.IntSupplier;
import net.minecraft.class_10789;
import net.minecraft.class_276;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_6367;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import xaeroplus.feature.render.buffered.Model;
import xaeroplus.settings.Settings;

public class BufferedComponent {
    private static final class_310 mc = class_310.method_1551();
    private Model model = null;
    private final class_276 renderTarget = new class_6367("XaeroPlus Minimap Buffered", 100, 100, true);
    private class_276 mainRenderTargetBackup = null;
    private long nextRenderCapture = System.currentTimeMillis();
    private final IntSupplier fpsLimitSupplier;
    private final Matrix4f modelViewMatrixBackup = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
    private final RenderPipeline bufferedPipeline = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[0]).withLocation(class_2960.method_60655((String)"xaeroplus", (String)"buffered")).withVertexShader("core/position_tex").withFragmentShader("core/position_tex").withBlend(new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA)).withUniform("ModelViewMat", class_10789.field_56747).withUniform("ProjMat", class_10789.field_56747).withUniform("ColorModulator", class_10789.field_56746).withSampler("Sampler0").withVertexFormat(class_290.field_1585, VertexFormat.class_5596.field_27382).build();

    public BufferedComponent(IntSupplier fpsLimitSupplier) {
        this.fpsLimitSupplier = fpsLimitSupplier;
    }

    private void refreshModel(int screenWidth, int screenHeight) {
        if (this.model != null) {
            this.model.close();
        }
        Vector3f[] posMatrix = new Vector3f[]{new Vector3f(0.0f, (float)screenHeight, 1.0f), new Vector3f((float)screenWidth, (float)screenHeight, 1.0f), new Vector3f((float)screenWidth, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
        Vector2f[] texUvMatrix = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(1.0f, 1.0f), new Vector2f(0.0f, 1.0f)};
        this.model = new Model(posMatrix, texUvMatrix);
    }

    public boolean render() {
        int windowWidth = mc.method_22683().method_4489();
        int windowHeight = mc.method_22683().method_4506();
        boolean forceRender = false;
        if (this.renderTarget.field_1482 != BufferedComponent.mc.field_1689.field_1482 || this.renderTarget.field_1481 != BufferedComponent.mc.field_1689.field_1481) {
            this.renderTarget.method_1234(BufferedComponent.mc.field_1689.field_1482, BufferedComponent.mc.field_1689.field_1481);
            this.refreshModel(windowWidth, windowHeight);
            forceRender = true;
        }
        if (this.model == null) {
            this.refreshModel(windowWidth, windowHeight);
            forceRender = true;
        }
        if (forceRender || System.currentTimeMillis() > this.nextRenderCapture) {
            this.mainRenderTargetBackup = BufferedComponent.mc.field_1689;
            BufferedComponent.mc.field_1689 = this.renderTarget;
            BufferedComponent.clearRenderTarget(this.renderTarget, 0, 1.0f);
            return false;
        }
        this.renderBufferedTexture();
        return true;
    }

    public static void clearRenderTarget(class_276 renderTarget, int color, float depth) {
        RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(renderTarget.method_30277(), color, renderTarget.method_30278(), (double)depth);
    }

    public void postRender() {
        if (this.mainRenderTargetBackup != null) {
            BufferedComponent.mc.field_1689 = this.mainRenderTargetBackup;
            this.mainRenderTargetBackup = null;
        }
        this.nextRenderCapture = System.currentTimeMillis() + (long)(1000 / this.fpsLimitSupplier.getAsInt());
        this.renderBufferedTexture();
    }

    private void renderBufferedTexture() {
        this.modelViewMatrixBackup.set((Matrix4fc)RenderSystem.getModelViewMatrix());
        RenderSystem.class_5590 autoIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        GpuBuffer indexBuffer = autoIndexBuffer.method_68274(this.model.getIndexCount());
        try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(mc.method_1522().method_30277(), OptionalInt.empty());){
            pass.setPipeline(this.bufferedPipeline);
            pass.bindSampler("Sampler0", this.renderTarget.method_30277());
            RenderSystem.setShaderTexture((int)0, (GpuTexture)this.renderTarget.method_30277());
            Matrix4f modelViewMatrix = RenderSystem.getModelViewMatrix();
            modelViewMatrix.translate(0.0f, 0.0f, 399.0f + (float)Settings.REGISTRY.minimapRenderZOffsetSetting.get());
            float guiScale = (float)Math.max(1.0, mc.method_22683().method_4495());
            modelViewMatrix.scale(1.0f / guiScale);
            this.model.draw(pass, indexBuffer, autoIndexBuffer.method_31924());
        }
        RenderSystem.getModelViewMatrix().set((Matrix4fc)this.modelViewMatrixBackup);
    }
}

