/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointColor;
import xaero.hud.minimap.waypoint.set.WaypointSet;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.core.XaeroWorldMapCore;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.event.RespawnPointSetEvent;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.extensions.SyncedWaypoint;
import xaeroplus.feature.waypoint.WaypointAPI;
import xaeroplus.module.Module;
import xaeroplus.settings.Settings;
import xaeroplus.shadow.lambdaevents.EventHandler;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.FileUtil;

public class SpawnPoint
extends Module {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<UUID, SpawnPosition> respawnPoints = new ConcurrentHashMap<UUID, SpawnPosition>();
    private static final WeakReference nullRef = new WeakReference<Object>(null);
    private WeakReference<Waypoint> wpRef = nullRef;
    private WeakReference<WaypointSet> wpSetRef = nullRef;
    private SpawnPosition wpSpawnPoint = null;

    @Override
    public void onEnable() {
        if (this.mc.level == null) {
            return;
        }
        this.respawnPoints.clear();
        this.loadRespawnPoints();
    }

    @Override
    public void onDisable() {
        if (this.mc.level == null) {
            return;
        }
        this.saveRespawnPoints();
        this.respawnPoints.clear();
        this.clearWpAndState();
    }

    @EventHandler
    public void onRespawnPointSet(RespawnPointSetEvent event) {
        ClientPacketListener con = this.mc.getConnection();
        if (con == null) {
            return;
        }
        UUID activeUUID = con.getLocalGameProfile().id();
        this.respawnPoints.put(activeUUID, new SpawnPosition(ChunkUtils.getActualDimension().location().toString(), event.pos().getX(), event.pos().getY(), event.pos().getZ()));
        this.saveRespawnPointsAsync();
    }

    @EventHandler
    public void onXaeroWorldChange(XaeroWorldChangeEvent event) {
        switch (event.worldChangeType()) {
            case EXIT_WORLD: {
                this.saveRespawnPoints();
                this.clearWpAndState();
                this.respawnPoints.clear();
                break;
            }
            case ENTER_WORLD: {
                this.clearWpAndState();
                this.respawnPoints.clear();
                this.loadRespawnPoints();
            }
        }
    }

    @EventHandler
    public void onClientTick(ClientTickEvent.Post event) {
        MinimapWorld minimapWorld;
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession == null) {
            return;
        }
        MinimapWorld currentWorld = minimapSession.getWorldManager().getCurrentWorld();
        if (currentWorld == null) {
            return;
        }
        ClientPacketListener con = this.mc.getConnection();
        if (con == null) {
            return;
        }
        UUID uuid = con.getLocalGameProfile().id();
        SpawnPosition spawnPoint = this.respawnPoints.get(uuid);
        if (spawnPoint == null) {
            this.clearWpAndState();
            return;
        }
        ResourceKey spawnPointDimension = spawnPoint.dimension();
        if (spawnPointDimension == null) {
            this.clearWpAndState();
            return;
        }
        if (Settings.REGISTRY.owAutoWaypointDimension.get() && spawnPointDimension == Level.NETHER) {
            spawnPointDimension = Level.OVERWORLD;
            spawnPoint = new SpawnPosition(Level.OVERWORLD.location().toString(), spawnPoint.x() * 8, spawnPoint.y(), spawnPoint.z() * 8);
        }
        if ((minimapWorld = WaypointAPI.getMinimapWorld(spawnPointDimension)) == null) {
            this.clearWpAndState();
            return;
        }
        WaypointSet waypointSet = WaypointAPI.getOrCreateWaypointSetInWorld(minimapWorld, "gui.xaero_default");
        if (!Objects.equals(this.wpSpawnPoint, spawnPoint) || this.wpSetRef.get() == null || this.wpRef.get() == null) {
            this.clearWpAndState();
            this.wpSetRef = new WeakReference<WaypointSet>(waypointSet);
            SyncedWaypoint wp = SyncedWaypoint.create(spawnPoint.x(), spawnPoint.y(), spawnPoint.z(), "Spawn Point", "SP", WaypointColor.AQUA);
            waypointSet.add((Waypoint)wp);
            this.wpRef = new WeakReference<SyncedWaypoint>(wp);
            this.wpSpawnPoint = spawnPoint;
            XaeroPlus.LOGGER.info("[SpawnPoint] Spawn Point Waypoint Updated: {} {} {}", new Object[]{spawnPoint.x(), spawnPoint.y(), spawnPoint.z()});
        }
    }

    private synchronized void clearWpAndState() {
        if (this.wpRef.get() != null && this.wpSetRef.get() != null) {
            ((WaypointSet)this.wpSetRef.get()).remove((Waypoint)this.wpRef.get());
        }
        this.wpRef = nullRef;
        this.wpSetRef = nullRef;
        this.wpSpawnPoint = null;
    }

    private File getSaveFile() {
        WorldMapSession currentSession = XaeroWorldMapCore.currentSession;
        if (currentSession == null) {
            return null;
        }
        MapProcessor mapProcessor = currentSession.getMapProcessor();
        if (mapProcessor == null) {
            return null;
        }
        String worldId = mapProcessor.getCurrentWorldId();
        if (worldId == null) {
            return null;
        }
        if (WorldMap.saveFolder == null) {
            return null;
        }
        return WorldMap.saveFolder.toPath().resolve(worldId).resolve("xaeroplus-respawn-points.json").toFile();
    }

    public synchronized void loadRespawnPoints() {
        try {
            File saveFile = this.getSaveFile();
            if (saveFile == null) {
                return;
            }
            if (!saveFile.exists()) {
                return;
            }
            try (BufferedReader reader = Files.newBufferedReader(saveFile.toPath());){
                Map map = (Map)this.gson.fromJson((Reader)reader, new TypeToken<Map<UUID, SpawnPosition>>(this){}.getType());
                if (map != null) {
                    this.respawnPoints.clear();
                    this.respawnPoints.putAll(map);
                }
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("[SpawnPoint] Failed to read respawn points file", (Throwable)e);
        }
    }

    public void saveRespawnPointsAsync() {
        ForkJoinPool.commonPool().execute(this::saveRespawnPoints);
    }

    public synchronized void saveRespawnPoints() {
        try {
            File saveFile = this.getSaveFile();
            if (saveFile == null) {
                return;
            }
            FileUtil.safeSave(saveFile, writer -> this.gson.toJson(this.respawnPoints, new TypeToken<Map<UUID, SpawnPosition>>(this){}.getType(), (Appendable)writer));
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("[SpawnPoint] Failed to write respawn points file", (Throwable)e);
        }
    }

    public Map<UUID, SpawnPosition> getLoadedSpawnPositions() {
        return this.respawnPoints;
    }

    public record SpawnPosition(String dimensionKey, int x, int y, int z) {
        public ResourceLocation dimensionLocation() {
            return ResourceLocation.tryParse((String)this.dimensionKey);
        }

        public ResourceKey<Level> dimension() {
            ResourceLocation dimensionLocation = this.dimensionLocation();
            if (dimensionLocation == null) {
                return null;
            }
            ResourceLocation ow = Level.OVERWORLD.location();
            ResourceLocation nether = Level.NETHER.location();
            ResourceLocation end = Level.END.location();
            if (dimensionLocation.equals((Object)ow)) {
                return Level.OVERWORLD;
            }
            if (dimensionLocation.equals((Object)nether)) {
                return Level.NETHER;
            }
            if (dimensionLocation.equals((Object)end)) {
                return Level.END;
            }
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null && level.dimension().location().equals((Object)dimensionLocation)) {
                return level.dimension();
            }
            return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimensionLocation);
        }
    }
}

