/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.drawing.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.db.DatabaseMigration;

public class V0Migration
implements DatabaseMigration {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean shouldMigrate(String databaseName, Connection connection) {
        try {
            if (!this.tableExists("metadata", connection)) {
                return true;
            }
            try (Statement statement = connection.createStatement();){
                ResultSet resultSet = statement.executeQuery("SELECT version FROM metadata where version = 0");
                if (resultSet.next()) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed checking if {} database should migrate", (Object)databaseName, (Object)e);
        }
        return false;
    }

    @Override
    public void doMigration(String databaseName, Connection connection) {
        this.createMetadataTable(databaseName, connection);
        this.createLinesTable(databaseName, connection, (ResourceKey<Level>)Level.OVERWORLD);
        this.createLinesTable(databaseName, connection, (ResourceKey<Level>)Level.NETHER);
        this.createLinesTable(databaseName, connection, (ResourceKey<Level>)Level.END);
        this.createHighlightsTable(databaseName, connection, (ResourceKey<Level>)Level.OVERWORLD);
        this.createHighlightsTable(databaseName, connection, (ResourceKey<Level>)Level.NETHER);
        this.createHighlightsTable(databaseName, connection, (ResourceKey<Level>)Level.END);
        this.createTextsTable(databaseName, connection, (ResourceKey<Level>)Level.OVERWORLD);
        this.createTextsTable(databaseName, connection, (ResourceKey<Level>)Level.NETHER);
        this.createTextsTable(databaseName, connection, (ResourceKey<Level>)Level.END);
    }

    private void createHighlightsTable(String databaseName, Connection connection, ResourceKey<Level> dimension) {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS \"" + this.getTableName(dimension, "highlights") + "\" (x INTEGER, z INTEGER, color INTEGER, PRIMARY KEY (x, z))");
        }
        catch (SQLException e) {
            XaeroPlus.LOGGER.error("Error creating highlights table for db: {}", (Object)databaseName, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private void createLinesTable(String databaseName, Connection connection, ResourceKey<Level> dimension) {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS \"" + this.getTableName(dimension, "lines") + "\" (x1 INTEGER, z1 INTEGER, x2 INTEGER, z2 INTEGER, color INTEGER, PRIMARY KEY (x1, z1, x2, z2))");
        }
        catch (SQLException e) {
            XaeroPlus.LOGGER.error("Error creating lines table for db: {}", (Object)databaseName, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private void createTextsTable(String databaseName, Connection connection, ResourceKey<Level> dimension) {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS \"" + this.getTableName(dimension, "texts") + "\" (value TEXT, x INTEGER, z INTEGER, color INTEGER, scale REAL, PRIMARY KEY (x, z))");
        }
        catch (SQLException e) {
            XaeroPlus.LOGGER.error("Error creating texts table for db: {}", (Object)databaseName, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private String getTableName(ResourceKey<Level> dimension, String type) {
        return dimension.location().toString() + "-" + type;
    }

    private void createMetadataTable(String databaseName, Connection connection) {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS metadata (version INTEGER PRIMARY KEY, time DATETIME NOT NULL default CURRENT_TIMESTAMP)");
            statement.executeUpdate("INSERT OR REPLACE INTO metadata (version) VALUES (0)");
        }
        catch (SQLException e) {
            XaeroPlus.LOGGER.error("Error creating metadata table for db: {}", (Object)databaseName, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private boolean tableExists(String tableName, Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery("SELECT name FROM sqlite_master WHERE type='table' and name='" + tableName + "'");
            boolean bl = resultSet.next();
            return bl;
        }
    }
}

