/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlight;

import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CompiledShaderProgram;
import xaeroplus.feature.render.DrawContext;
import xaeroplus.feature.render.highlight.AbstractHighlightVertexBuffer;
import xaeroplus.feature.render.shaders.XaeroPlusShaders;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class HighlightVertexBuffer
extends AbstractHighlightVertexBuffer {
    @Override
    public void preRender(DrawContext ctx, Long2LongMap highlights, int color) {
        super.preRender(ctx, highlights, color);
        XaeroPlusShaders.setMapViewMatrix(ctx.matrixStack().last().pose());
        float a = ColorHelper.getA(color);
        float r = ColorHelper.getR(color);
        float g = ColorHelper.getG(color);
        float b = ColorHelper.getB(color);
        XaeroPlusShaders.setHighlightColor(r, g, b, a);
    }

    @Override
    public void refresh(DrawContext ctx, Long2LongMap highlights, int color) {
        this.stale = false;
        this.lastRefreshed = System.currentTimeMillis();
        this.flipped = ctx.worldmap();
        if (highlights.isEmpty() || ColorHelper.getA(color) == 0.0f) {
            this.close();
            return;
        }
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        for (Long highlight : highlights.keySet()) {
            int chunkPosX = ChunkUtils.longToChunkX(highlight);
            int chunkPosZ = ChunkUtils.longToChunkZ(highlight);
            float x1 = chunkPosX;
            float x2 = chunkPosX + 1;
            float y1 = this.flipped ? (float)(chunkPosZ + 1) : (float)chunkPosZ;
            float y2 = this.flipped ? (float)chunkPosZ : (float)(chunkPosZ + 1);
            bufferBuilder.addVertex(x1, y2, 0.0f);
            bufferBuilder.addVertex(x2, y2, 0.0f);
            bufferBuilder.addVertex(x2, y1, 0.0f);
            bufferBuilder.addVertex(x1, y1, 0.0f);
        }
        if (this.vertexBuffer == null || this.vertexBuffer.isInvalid()) {
            this.close();
            this.vertexBuffer = new VertexBuffer(BufferUsage.STATIC_WRITE);
        }
        MeshData meshData = bufferBuilder.buildOrThrow();
        this.vertexBuffer.bind();
        this.vertexBuffer.upload(meshData);
    }

    @Override
    public CompiledShaderProgram shaderInstance() {
        return Minecraft.getInstance().getShaderManager().getProgram(XaeroPlusShaders.HIGHLIGHT_SHADER_PROGRAM);
    }
}

