/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.shadow.caffeine.cache;

import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import xaeroplus.shadow.caffeine.cache.DisabledScheduler;
import xaeroplus.shadow.caffeine.cache.ExecutorServiceScheduler;
import xaeroplus.shadow.caffeine.cache.GuardedScheduler;
import xaeroplus.shadow.caffeine.cache.SystemScheduler;

@NullMarked
@FunctionalInterface
public interface Scheduler {
    public Future<? extends @Nullable Object> schedule(Executor var1, Runnable var2, long var3, TimeUnit var5);

    public static Scheduler disabledScheduler() {
        return DisabledScheduler.INSTANCE;
    }

    public static Scheduler systemScheduler() {
        return SystemScheduler.INSTANCE;
    }

    public static Scheduler forScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        return new ExecutorServiceScheduler(scheduledExecutorService);
    }

    public static Scheduler guardedScheduler(Scheduler scheduler) {
        return scheduler instanceof GuardedScheduler ? scheduler : new GuardedScheduler(scheduler);
    }
}

