/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.beacon;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import xaero.common.HudMod;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.Minimap;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointPurpose;
import xaero.hud.minimap.waypoint.WaypointVisibilityType;
import xaero.hud.minimap.waypoint.render.world.WaypointWorldRenderer;
import xaero.hud.minimap.world.MinimapWorld;
import xaeroplus.XaeroPlus;
import xaeroplus.settings.Settings;

public class WaypointBeaconRenderer {
    public static final WaypointBeaconRenderer INSTANCE = new WaypointBeaconRenderer();
    private final List<Waypoint> waypointList = new ArrayList<Waypoint>();
    private long lastWaypointRenderListUpdate = -1L;
    private int errorCount = 0;

    public void renderHook(PoseStack matrix, float tickDelta) {
        block7: {
            if (!Settings.REGISTRY.waypointBeacons.get()) {
                return;
            }
            HudMod hudMod = HudMod.INSTANCE;
            if (hudMod == null) {
                return;
            }
            Minimap minimap = hudMod.getMinimap();
            if (minimap == null) {
                return;
            }
            WaypointWorldRenderer waypointsIngameRenderer = minimap.getWaypointWorldRenderer();
            if (waypointsIngameRenderer == null) {
                return;
            }
            MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
            if (minimapSession == null) {
                return;
            }
            try {
                INSTANCE.renderWaypointBeacons(tickDelta, matrix);
            }
            catch (Exception e) {
                if (this.errorCount++ >= 2) break block7;
                XaeroPlus.LOGGER.error("Error rendering waypoints", (Throwable)e);
            }
        }
    }

    public void updateWaypointRenderList(MinimapSession session, ModSettings settings) {
        this.waypointList.clear();
        session.getWaypointSession().getCollector().collect(this.waypointList);
        this.waypointList.removeIf(w -> {
            if (w.isDisabled() || w.getVisibility() == WaypointVisibilityType.WORLD_MAP_LOCAL || w.getVisibility() == WaypointVisibilityType.WORLD_MAP_GLOBAL) {
                return true;
            }
            return !settings.getDeathpoints() && w.getPurpose().isDeath();
        });
        this.waypointList.sort(Waypoint::compareTo);
    }

    public void renderWaypointBeacons(float tickDelta, PoseStack matrixStack) {
        MinimapSession session = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        if (session == null) {
            return;
        }
        ModSettings settings = HudMod.INSTANCE.getSettings();
        if (settings == null) {
            return;
        }
        if (!settings.getShowIngameWaypoints()) {
            return;
        }
        MinimapWorld currentWorld = session.getWorldManager().getCurrentWorld();
        if (currentWorld == null) {
            return;
        }
        if (System.currentTimeMillis() - this.lastWaypointRenderListUpdate > 50L) {
            this.updateWaypointRenderList(session, settings);
            this.lastWaypointRenderListUpdate = System.currentTimeMillis();
        }
        double dimDiv = session.getDimensionHelper().getDimensionDivision(currentWorld);
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.cameraEntity == null) {
            return;
        }
        Vec3 cameraPos = mc.cameraEntity.position();
        double distanceScale = settings.dimensionScaledMaxWaypointDistance ? mc.level.dimensionType().coordinateScale() : 1.0;
        double waypointsDistance = settings.getMaxWaypointsDistance();
        double waypointsDistanceMin = settings.waypointsDistanceMin;
        for (int i = 0; i < this.waypointList.size(); ++i) {
            boolean shouldRender;
            WaypointPurpose purpose;
            Waypoint w = this.waypointList.get(i);
            double offX = (double)w.getX(dimDiv) - cameraPos.x + 0.5;
            double offZ = (double)w.getZ(dimDiv) - cameraPos.z + 0.5;
            double unscaledDistance2D = Math.sqrt(offX * offX + offZ * offZ);
            double distance2D = unscaledDistance2D * distanceScale;
            if (Settings.REGISTRY.limitDeathpointsRenderDistance.get() && (purpose = w.getPurpose()) == WaypointPurpose.DEATH && Settings.REGISTRY.limitDeathpointsRenderDistance.get() && waypointsDistance != 0.0 && distance2D > waypointsDistance) continue;
            boolean bl = shouldRender = w.isDestination() || (w.getPurpose().isDeath() || w.isGlobal() || w.isTemporary() && settings.temporaryWaypointsGlobal || waypointsDistance == 0.0 || !(distance2D > waypointsDistance)) && (waypointsDistanceMin == 0.0 || !(unscaledDistance2D < waypointsDistanceMin));
            if (!shouldRender) continue;
            this.renderWaypointBeacon(w, dimDiv, tickDelta, matrixStack);
        }
    }

    public void renderWaypointBeacon(Waypoint waypoint, double dimDiv, float tickDelta, PoseStack matrixStack) {
        Vec3 waypointVec;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.cameraEntity == null) {
            return;
        }
        Vec3 playerVec = mc.cameraEntity.position();
        double xzDistance = playerVec.distanceTo(waypointVec = new Vec3((double)waypoint.getX(dimDiv), playerVec.y, (double)waypoint.getZ(dimDiv)));
        if (xzDistance < (double)Settings.REGISTRY.waypointBeaconDistanceMin.getAsInt()) {
            return;
        }
        int farScale = Settings.REGISTRY.waypointBeaconScaleMin.getAsInt();
        double maxRenderDistance = Math.min((Integer)mc.options.renderDistance().get() << 4, farScale == 0 ? Integer.MAX_VALUE : farScale << 4);
        if (xzDistance > maxRenderDistance) {
            Vec3 delta = waypointVec.subtract(playerVec).normalize();
            waypointVec = playerVec.add(new Vec3(delta.x * maxRenderDistance, delta.y * maxRenderDistance, delta.z * maxRenderDistance));
        }
        EntityRenderDispatcher entityRenderDispatcher = mc.getEntityRenderDispatcher();
        Camera camera = entityRenderDispatcher.camera;
        Frustum frustum = mc.levelRenderer.cullingFrustum;
        if (camera == null || frustum == null) {
            return;
        }
        double viewX = camera.getPosition().x();
        double viewZ = camera.getPosition().z();
        double x = waypointVec.x - viewX;
        double z = waypointVec.z - viewZ;
        double y = -100.0;
        if (!frustum.isVisible(new AABB(waypointVec.x - 1.0, -100.0, waypointVec.z - 1.0, waypointVec.x + 1.0, 500.0, waypointVec.z + 1.0))) {
            return;
        }
        int color = waypoint.getWaypointColor().getHex();
        MultiBufferSource.BufferSource entityVertexConsumers = mc.renderBuffers().bufferSource();
        long time = mc.level.getGameTime();
        matrixStack.pushPose();
        matrixStack.translate(x, -100.0, z);
        BeaconRenderer.renderBeaconBeam((PoseStack)matrixStack, (MultiBufferSource)entityVertexConsumers, (ResourceLocation)BeaconRenderer.BEAM_LOCATION, (float)tickDelta, (float)1.0f, (long)time, (int)0, (int)355, (int)color, (float)0.2f, (float)0.25f);
        matrixStack.popPose();
    }
}

