/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.module.Module;
import xaeroplus.shadow.lambdaevents.EventHandler;

public class TickTaskExecutor
extends Module
implements Executor {
    public static TickTaskExecutor INSTANCE;
    private final Queue<Runnable> tasks = new ConcurrentLinkedQueue<Runnable>();

    public TickTaskExecutor() {
        INSTANCE = this;
        this.enable();
    }

    @EventHandler
    public void onRenderTick(ClientTickEvent.RenderPre event) {
        while (!this.tasks.isEmpty()) {
            try {
                this.tasks.poll().run();
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.error("Caught exception in tick task", (Throwable)e);
            }
        }
    }

    public <V> CompletableFuture<V> submit(Supplier<V> task) {
        Supplier wrapped = this.wrap(task);
        if (this.mc.m_18695_()) {
            return CompletableFuture.completedFuture(wrapped.get());
        }
        CompletableFuture future = new CompletableFuture();
        this.tasks.add(() -> {
            try {
                Object result = wrapped.get();
                future.complete(result);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<Void> submit(Runnable task) {
        Runnable wrapped = this.wrap(task);
        if (this.mc.m_18695_()) {
            wrapped.run();
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.tasks.add(() -> {
            wrapped.run();
            future.complete(null);
        });
        return future;
    }

    @Override
    public void execute(@NotNull Runnable command) {
        this.submit(command);
    }

    private <T> Supplier<T> wrap(Supplier<T> task) {
        return () -> {
            try {
                return task.get();
            }
            catch (Throwable e) {
                XaeroPlus.LOGGER.error("Caught exception in tick task", e);
                return null;
            }
        };
    }

    private Runnable wrap(Runnable task) {
        return () -> {
            try {
                task.run();
            }
            catch (Throwable e) {
                XaeroPlus.LOGGER.error("Caught exception in tick task", e);
            }
        };
    }
}

