/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.shadow.lambdaevents.utils;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import xaeroplus.shadow.lambdaevents.EventHandler;

public class EventUtils {
    @Nonnull
    public static List<MethodHandler> getMethods(Class<?> owner, Predicate<Method> accept, boolean registerSuperHandler) {
        ArrayList<MethodHandler> handler = new ArrayList<MethodHandler>();
        LinkedHashSet classes = new LinkedHashSet();
        if (registerSuperHandler) {
            EventUtils.getSuperClasses(classes, owner);
        } else {
            classes.add(owner);
        }
        HashSet<MethodID> methodIDs = new HashSet<MethodID>();
        for (Class clazz : classes) {
            for (Method method : clazz.getDeclaredMethods()) {
                EventHandler annotation = method.getDeclaredAnnotation(EventHandler.class);
                if (annotation == null || !accept.test(method)) continue;
                MethodID id = new MethodID(method.getName(), method.getParameterTypes());
                if (!Modifier.isPrivate(method.getModifiers()) && !methodIDs.add(id)) continue;
                handler.add(new MethodHandler(clazz, annotation, method));
            }
        }
        return handler;
    }

    @Nonnull
    public static List<FieldHandler> getFields(Class<?> owner, Predicate<Field> accept, boolean registerSuperHandler) {
        ArrayList<FieldHandler> handler = new ArrayList<FieldHandler>();
        LinkedHashSet classes = new LinkedHashSet();
        if (registerSuperHandler) {
            EventUtils.getSuperClasses(classes, owner);
        } else {
            classes.add(owner);
        }
        for (Class clazz : classes) {
            for (Field field : clazz.getDeclaredFields()) {
                EventHandler annotation = field.getDeclaredAnnotation(EventHandler.class);
                if (annotation == null || !accept.test(field)) continue;
                handler.add(new FieldHandler(clazz, annotation, field));
            }
        }
        return handler;
    }

    public static void verify(Class<?> owner, EventHandler annotation, Method method) {
        if (Modifier.isAbstract(method.getModifiers())) {
            throw new IllegalStateException("Method '" + method.getName() + "' in class '" + owner.getName() + "' is abstract");
        }
        if (Modifier.isNative(method.getModifiers())) {
            throw new IllegalStateException("Method '" + method.getName() + "' in class '" + owner.getName() + "' is native");
        }
        if (annotation.events().length == 0 && method.getParameterCount() != 1) {
            throw new IllegalStateException("Method '" + method.getName() + "' in class '" + owner.getName() + "' has no virtual events and not exactly 1 parameter");
        }
        if (annotation.events().length > 0 && method.getParameterCount() != 0) {
            throw new IllegalStateException("Method '" + method.getName() + "' in class '" + owner.getName() + "' has virtual events and more than 0 parameters");
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new IllegalStateException("Method '" + method.getName() + "' in class '" + owner.getName() + "' has a return type");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void verify(Class<?> owner, EventHandler annotation, Field field) {
        if (Runnable.class.isAssignableFrom(field.getType())) {
            if (annotation.events().length != 0) return;
            throw new IllegalStateException("Field '" + field.getName() + "' in class '" + owner.getName() + "' has no virtual events");
        }
        if (!Consumer.class.isAssignableFrom(field.getType())) throw new IllegalStateException("Field '" + field.getName() + "' in class '" + owner.getName() + "' is not a Runnable or Consumer");
        if (annotation.events().length != 0) return;
        if (!(field.getGenericType() instanceof ParameterizedType)) throw new IllegalStateException("Field '" + field.getName() + "' in class '" + owner.getName() + "' has no virtual events and no generic type");
        ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
        if (parameterizedType.getActualTypeArguments().length == 1) return;
        throw new IllegalStateException("Field '" + field.getName() + "' in class '" + owner.getName() + "' has no virtual events and more than 1 generic type");
    }

    @Nonnull
    public static Class<?>[] getEvents(EventHandler annotation, Method method, Predicate<Class<?>> accept) {
        if (method.getParameterCount() == 1) {
            Class<?> param = method.getParameterTypes()[0];
            if (!accept.test(param)) {
                return new Class[0];
            }
            return new Class[]{param};
        }
        return (Class[])Arrays.stream(annotation.events()).filter(accept).toArray(Class[]::new);
    }

    @Nonnull
    public static Class<?>[] getEvents(EventHandler annotation, Field field, Predicate<Class<?>> accept) {
        ArrayList<Class> events = new ArrayList<Class>();
        Collections.addAll(events, annotation.events());
        if (Consumer.class.isAssignableFrom(field.getType()) && events.isEmpty() && field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            events.add((Class)parameterizedType.getActualTypeArguments()[0]);
        }
        return (Class[])events.stream().filter(accept).toArray(Class[]::new);
    }

    @Nonnull
    public static EventHandler newEventHandler(final int priority) {
        return new EventHandler(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return EventHandler.class;
            }

            @Override
            public int priority() {
                return priority;
            }

            @Override
            public Class<?>[] events() {
                return new Class[0];
            }

            @Override
            public boolean handleCancelled() {
                return true;
            }
        };
    }

    public static String toString(Method method) {
        Class<?> returnType = method.getReturnType();
        Class<?>[] params = method.getParameterTypes();
        StringBuilder out = new StringBuilder().append(method.getName()).append('(');
        for (int i = 0; i < params.length; ++i) {
            out.append(params[i].getSimpleName());
            if (i == params.length - 1) continue;
            out.append(", ");
        }
        return out.append(")").append(returnType.getSimpleName()).toString();
    }

    public static String toString(MethodHandle methodHandle) {
        MethodType type = methodHandle.type();
        StringBuilder out = new StringBuilder().append('(');
        for (int i = 0; i < type.parameterCount(); ++i) {
            out.append(((Class)type.parameterType(i)).getSimpleName());
            if (i == type.parameterCount() - 1) continue;
            out.append(", ");
        }
        return out.append(")").append(((Class)type.returnType()).getSimpleName()).toString();
    }

    public static void getSuperClasses(Set<Class<?>> classes, Class<?> clazz) {
        classes.add(clazz);
        Class<?> superClass = clazz.getSuperclass();
        Class<?>[] interfaces = clazz.getInterfaces();
        if (superClass != null && !classes.contains(superClass)) {
            EventUtils.getSuperClasses(classes, superClass);
        }
        for (Class<?> anInterface : interfaces) {
            if (classes.contains(anInterface)) continue;
            EventUtils.getSuperClasses(classes, anInterface);
        }
    }

    public static class FieldHandler {
        @Nonnull
        private final Class<?> owner;
        @Nonnull
        private final EventHandler annotation;
        @Nonnull
        private final Field field;

        public FieldHandler(@Nonnull Class<?> owner, @Nonnull EventHandler annotation, @Nonnull Field field) {
            if (owner == null) {
                throw new NullPointerException("owner is marked non-null but is null");
            }
            if (annotation == null) {
                throw new NullPointerException("annotation is marked non-null but is null");
            }
            if (field == null) {
                throw new NullPointerException("field is marked non-null but is null");
            }
            this.owner = owner;
            this.annotation = annotation;
            this.field = field;
        }

        @Nonnull
        public Class<?> getOwner() {
            return this.owner;
        }

        @Nonnull
        public EventHandler getAnnotation() {
            return this.annotation;
        }

        @Nonnull
        public Field getField() {
            return this.field;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldHandler)) {
                return false;
            }
            FieldHandler other = (FieldHandler)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$owner = this.getOwner();
            Class<?> other$owner = other.getOwner();
            if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
                return false;
            }
            EventHandler this$annotation = this.getAnnotation();
            EventHandler other$annotation = other.getAnnotation();
            if (this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation)) {
                return false;
            }
            Field this$field = this.getField();
            Field other$field = other.getField();
            return !(this$field == null ? other$field != null : !((Object)this$field).equals(other$field));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FieldHandler;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $owner = this.getOwner();
            result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
            EventHandler $annotation = this.getAnnotation();
            result = result * 59 + ($annotation == null ? 43 : $annotation.hashCode());
            Field $field = this.getField();
            result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
            return result;
        }

        public String toString() {
            return "EventUtils.FieldHandler(owner=" + this.getOwner() + ", annotation=" + this.getAnnotation() + ", field=" + this.getField() + ")";
        }
    }

    public static class MethodHandler {
        @Nonnull
        private final Class<?> owner;
        @Nonnull
        private final EventHandler annotation;
        @Nonnull
        private final Method method;

        public MethodHandler(@Nonnull Class<?> owner, @Nonnull EventHandler annotation, @Nonnull Method method) {
            if (owner == null) {
                throw new NullPointerException("owner is marked non-null but is null");
            }
            if (annotation == null) {
                throw new NullPointerException("annotation is marked non-null but is null");
            }
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            this.owner = owner;
            this.annotation = annotation;
            this.method = method;
        }

        @Nonnull
        public Class<?> getOwner() {
            return this.owner;
        }

        @Nonnull
        public EventHandler getAnnotation() {
            return this.annotation;
        }

        @Nonnull
        public Method getMethod() {
            return this.method;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodHandler)) {
                return false;
            }
            MethodHandler other = (MethodHandler)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$owner = this.getOwner();
            Class<?> other$owner = other.getOwner();
            if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
                return false;
            }
            EventHandler this$annotation = this.getAnnotation();
            EventHandler other$annotation = other.getAnnotation();
            if (this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation)) {
                return false;
            }
            Method this$method = this.getMethod();
            Method other$method = other.getMethod();
            return !(this$method == null ? other$method != null : !((Object)this$method).equals(other$method));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MethodHandler;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $owner = this.getOwner();
            result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
            EventHandler $annotation = this.getAnnotation();
            result = result * 59 + ($annotation == null ? 43 : $annotation.hashCode());
            Method $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            return result;
        }

        public String toString() {
            return "EventUtils.MethodHandler(owner=" + this.getOwner() + ", annotation=" + this.getAnnotation() + ", method=" + this.getMethod() + ")";
        }
    }

    private static class MethodID {
        @Nonnull
        private final String name;
        @Nonnull
        private final Class<?>[] params;

        public MethodID(@Nonnull String name, @Nonnull Class<?>[] params) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (params == null) {
                throw new NullPointerException("params is marked non-null but is null");
            }
            this.name = name;
            this.params = params;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public Class<?>[] getParams() {
            return this.params;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodID)) {
                return false;
            }
            MethodID other = (MethodID)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return Arrays.deepEquals(this.getParams(), other.getParams());
        }

        protected boolean canEqual(Object other) {
            return other instanceof MethodID;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getParams());
            return result;
        }

        public String toString() {
            return "EventUtils.MethodID(name=" + this.getName() + ", params=" + Arrays.deepToString(this.getParams()) + ")";
        }
    }
}

