/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.util;

import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import xaeroplus.Globals;

public class ChunkUtils {
    public static long chunkPosToLong(ChunkPos chunkPos) {
        return chunkPos.m_45588_();
    }

    public static long chunkPosToLong(int x, int z) {
        return ChunkPos.m_45589_((int)x, (int)z);
    }

    public static ChunkPos longToChunkPos(long l) {
        return new ChunkPos(l);
    }

    public static int posToChunkPos(int i) {
        return i >> 4;
    }

    public static int longToChunkX(long l) {
        return ChunkPos.m_45592_((long)l);
    }

    public static int longToChunkZ(long l) {
        return ChunkPos.m_45602_((long)l);
    }

    public static double getPlayerX() {
        try {
            Minecraft mc = Minecraft.m_91087_();
            ResourceKey dim = mc.f_91073_.m_46472_();
            if ((dim == Level.f_46429_ || Globals.getCurrentDimensionId() == Level.f_46429_) && dim != Globals.getCurrentDimensionId()) {
                if (Globals.getCurrentDimensionId() == Level.f_46428_) {
                    return mc.f_91074_.m_20185_() * 8.0;
                }
                if (Globals.getCurrentDimensionId() == Level.f_46429_ && dim == Level.f_46428_) {
                    return mc.f_91074_.m_20185_() / 8.0;
                }
            }
            return mc.f_91074_.m_20185_();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static double getPlayerZ() {
        try {
            Minecraft mc = Minecraft.m_91087_();
            ResourceKey dim = mc.f_91073_.m_46472_();
            if ((dim == Level.f_46429_ || Globals.getCurrentDimensionId() == Level.f_46429_) && dim != Globals.getCurrentDimensionId()) {
                if (Globals.getCurrentDimensionId() == Level.f_46428_) {
                    return mc.f_91074_.m_20189_() * 8.0;
                }
                if (Globals.getCurrentDimensionId() == Level.f_46429_ && dim == Level.f_46428_) {
                    return mc.f_91074_.m_20189_() / 8.0;
                }
            }
            return mc.f_91074_.m_20189_();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static int actualPlayerChunkX() {
        try {
            return Minecraft.m_91087_().f_91074_.m_146902_().f_45578_;
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public static int getPlayerChunkX() {
        return ChunkUtils.coordToChunkCoord(ChunkUtils.getPlayerX());
    }

    public static int actualPlayerChunkZ() {
        try {
            return Minecraft.m_91087_().f_91074_.m_146902_().f_45579_;
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public static int getPlayerChunkZ() {
        return ChunkUtils.coordToChunkCoord(ChunkUtils.getPlayerZ());
    }

    public static int actualPlayerRegionX() {
        return ChunkUtils.actualPlayerChunkX() >> 5;
    }

    public static int getPlayerRegionX() {
        return ChunkUtils.getPlayerChunkX() >> 5;
    }

    public static int actualPlayerRegionZ() {
        return ChunkUtils.actualPlayerChunkZ() >> 5;
    }

    public static int getPlayerRegionZ() {
        return ChunkUtils.getPlayerChunkZ() >> 5;
    }

    public static ResourceKey<Level> getActualDimension() {
        try {
            return Minecraft.m_91087_().f_91073_.m_46472_();
        }
        catch (Exception e) {
            return Level.f_46428_;
        }
    }

    public static int coordToChunkCoord(double coord) {
        return (int)coord >> 4;
    }

    public static int coordToRegionCoord(double coord) {
        return (int)coord >> 9;
    }

    public static int chunkCoordToCoord(int chunkCoord) {
        return chunkCoord << 4;
    }

    public static int chunkCoordToRegionCoord(int chunkCoord) {
        return chunkCoord >> 5;
    }

    public static int regionCoordToChunkCoord(int regionCoord) {
        return regionCoord << 5;
    }

    public static int regionCoordToCoord(int regionCoord) {
        return regionCoord << 9;
    }

    public static int coordToMapRegionCoord(int coord) {
        return coord >> 9;
    }

    public static int mapRegionCoordToCoord(int mapRegionCoord) {
        return mapRegionCoord << 9;
    }

    public static int mapTileChunkCoordToMapRegionCoord(int mapTileChunkCoord) {
        return mapTileChunkCoord >> 3;
    }

    public static int mapRegionCoordToMapTileChunkCoord(int mapRegionCoord) {
        return mapRegionCoord << 3;
    }

    public static int mapTileCoordToMapTileChunkCoord(int mapTileCoord) {
        return mapTileCoord >> 2;
    }

    public static int mapTileChunkCoordToMapTileCoord(int mapTileChunkCoord) {
        return mapTileChunkCoord << 2;
    }

    public static int mapTileCoordToCoord(int mapTileCoord) {
        return mapTileCoord << 4;
    }

    public static int coordToMapTileCoord(int coord) {
        return coord >> 4;
    }

    public static int mapTileCoordToMapRegionCoord(int mapTileCoord) {
        return mapTileCoord >> 6;
    }

    public static int mapRegionCoordToMapTileCoord(int mapRegionCoord) {
        return mapRegionCoord << 6;
    }

    public static int mapTileChunkCoordToCoord(int mapTileChunkCoord) {
        return mapTileChunkCoord << 6;
    }

    public static int coordToMapTileChunkCoord(int coord) {
        return coord >> 6;
    }

    public static int chunkCoordToMapRegionCoord(int chunkCoord) {
        return chunkCoord >> 5;
    }

    public static int mapRegionCoordToChunkCoord(int mapRegionCoord) {
        return mapRegionCoord << 5;
    }

    public static int chunkCoordToMapTileChunkCoord(int chunkCoord) {
        return chunkCoord >> 2;
    }

    public static int mapTileChunkCoordToChunkCoord(int mapTileChunkCoord) {
        return mapTileChunkCoord << 2;
    }

    public static int chunkCoordToMapTileCoord(int chunkCoord) {
        return chunkCoord;
    }

    public static int mapTileCoordToChunkCoord(int mapTileCoord) {
        return mapTileCoord;
    }

    public static int regionCoordToMapRegionCoord(int regionCoord) {
        return regionCoord;
    }

    public static int mapRegionCoordToRegionCoord(int mapRegionCoord) {
        return mapRegionCoord;
    }

    public static int regionCoordToMapTileChunkCoord(int regionCoord) {
        return regionCoord << 3;
    }

    public static int mapTileChunkCoordToRegionCoord(int mapTileChunkCoord) {
        return mapTileChunkCoord >> 3;
    }

    public static int regionCoordToMapTileCoord(int regionCoord) {
        return regionCoord << 6;
    }

    public static int mapTileCoordToRegionCoord(int mapTileCoord) {
        return mapTileCoord >> 6;
    }

    public static int chunkCoordToMapTileChunkCoordLocal(int chunkCoord) {
        return ChunkUtils.chunkCoordToMapTileChunkCoord(chunkCoord) & 7;
    }

    public static int chunkCoordToMapTileCoordLocal(int chunkCoord) {
        return ChunkUtils.chunkCoordToMapTileCoord(chunkCoord) & 3;
    }
}

