/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import com.google.common.hash.Hashing;
import java.util.List;
import java.util.Locale;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointVisibilityType;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointColor;
import xaero.hud.minimap.waypoint.set.WaypointSet;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.MinimapWorldManager;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.extensions.SyncedWaypoint;
import xaeroplus.feature.waypoint.WaypointAPI;
import xaeroplus.module.Module;
import xaeroplus.settings.Settings;
import xaeroplus.shadow.lambdaevents.EventHandler;
import xaeroplus.util.BlayWaystonesHelper;
import xaeroplus.util.ColorHelper;
import xaeroplus.util.FabricWaystonesHelper;
import xaeroplus.util.WaystonesHelper;

public class WaystoneSync
extends Module {
    private final BlayWaystonesHelper blayWaystonesHelper = new BlayWaystonesHelper();
    private ColorHelper.WaystoneColor color = ColorHelper.WaystoneColor.RANDOM;
    private boolean separateWaypointSet = false;
    private WaypointVisibilityType visibilityType = WaypointVisibilityType.LOCAL;

    @Override
    public void onEnable() {
        if (WaystonesHelper.isWaystonesPresent()) {
            this.blayWaystonesHelper.subscribeWaystonesEvent();
        }
        if (WaystonesHelper.isFabricWaystonesPresent()) {
            FabricWaystonesHelper.subcribeWaystonesEventsRunnable.run();
        }
        this.reloadWaystones();
    }

    @Override
    public void onDisable() {
        this.blayWaystonesHelper.currentWaystoneTypeMap.clear();
    }

    @EventHandler
    public void onXaeroWorldChangeEvent(XaeroWorldChangeEvent event) {
        if (event.worldChangeType() == XaeroWorldChangeEvent.WorldChangeType.EXIT_WORLD) {
            this.blayWaystonesHelper.currentWaystoneTypeMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onClientTickEvent(ClientTickEvent.Post event) {
        if (WaystonesHelper.isWaystonesPresent()) {
            Object object = this.blayWaystonesHelper.lock;
            synchronized (object) {
                if (this.blayWaystonesHelper.shouldSync && this.syncBlayWaystones()) {
                    this.blayWaystonesHelper.shouldSync = false;
                }
            }
        } else if (WaystonesHelper.isFabricWaystonesPresent() && FabricWaystonesHelper.shouldSync) {
            this.syncFabricWaystones();
            FabricWaystonesHelper.shouldSync = false;
        }
    }

    public void syncFabricWaystones() {
        this.commonWaystoneSync(FabricWaystonesHelper.getWaystones());
    }

    public boolean syncBlayWaystones() {
        return this.commonWaystoneSync(this.blayWaystonesHelper.getCurrentWaystones());
    }

    public boolean commonWaystoneSync(List<Waystone> waystones) {
        try {
            MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
            if (minimapSession == null) {
                return false;
            }
            MinimapWorldManager worldManager = minimapSession.getWorldManager();
            if (worldManager == null) {
                return false;
            }
            MinimapWorld currentWorld = worldManager.getCurrentWorld();
            if (currentWorld == null) {
                return false;
            }
            this.clearWaystoneWaypoints();
            for (Waystone waystone : waystones) {
                try {
                    this.waypointsListSync(waystone, this.getWaypointSet(waystone));
                }
                catch (Exception e) {
                    XaeroPlus.LOGGER.error("Error syncing waystone: {}", (Object)waystone.name(), (Object)e);
                }
            }
            return true;
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error syncing waystones", (Throwable)e);
            return true;
        }
    }

    private void clearWaystoneWaypoints() {
        WaypointAPI.forEachWaypointSetInCurrentContainer(waypoints -> waypoints.removeIf(WaystoneSync::isWaystoneWaypoint));
    }

    private static boolean isWaystoneWaypoint(Waypoint waypoint) {
        return waypoint.isTemporary() && waypoint.getName().endsWith(" [Waystone]");
    }

    private void waypointsListSync(Waystone waystone, WaypointSet waypointsList) {
        SyncedWaypoint waystoneWp = SyncedWaypoint.create(waystone.x(), waystone.y(), waystone.z(), waystone.name() + " [Waystone]", waystone.name().isEmpty() ? "W" : waystone.name().substring(0, 1).toUpperCase(Locale.ROOT), this.getWaystoneColor(waystone));
        waystoneWp.setVisibility(this.visibilityType);
        waypointsList.add((Waypoint)waystoneWp);
    }

    private WaypointSet getWaypointSet(Waystone waystone) {
        String waypointSetName = this.separateWaypointSet ? "Waystones" : "gui.xaero_default";
        MinimapWorld waypointWorld = this.getWaypointWorldForWaystone(waystone);
        return WaypointAPI.getOrCreateWaypointSetInWorld(waypointWorld, waypointSetName);
    }

    private MinimapWorld getWaypointWorldForWaystone(Waystone waystone) {
        MinimapWorld waystoneWpMinimapWorld = WaypointAPI.getMinimapWorld(waystone.dimension);
        if (waystoneWpMinimapWorld != null) {
            return waystoneWpMinimapWorld;
        }
        throw new RuntimeException("WaystoneSync: waystone world is null");
    }

    private WaypointColor getWaystoneColor(Waystone waystone) {
        if (waystone.color() != null) {
            return waystone.color();
        }
        if (this.color == ColorHelper.WaystoneColor.RANDOM) {
            int index = Math.abs(Hashing.murmur3_128().hashUnencodedChars((CharSequence)waystone.name()).asInt()) % WaypointColor.values().length;
            return WaypointColor.fromIndex((int)index);
        }
        return WaypointColor.fromIndex((int)this.color.getColorIndex());
    }

    public void setColor(ColorHelper.WaystoneColor color) {
        this.color = color;
        this.reloadWaystones();
    }

    public void setWaypointSet(boolean waypointSet) {
        this.separateWaypointSet = waypointSet;
        this.reloadWaystones();
    }

    public void setVisibilityType(Settings.WaystoneWpVisibilityType visibilityType) {
        this.visibilityType = switch (visibilityType) {
            default -> throw new IncompatibleClassChangeError();
            case Settings.WaystoneWpVisibilityType.LOCAL -> WaypointVisibilityType.LOCAL;
            case Settings.WaystoneWpVisibilityType.GLOBAL -> WaypointVisibilityType.GLOBAL;
            case Settings.WaystoneWpVisibilityType.WORLD_MAP_LOCAL -> WaypointVisibilityType.WORLD_MAP_LOCAL;
            case Settings.WaystoneWpVisibilityType.WORLD_MAP_GLOBAL -> WaypointVisibilityType.WORLD_MAP_GLOBAL;
        };
        this.reloadWaystones();
    }

    public void reloadWaystones() {
        this.blayWaystonesHelper.shouldSync = true;
        FabricWaystonesHelper.shouldSync = true;
    }

    public record Waystone(String name, ResourceKey<Level> dimension, int x, int y, int z, @Nullable WaypointColor color) {
        public Waystone(String name, ResourceKey<Level> dimension, int x, int y, int z) {
            this(name, dimension, x, y, z, null);
        }
    }
}

