/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.shadow.caffeine.cache;

import org.jspecify.annotations.Nullable;
import xaeroplus.shadow.caffeine.cache.AccessOrderDeque;
import xaeroplus.shadow.caffeine.cache.AsyncCacheLoader;
import xaeroplus.shadow.caffeine.cache.Caffeine;
import xaeroplus.shadow.caffeine.cache.Expiry;
import xaeroplus.shadow.caffeine.cache.LocalCacheFactory;
import xaeroplus.shadow.caffeine.cache.Node;
import xaeroplus.shadow.caffeine.cache.Pacer;
import xaeroplus.shadow.caffeine.cache.SIS;
import xaeroplus.shadow.caffeine.cache.Scheduler;
import xaeroplus.shadow.caffeine.cache.Ticker;
import xaeroplus.shadow.caffeine.cache.TimerWheel;

class SISA<K, V>
extends SIS<K, V> {
    static final LocalCacheFactory FACTORY = SISA::new;
    final Ticker ticker;
    final AccessOrderDeque<Node<K, V>> accessOrderWindowDeque;
    final Expiry<K, V> expiry;
    final TimerWheel<K, V> timerWheel;
    volatile long expiresAfterAccessNanos;
    final Pacer pacer;

    SISA(Caffeine<K, V> caffeine, @Nullable AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.accessOrderWindowDeque = caffeine.evicts() || caffeine.expiresAfterAccess() ? new AccessOrderDeque() : null;
        this.expiry = caffeine.getExpiry(this.isAsync);
        this.timerWheel = caffeine.expiresVariable() ? new TimerWheel() : null;
        this.expiresAfterAccessNanos = caffeine.getExpiresAfterAccessNanos();
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final AccessOrderDeque<Node<K, V>> accessOrderWindowDeque() {
        return this.accessOrderWindowDeque;
    }

    @Override
    protected final boolean expiresVariable() {
        return this.timerWheel != null;
    }

    @Override
    public final Expiry<K, V> expiry() {
        return this.expiry;
    }

    @Override
    protected final TimerWheel<K, V> timerWheel() {
        return this.timerWheel;
    }

    @Override
    protected final boolean expiresAfterAccess() {
        return this.timerWheel == null;
    }

    @Override
    protected final long expiresAfterAccessNanos() {
        return this.expiresAfterAccessNanos;
    }

    @Override
    protected final void setExpiresAfterAccessNanos(long l) {
        this.expiresAfterAccessNanos = l;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

