/*
 * Decompiled with CFR 0.152.
 */
package kaptainwutax.biomeutils.layer.scale;

import kaptainwutax.biomeutils.layer.IntBiomeLayer;
import kaptainwutax.mcutils.version.MCVersion;

public class ScaleLayer
extends IntBiomeLayer {
    private final Type type;

    public ScaleLayer(MCVersion version, long worldSeed, long salt, Type type, IntBiomeLayer parent) {
        super(version, worldSeed, salt, parent);
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int sample(int x, int y, int z) {
        IntBiomeLayer parent = this.getParent(IntBiomeLayer.class);
        int center = parent.get(x >> 1, y, z >> 1);
        this.setSeed(x & 0xFFFFFFFE, z & 0xFFFFFFFE);
        int xb = x & 1;
        int zb = z & 1;
        if (xb == 0 && zb == 0) {
            return center;
        }
        int s = parent.get(x >> 1, y, z + 1 >> 1);
        int zPlus = this.choose(center, s);
        if (xb == 0) {
            return zPlus;
        }
        int e = parent.get(x + 1 >> 1, y, z >> 1);
        int xPlus = this.choose(center, e);
        if (zb == 0) {
            return xPlus;
        }
        int se = parent.get(x + 1 >> 1, y, z + 1 >> 1);
        return this.sample(center, e, s, se);
    }

    public int sample(int center, int e, int s, int se) {
        int ret = this.choose(center, e, s, se);
        if (this.type == Type.FUZZY) {
            return ret;
        }
        if (e == s && e == se) {
            return e;
        }
        if (center == e && s != se) {
            return center;
        }
        if (center == s && e != se) {
            return center;
        }
        if (center == se && e != s) {
            return center;
        }
        if (e == s && center != se) {
            return e;
        }
        if (e == se && center != s) {
            return e;
        }
        if (s == se && center != e) {
            return s;
        }
        return ret;
    }

    public static enum Type {
        NORMAL,
        FUZZY;

    }
}

