/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.drawing;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaero.map.MapProcessor;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.gui.GuiMap;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.db.DrawingDatabase;
import xaeroplus.feature.drawing.DrawingHighlightCacheDimensionHandler;
import xaeroplus.feature.drawing.DrawingLinesCacheDimensionHandler;
import xaeroplus.feature.render.line.Line;
import xaeroplus.module.ModuleManager;
import xaeroplus.module.impl.TickTaskExecutor;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.GuiMapHelper;

public class DrawingCache
implements Closeable {
    private DrawingDatabase database;
    private String currentWorldId;
    private final AtomicBoolean cacheReady = new AtomicBoolean(false);
    private final String databaseName;
    private ListeningExecutorService dbExecutor;
    private final ListeningExecutorService parentExecutor;
    private final Map<ResourceKey<Level>, DrawingHighlightCacheDimensionHandler> dimensionCacheMap = new ConcurrentHashMap<ResourceKey<Level>, DrawingHighlightCacheDimensionHandler>(3);
    private final Map<ResourceKey<Level>, DrawingLinesCacheDimensionHandler> linesCacheMap = new ConcurrentHashMap<ResourceKey<Level>, DrawingLinesCacheDimensionHandler>(3);
    private final Queue<Runnable> initializeTaskQueue = new ConcurrentLinkedQueue<Runnable>();
    Minecraft mc = Minecraft.getInstance();
    int tickCounter = 0;

    public DrawingCache(String databaseName) {
        this.databaseName = databaseName;
        this.parentExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(databaseName + "-Manager").setUncaughtExceptionHandler((t, e) -> XaeroPlus.LOGGER.error("Uncaught exception in {}", (Object)t.getName(), (Object)e)).build()));
    }

    public void addHighlight(int x, int z, int color, ResourceKey<Level> dimension) {
        try {
            DrawingHighlightCacheDimensionHandler cacheForActualDimension = this.getCacheForDimension(dimension, true);
            if (cacheForActualDimension == null) {
                this.initializeTaskQueue.add(() -> this.addHighlight(x, z, color, dimension));
                return;
            }
            cacheForActualDimension.addHighlight(x, z, color);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.warn("Error adding highlight to {} disk cache: {}, {}", new Object[]{this.databaseName, x, z, e});
        }
    }

    public void addLine(Line line, int color, ResourceKey<Level> dimension) {
        try {
            DrawingLinesCacheDimensionHandler cacheForActualDimension = this.getLinesCacheForDimension(dimension, true);
            if (cacheForActualDimension == null) {
                this.initializeTaskQueue.add(() -> this.addLine(line, color, dimension));
                return;
            }
            cacheForActualDimension.addLine(line, color);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.warn("Error adding line to {} disk cache: {}, {}", new Object[]{this.databaseName, line, e});
        }
    }

    public void removeHighlight(int x, int z, ResourceKey<Level> dimension) {
        try {
            DrawingHighlightCacheDimensionHandler cacheForActualDimension = this.getCacheForDimension(dimension, true);
            if (cacheForActualDimension == null) {
                this.initializeTaskQueue.add(() -> this.removeHighlight(x, z, dimension));
                return;
            }
            cacheForActualDimension.removeHighlight(x, z);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.warn("Error removing highlight from {} disk cache: {}, {}", new Object[]{this.databaseName, x, z, e});
        }
    }

    public void removeLine(Line line, ResourceKey<Level> dimension) {
        try {
            DrawingLinesCacheDimensionHandler cacheForActualDimension = this.getLinesCacheForDimension(dimension, true);
            if (cacheForActualDimension == null) {
                this.initializeTaskQueue.add(() -> this.removeLine(line, dimension));
                return;
            }
            cacheForActualDimension.removeLine(line);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.warn("Error removing line from {} disk cache: {}, {}", new Object[]{this.databaseName, line, e});
        }
    }

    public Long2LongMap getCacheMap(ResourceKey<Level> dimensionId) {
        if (dimensionId == null) {
            return Long2LongMaps.EMPTY_MAP;
        }
        DrawingHighlightCacheDimensionHandler cacheForDimension = this.getCacheForDimension(dimensionId, false);
        if (cacheForDimension == null) {
            return Long2LongMaps.EMPTY_MAP;
        }
        return cacheForDimension.getCacheMap(dimensionId);
    }

    public Object2IntMap<Line> getLines(ResourceKey<Level> dimension) {
        if (dimension == null) {
            return Object2IntMaps.emptyMap();
        }
        DrawingLinesCacheDimensionHandler cacheForDimension = this.getLinesCacheForDimension(dimension, false);
        if (cacheForDimension == null) {
            return Object2IntMaps.emptyMap();
        }
        return cacheForDimension.getLines();
    }

    public void handleWorldChange(XaeroWorldChangeEvent event) {
        this.parentExecutor.execute(() -> {
            switch (event.worldChangeType()) {
                case ENTER_WORLD: {
                    if (!this.cacheReady.get()) {
                        if (!this.initializeWorld()) break;
                        this.cacheReady.set(true);
                        this.submitTickTask(() -> {
                            this.loadChunksInViewedDimension();
                            this.loadLinesInViewedDimension();
                        });
                        break;
                    }
                    XaeroPlus.LOGGER.warn("[{}] Entered world when cache was already initialized", (Object)this.databaseName);
                    break;
                }
                case EXIT_WORLD: {
                    if (this.cacheReady.compareAndSet(true, false)) {
                        try {
                            CompletableFuture.allOf(this.flushAllChunks().toArray(new CompletableFuture[0])).get(30L, TimeUnit.SECONDS);
                            CompletableFuture.allOf(this.flushAllLines().toArray(new CompletableFuture[0])).get(30L, TimeUnit.SECONDS);
                        }
                        catch (Exception e) {
                            XaeroPlus.LOGGER.error("Error saving all chunks before world change", (Throwable)e);
                        }
                    } else {
                        XaeroPlus.LOGGER.warn("[{}] Exited world when cache was already uninitialized", (Object)this.databaseName);
                    }
                    this.reset();
                    break;
                }
                case VIEWED_DIMENSION_SWITCH: {
                    this.submitTickTask(this::loadChunksInViewedDimension);
                    this.submitTickTask(this::loadLinesInViewedDimension);
                    break;
                }
                case ACTUAL_DIMENSION_SWITCH: {
                    this.submitTickTask(this::loadChunksOnActualDimensionSwitch);
                    this.submitTickTask(this::loadLinesOnActualDimensionSwitch);
                }
            }
        });
    }

    private CompletableFuture<?> submitTickTask(Runnable runnable) {
        return ModuleManager.getModule(TickTaskExecutor.class).submit(runnable);
    }

    private synchronized void reset() {
        this.currentWorldId = null;
        if (this.dbExecutor != null) {
            ListenableFuture closeFuture = this.dbExecutor.submit(() -> {
                if (this.database != null) {
                    this.database.close();
                }
            });
            try {
                this.dbExecutor.shutdown();
                closeFuture.get(3L, TimeUnit.SECONDS);
                this.dbExecutor.awaitTermination(3L, TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                XaeroPlus.LOGGER.error("Timed out waiting for {} executor to shutdown", (Object)this.databaseName, (Object)e);
            }
        }
        if (this.database != null) {
            this.database.close();
        }
        this.dimensionCacheMap.clear();
        this.linesCacheMap.clear();
        this.database = null;
        this.initializeTaskQueue.clear();
    }

    private List<CompletableFuture<?>> flushAllChunks() {
        return this.getAllCaches().stream().map(cache -> this.submitTickTask(cache::writeStaleHighlightsToDatabase)).collect(Collectors.toList());
    }

    private List<CompletableFuture<?>> flushAllLines() {
        return this.getAllLinesCaches().stream().map(cache -> this.submitTickTask(cache::writeStaleLinesToDatabase)).collect(Collectors.toList());
    }

    public DrawingHighlightCacheDimensionHandler getCacheForActualDimension() {
        if (!this.cacheReady.get()) {
            return null;
        }
        return this.getCacheForDimension(ChunkUtils.getActualDimension(), true);
    }

    private DrawingHighlightCacheDimensionHandler initializeDimensionCacheHandler(ResourceKey<Level> dimension) {
        if (dimension == null) {
            return null;
        }
        DrawingDatabase db = this.database;
        ListeningExecutorService executor = this.dbExecutor;
        if (db == null || executor == null) {
            XaeroPlus.LOGGER.error("[{}] Unable to initialize {} disk cache handler for: {}, database: {} or executor: {} is null", new Object[]{Thread.currentThread().getName(), this.databaseName, dimension.location(), db, executor});
            return null;
        }
        DrawingHighlightCacheDimensionHandler cacheHandler = new DrawingHighlightCacheDimensionHandler(dimension, db, executor);
        db.initializeDimension(dimension);
        this.dimensionCacheMap.put(dimension, cacheHandler);
        return cacheHandler;
    }

    private DrawingLinesCacheDimensionHandler initializeLinesCacheHandler(ResourceKey<Level> dimension) {
        if (dimension == null) {
            return null;
        }
        DrawingDatabase db = this.database;
        ListeningExecutorService executor = this.dbExecutor;
        if (db == null || executor == null) {
            XaeroPlus.LOGGER.error("[{}] Unable to initialize {} disk lines cache handler for: {}, database: {} or executor: {} is null", new Object[]{Thread.currentThread().getName(), this.databaseName, dimension.location(), db, executor});
            return null;
        }
        DrawingLinesCacheDimensionHandler linesCacheHandler = new DrawingLinesCacheDimensionHandler(dimension, db, executor);
        db.initializeDimension(dimension);
        this.linesCacheMap.put(dimension, linesCacheHandler);
        return linesCacheHandler;
    }

    public DrawingHighlightCacheDimensionHandler getCacheForDimension(ResourceKey<Level> dimension, boolean create) {
        if (!this.cacheReady.get()) {
            return null;
        }
        if (dimension == null) {
            return null;
        }
        DrawingHighlightCacheDimensionHandler dimensionCache = this.dimensionCacheMap.get(dimension);
        if (dimensionCache == null) {
            if (!create) {
                return null;
            }
            XaeroPlus.LOGGER.info("Initializing {} disk cache for dimension: {}", (Object)this.databaseName, (Object)dimension.location());
            dimensionCache = this.initializeDimensionCacheHandler(dimension);
        }
        return dimensionCache;
    }

    public DrawingLinesCacheDimensionHandler getLinesCacheForDimension(ResourceKey<Level> dimension, boolean create) {
        if (!this.cacheReady.get()) {
            return null;
        }
        if (dimension == null) {
            return null;
        }
        DrawingLinesCacheDimensionHandler linesCache = this.linesCacheMap.get(dimension);
        if (linesCache == null) {
            if (!create) {
                return null;
            }
            XaeroPlus.LOGGER.info("Initializing {} disk lines cache for dimension: {}", (Object)this.databaseName, (Object)dimension.location());
            linesCache = this.initializeLinesCacheHandler(dimension);
        }
        return linesCache;
    }

    public List<DrawingHighlightCacheDimensionHandler> getAllCaches() {
        return List.copyOf(this.dimensionCacheMap.values());
    }

    public List<DrawingLinesCacheDimensionHandler> getAllLinesCaches() {
        return List.copyOf(this.linesCacheMap.values());
    }

    public List<DrawingHighlightCacheDimensionHandler> getCachesExceptDimension(ResourceKey<Level> dimension) {
        ArrayList<DrawingHighlightCacheDimensionHandler> caches = new ArrayList<DrawingHighlightCacheDimensionHandler>(this.dimensionCacheMap.size());
        for (Map.Entry<ResourceKey<Level>, DrawingHighlightCacheDimensionHandler> entry : this.dimensionCacheMap.entrySet()) {
            if (entry.getKey().equals(dimension)) continue;
            caches.add(entry.getValue());
        }
        return caches;
    }

    public List<DrawingHighlightCacheDimensionHandler> getCachesExceptDimensions(List<ResourceKey<Level>> dimensions) {
        ArrayList<DrawingHighlightCacheDimensionHandler> caches = new ArrayList<DrawingHighlightCacheDimensionHandler>(this.dimensionCacheMap.size());
        for (Map.Entry<ResourceKey<Level>, DrawingHighlightCacheDimensionHandler> entry : this.dimensionCacheMap.entrySet()) {
            if (dimensions.contains(entry.getKey())) continue;
            caches.add(entry.getValue());
        }
        return caches;
    }

    private synchronized boolean initializeWorld() {
        try {
            MapProcessor mapProcessor = XaeroWorldMapCore.currentSession.getMapProcessor();
            if (mapProcessor == null) {
                return false;
            }
            String worldId = mapProcessor.getCurrentWorldId();
            if (worldId == null) {
                return false;
            }
            this.currentWorldId = worldId;
            this.dbExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(this.databaseName + "-Worker").setUncaughtExceptionHandler((t, e) -> XaeroPlus.LOGGER.error("Uncaught exception handler in {}", (Object)t.getName(), (Object)e)).build()));
            this.database = new DrawingDatabase(worldId, this.databaseName);
            this.initializeDimensionCacheHandler((ResourceKey<Level>)Level.OVERWORLD);
            this.initializeDimensionCacheHandler((ResourceKey<Level>)Level.NETHER);
            this.initializeDimensionCacheHandler((ResourceKey<Level>)Level.END);
            this.initializeLinesCacheHandler((ResourceKey<Level>)Level.OVERWORLD);
            this.initializeLinesCacheHandler((ResourceKey<Level>)Level.NETHER);
            this.initializeLinesCacheHandler((ResourceKey<Level>)Level.END);
            if (!this.initializeTaskQueue.isEmpty()) {
                XaeroPlus.LOGGER.info("[{}] Running {} queued tasks", (Object)this.databaseName, (Object)this.initializeTaskQueue.size());
            }
            while (!this.initializeTaskQueue.isEmpty()) {
                this.submitTickTask(this.initializeTaskQueue.poll());
            }
            return true;
        }
        catch (Exception e2) {
            this.reset();
            return false;
        }
    }

    private void loadChunksOnActualDimensionSwitch() {
        DrawingHighlightCacheDimensionHandler cacheForActualDimension = this.getCacheForActualDimension();
        if (cacheForActualDimension == null) {
            return;
        }
        cacheForActualDimension.setWindow(ChunkUtils.actualPlayerRegionX(), ChunkUtils.actualPlayerRegionZ(), this.getMinimapRegionWindowSize());
    }

    private void loadLinesOnActualDimensionSwitch() {
        DrawingLinesCacheDimensionHandler linesCacheForActualDimension = this.getLinesCacheForDimension(ChunkUtils.getActualDimension(), true);
        if (linesCacheForActualDimension == null) {
            return;
        }
        linesCacheForActualDimension.loadLines();
    }

    private void loadChunksInViewedDimension() {
        int windowCenterZ;
        int windowCenterX;
        int windowSize;
        ResourceKey<Level> viewedDim = Globals.getCurrentDimensionId();
        DrawingHighlightCacheDimensionHandler cacheForCurrentDimension = this.getCacheForDimension(viewedDim, true);
        if (cacheForCurrentDimension == null) {
            return;
        }
        Optional<GuiMap> guiMapOptional = GuiMapHelper.getGuiMap();
        if (guiMapOptional.isPresent()) {
            GuiMap guiMap = guiMapOptional.get();
            windowSize = GuiMapHelper.getGuiMapRegionSize(guiMap);
            windowCenterX = GuiMapHelper.getGuiMapCenterRegionX(guiMap);
            windowCenterZ = GuiMapHelper.getGuiMapCenterRegionZ(guiMap);
        } else {
            windowSize = this.getMinimapRegionWindowSize();
            windowCenterX = ChunkUtils.getPlayerRegionX();
            windowCenterZ = ChunkUtils.getPlayerRegionZ();
        }
        cacheForCurrentDimension.setWindow(windowCenterX, windowCenterZ, windowSize);
    }

    private void loadLinesInViewedDimension() {
        ResourceKey<Level> viewedDim = Globals.getCurrentDimensionId();
        DrawingLinesCacheDimensionHandler linesCacheForCurrentDimension = this.getLinesCacheForDimension(viewedDim, true);
        if (linesCacheForCurrentDimension == null) {
            return;
        }
        linesCacheForCurrentDimension.loadLines();
    }

    public void onEnable() {
        this.handleWorldChange(new XaeroWorldChangeEvent(XaeroWorldChangeEvent.WorldChangeType.ENTER_WORLD, null, ChunkUtils.getActualDimension()));
    }

    public void onDisable() {
        this.parentExecutor.execute(() -> {
            this.cacheReady.set(false);
            try {
                CompletableFuture.allOf(this.flushAllChunks().toArray(new CompletableFuture[0])).get(30L, TimeUnit.SECONDS);
                CompletableFuture.allOf(this.flushAllLines().toArray(new CompletableFuture[0])).get(30L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.error("Error saving all chunks before disabling", (Throwable)e);
            }
            this.reset();
        });
    }

    public int getMinimapRegionWindowSize() {
        return Math.max(3, Globals.minimapScaleMultiplier);
    }

    public void handleTick() {
        int windowCenterZ;
        int windowCenterX;
        int windowSize;
        if (!this.cacheReady.get()) {
            return;
        }
        if (XaeroWorldMapCore.currentSession == null) {
            return;
        }
        int jitter = ThreadLocalRandom.current().nextInt(0, 10);
        if (++this.tickCounter < 10 + jitter) {
            return;
        }
        this.tickCounter = 0;
        ResourceKey<Level> mapDimension = Globals.getCurrentDimensionId();
        ResourceKey<Level> actualDimension = ChunkUtils.getActualDimension();
        int actualPlayerRegionX = ChunkUtils.actualPlayerRegionX();
        int actualPlayerRegionZ = ChunkUtils.actualPlayerRegionZ();
        Optional<GuiMap> guiMapOptional = GuiMapHelper.getGuiMap();
        if (guiMapOptional.isPresent()) {
            GuiMap guiMap = guiMapOptional.get();
            windowSize = GuiMapHelper.getGuiMapRegionSize(guiMap);
            windowCenterX = GuiMapHelper.getGuiMapCenterRegionX(guiMap);
            windowCenterZ = GuiMapHelper.getGuiMapCenterRegionZ(guiMap);
        } else {
            windowSize = this.getMinimapRegionWindowSize();
            windowCenterX = ChunkUtils.getPlayerRegionX();
            windowCenterZ = ChunkUtils.getPlayerRegionZ();
        }
        DrawingHighlightCacheDimensionHandler cacheForDimension = this.getCacheForDimension(mapDimension, true);
        if (cacheForDimension != null) {
            cacheForDimension.setWindow(windowCenterX, windowCenterZ, windowSize);
        }
        if (mapDimension == actualDimension) {
            this.getCachesExceptDimension(mapDimension).forEach(cache -> cache.setWindow(0, 0, 0));
        } else {
            DrawingHighlightCacheDimensionHandler actualDimCache = this.getCacheForDimension(actualDimension, true);
            if (actualDimCache != null) {
                actualDimCache.setWindow(actualPlayerRegionX, actualPlayerRegionZ, windowSize);
            }
            this.getCachesExceptDimensions(List.of(mapDimension, actualDimension)).forEach(cache -> cache.setWindow(0, 0, 0));
        }
    }

    @Override
    public void close() throws IOException {
        this.parentExecutor.shutdown();
    }
}

