/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.drawing;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.db.DrawingDatabase;
import xaeroplus.feature.render.line.Line;

public class DrawingLinesCacheDimensionHandler {
    private final ResourceKey<Level> dimension;
    private final DrawingDatabase database;
    private final ListeningExecutorService dbExecutor;
    private final Object2IntMap<Line> lines = new Object2IntOpenHashMap();
    public final Set<Line> staleLines = new HashSet<Line>();
    Minecraft mc = Minecraft.getInstance();

    public DrawingLinesCacheDimensionHandler(ResourceKey<Level> dimension, DrawingDatabase database, ListeningExecutorService dbExecutor) {
        this.dimension = dimension;
        this.database = database;
        this.dbExecutor = dbExecutor;
    }

    public void addLine(Line line, int color) {
        if (!this.mc.isSameThread()) {
            throw new RuntimeException("addLine must be called on the main thread!");
        }
        this.lines.put((Object)line, color);
        this.staleLines.add(line);
        this.writeStaleLinesToDatabase();
    }

    public void removeLine(Line line) {
        if (!this.mc.isSameThread()) {
            throw new RuntimeException("removeLine must be called on the main thread!");
        }
        if (this.lines.containsKey((Object)line)) {
            this.lines.removeInt((Object)line);
            this.staleLines.add(line);
            this.dbExecutor.execute(() -> this.database.removeLine(line.x1(), line.z1(), line.x2(), line.z2(), this.dimension));
        }
    }

    public Object2IntMap<Line> getLines() {
        return this.lines;
    }

    protected ListenableFuture<?> loadLines() {
        ListenableFuture loadDataFuture = this.dbExecutor.submit(this::loadLinesFromDatabase);
        Futures.addCallback((ListenableFuture)loadDataFuture, (FutureCallback)new LineDataLoadFutureCallback(), (Executor)this.mc);
        return loadDataFuture;
    }

    private Object2IntMap<Line> loadLinesFromDatabase() {
        Object2IntOpenHashMap dataBuf = new Object2IntOpenHashMap();
        this.database.getLinesInDimension(this.dimension, (arg_0, arg_1, arg_2, arg_3, arg_4) -> DrawingLinesCacheDimensionHandler.lambda$loadLinesFromDatabase$1((Object2IntMap)dataBuf, arg_0, arg_1, arg_2, arg_3, arg_4));
        return dataBuf;
    }

    public ListenableFuture<?> writeStaleLinesToDatabase() {
        if (!this.mc.isSameThread()) {
            throw new RuntimeException("writeStaleHighlightsToDatabase must be called on the main thread");
        }
        Object2IntMap<Line> toWrite = this.collectStaleLinesToWrite();
        if (toWrite.isEmpty()) {
            return Futures.immediateVoidFuture();
        }
        return this.writeDataToDatabase(toWrite);
    }

    public Object2IntMap<Line> collectStaleLinesToWrite() {
        if (!this.mc.isSameThread()) {
            throw new RuntimeException("collectStaleHighlightsToWrite must be called on the main thread");
        }
        if (this.staleLines.isEmpty()) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap linesToWrite = new Object2IntOpenHashMap(this.staleLines.size());
        Iterator<Line> it = this.staleLines.iterator();
        while (it.hasNext()) {
            Line line = it.next();
            int color = this.lines.getOrDefault((Object)line, Integer.MIN_VALUE);
            if (color != Integer.MIN_VALUE) {
                linesToWrite.put((Object)line, color);
            }
            it.remove();
        }
        return linesToWrite;
    }

    public ListenableFuture<?> writeDataToDatabase(Object2IntMap<Line> toWrite) {
        try {
            return this.dbExecutor.submit(() -> this.database.insertLinesList(toWrite, this.dimension));
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed to submit db write task for {} disk cache dimension: {}", new Object[]{this.database.databaseName, this.dimension.location(), e});
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$loadLinesFromDatabase$1(Object2IntMap dataBuf, int x1, int z1, int x2, int z2, int color) {
        Line line = new Line(x1, z1, x2, z2);
        dataBuf.put((Object)line, color);
    }

    private final class LineDataLoadFutureCallback
    implements FutureCallback<Object2IntMap<Line>> {
        private LineDataLoadFutureCallback() {
        }

        public void onSuccess(Object2IntMap<Line> dataBuf) {
            if (!DrawingLinesCacheDimensionHandler.this.mc.isSameThread()) {
                XaeroPlus.LOGGER.error("LineDataLoadFutureCallback must be called on the main thread");
            }
            if (dataBuf.isEmpty()) {
                return;
            }
            DrawingLinesCacheDimensionHandler.this.lines.putAll(dataBuf);
        }

        public void onFailure(Throwable t) {
            XaeroPlus.LOGGER.error("Error loading lines {} disk cache dimension: {}", new Object[]{DrawingLinesCacheDimensionHandler.this.database.databaseName, DrawingLinesCacheDimensionHandler.this.dimension.location(), t});
        }
    }
}

