/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import xaero.common.HudMod;
import xaeroplus.XaeroPlus;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.render.DrawContext;
import xaeroplus.feature.render.DrawFeature;
import xaeroplus.feature.render.DrawFeatureRegistry;
import xaeroplus.shadow.lambdaevents.EventHandler;

public class DrawManager {
    private final DrawFeatureRegistry registry = new DrawFeatureRegistry();

    public final DrawFeatureRegistry registry() {
        return this.registry;
    }

    public DrawManager() {
        XaeroPlus.EVENT_BUS.register(this);
    }

    @EventHandler
    public void onXaeroWorldChange(XaeroWorldChangeEvent event) {
        this.registry.forEach(DrawFeature::invalidateCache);
    }

    public void drawMinimapFeatures(int chunkX, int chunkZ, int tileX, int tileZ, int insideX, int insideZ, PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffers) {
        if (HudMod.INSTANCE.isFairPlay()) {
            return;
        }
        DrawContext ctx = new DrawContext(matrixStack, renderTypeBuffers, 1.0, false);
        matrixStack.pushPose();
        matrixStack.translate((float)(-(chunkX * 64) - tileX * 16 - insideX), (float)(-(chunkZ * 64) - tileZ * 16 - insideZ), 0.0f);
        this.registry.forEach(feature -> feature.render(ctx));
        matrixStack.popPose();
    }

    public void drawWorldMapFeatures(int flooredCameraX, int flooredCameraZ, PoseStack matrixStack, double fboScale, MultiBufferSource.BufferSource renderTypeBuffers) {
        if (HudMod.INSTANCE.isFairPlay()) {
            return;
        }
        DrawContext ctx = new DrawContext(matrixStack, renderTypeBuffers, fboScale, true);
        matrixStack.pushPose();
        matrixStack.translate((float)(-flooredCameraX), (float)(-flooredCameraZ), 1.0f);
        this.registry.forEach(feature -> feature.render(ctx));
        matrixStack.popPose();
    }
}

