/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.line;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import xaeroplus.feature.render.line.Line;

public class LinePreProcessor {
    public static final int MAX_LINE_LENGTH = 500000;

    public static Line ensureOrientation(Line line) {
        if (line.z1() > line.z2()) {
            return new Line(line.x2(), line.z2(), line.x1(), line.z1());
        }
        return line;
    }

    public static List<Line> ensureLength(Line line) {
        double len = line.length();
        if (len <= 500000.0) {
            return Collections.emptyList();
        }
        ArrayList<Line> lines = new ArrayList<Line>((int)(len / 500000.0) + 1);
        int dx = line.x2() - line.x1();
        int dz = line.z2() - line.z1();
        if (dx == 0) {
            for (int z = Math.min(line.z1(), line.z2()); z < Math.max(line.z1(), line.z2()); z += 500000) {
                lines.add(new Line(line.x1(), z, line.x2(), Math.min(z + 500000, line.z2())));
            }
        } else if (dz == 0) {
            for (int x = Math.min(line.x1(), line.x2()); x < Math.max(line.x1(), line.x2()); x += 500000) {
                lines.add(new Line(x, line.z1(), Math.min(x + 500000, line.x2()), line.z2()));
            }
        } else {
            boolean positiveSlope;
            double slope = (double)dz / (double)dx;
            double intercept = (double)line.z1() - slope * (double)line.x1();
            boolean bl = positiveSlope = Math.abs(slope) > 1.0;
            if (positiveSlope) {
                for (double z = (double)Math.min(line.z1(), line.z2()); z < (double)Math.max(line.z1(), line.z2()); z += 500000.0) {
                    double x = (z - intercept) / slope;
                    lines.add(new Line((int)Math.round((z - 500000.0 - intercept) / slope), (int)Math.round(z - 500000.0), (int)Math.round(x), (int)Math.round(z)));
                }
            } else {
                for (double x = (double)Math.min(line.x1(), line.x2()); x < (double)Math.max(line.x1(), line.x2()); x += 500000.0) {
                    double z = slope * x + intercept;
                    lines.add(new Line((int)Math.round(x - 500000.0), (int)Math.round(slope * (x - 500000.0) + intercept), (int)Math.round(x), (int)Math.round(z)));
                }
            }
        }
        return lines;
    }
}

