/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import net.minecraft.client.Camera;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointsSort;
import xaero.common.misc.KeySortableByOther;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.map.misc.Misc;
import xaeroplus.settings.Settings;

@Mixin(value={GuiWaypoints.class}, remap=false)
public abstract class MixinGuiWaypoints
extends ScreenBase {
    @Unique
    private EditBox searchField;
    @Unique
    private final int TOGGLE_ALL_ID = 69;
    @Unique
    private MySmallButton toggleAllButton;
    @Unique
    private String waypointsSearchFilter = "";
    @Shadow
    private MinimapWorld displayedWorld;
    @Shadow
    private ArrayList<Waypoint> waypointsSorted;
    @Shadow
    private MinimapSession session;
    @Shadow
    private ConcurrentSkipListSet<Integer> selectedListSet;

    @Shadow
    protected abstract boolean isOneSelected();

    protected MixinGuiWaypoints(IXaeroMinimap modMain, Screen parent, Screen escape, Component titleIn) {
        super(modMain, parent, escape, titleIn);
    }

    @Inject(method={"init()V"}, at={@At(value="RETURN")}, remap=true)
    public void initGui(CallbackInfo ci) {
        this.searchField = new EditBox(this.font, this.width / 2 - 297, 32, 80, 20, (Component)Component.literal((String)"Search"));
        this.searchField.setValue("");
        this.searchField.setFocused(true);
        this.searchField.moveCursorTo(0, false);
        this.searchField.setCursorPosition(0);
        this.addWidget((GuiEventListener)this.searchField);
        this.setFocused((GuiEventListener)this.searchField);
        this.waypointsSearchFilter = "";
        this.toggleAllButton = new MySmallButton(69, this.width / 2 + 213, this.height - 53, (Component)Component.translatable((String)"xaeroplus.gui.waypoints.toggle_enable_all"), b -> this.waypointsSorted.stream().findFirst().ifPresent(firstWaypoint -> {
            boolean firstIsEnabled = firstWaypoint.isDisabled();
            this.waypointsSorted.forEach(waypoint -> waypoint.setDisabled(!firstIsEnabled));
        }));
        this.addRenderableWidget((GuiEventListener)this.toggleAllButton);
    }

    @Inject(method={"mouseClicked(DDI)Z"}, at={@At(value="INVOKE", target="Lxaero/common/gui/ScreenBase;mouseClicked(DDI)Z", shift=At.Shift.AFTER)}, remap=true)
    public void mouseClickedInject(double x, double y, int button, CallbackInfoReturnable<Boolean> cir) {
        boolean dropDownClosed;
        boolean bl = dropDownClosed = this.openDropdown == null;
        if (dropDownClosed) {
            if (this.searchField.mouseClicked(x, y, button)) {
                this.searchField.setFocused(true);
                this.searchField.moveCursorToEnd(false);
                this.searchField.setEditable(true);
            } else {
                this.searchField.setFocused(false);
            }
        }
    }

    @Inject(method={"keyPressed(III)Z"}, at={@At(value="INVOKE", target="Lxaero/common/gui/ScreenBase;keyPressed(III)Z", shift=At.Shift.AFTER)}, remap=true, cancellable=true)
    public void keyTypedInject(int keycode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (this.searchField.isFocused()) {
            this.updateSearch();
            cir.setReturnValue((Object)true);
        }
    }

    public boolean charTyped(char c, int i) {
        boolean result = super.charTyped(c, i);
        this.updateSearch();
        return result;
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lxaero/common/gui/ScreenBase;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", shift=At.Shift.AFTER)}, remap=true)
    public void drawScreenInject(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial, CallbackInfo ci) {
        if (!this.searchField.isFocused() && this.searchField.getValue().isEmpty()) {
            Misc.setFieldText((EditBox)this.searchField, (String)I18n.get((String)"gui.xaero_settings_search_placeholder", (Object[])new Object[0]), (int)-11184811);
            this.searchField.moveCursorToStart(false);
        }
        this.searchField.render(guiGraphics, mouseX, mouseY, partial);
        if (!this.searchField.isFocused()) {
            Misc.setFieldText((EditBox)this.searchField, (String)this.waypointsSearchFilter);
        }
    }

    @Redirect(method={"updateButtons()V"}, at=@At(value="INVOKE", target="Lxaero/common/gui/GuiWaypoints;isOneSelected()Z"))
    public boolean shareButtonRedirect(GuiWaypoints instance) {
        if (Settings.REGISTRY.disableWaypointSharing.get()) {
            return false;
        }
        return this.isOneSelected();
    }

    @Unique
    private void updateSearch() {
        String newValue;
        if (this.searchField.isFocused() && !this.waypointsSearchFilter.equals(newValue = this.searchField.getValue())) {
            this.waypointsSearchFilter = this.searchField.getValue();
            this.selectedListSet.clear();
            this.updateSortedList();
        }
    }

    @Overwrite
    private void updateSortedList() {
        WaypointsSort sortType = this.displayedWorld.getRootConfig().getSortType();
        Iterable waypointsList = this.displayedWorld.getCurrentWaypointSet().getWaypoints();
        GuiWaypoints.distanceDivided = this.session.getDimensionHelper().getDimensionDivision(this.displayedWorld);
        Camera camera = this.minecraft.gameRenderer.getMainCamera();
        ArrayList<Waypoint> disabledWaypoints = new ArrayList<Waypoint>();
        ArrayList<Waypoint> enabledWaypoints = new ArrayList<Waypoint>();
        for (Waypoint w : waypointsList) {
            if (w.isDisabled()) {
                disabledWaypoints.add(w);
                continue;
            }
            enabledWaypoints.add(w);
        }
        if (!this.waypointsSearchFilter.isEmpty()) {
            enabledWaypoints.removeIf(waypoint -> !waypoint.getName().toLowerCase().contains(this.waypointsSearchFilter.toLowerCase()));
            disabledWaypoints.removeIf(waypoint -> !waypoint.getName().toLowerCase().contains(this.waypointsSearchFilter.toLowerCase()));
        }
        this.waypointsSorted = new ArrayList();
        this.waypointsSorted.addAll(this.sortWaypoints(enabledWaypoints, sortType, camera));
        this.waypointsSorted.addAll(this.sortWaypoints(disabledWaypoints, sortType, camera));
    }

    @Unique
    private List<Waypoint> sortWaypoints(List<Waypoint> waypointsList, WaypointsSort sortType, Camera camera) {
        ArrayList<Waypoint> waypointsSorted = new ArrayList<Waypoint>();
        ArrayList<KeySortableByOther> sortableKeys = new ArrayList<KeySortableByOther>();
        for (Waypoint w : waypointsList) {
            Object sortVal = 0;
            switch (sortType) {
                case NONE: {
                    break;
                }
                case ANGLE: {
                    sortVal = -w.getComparisonAngleCos(camera, GuiWaypoints.distanceDivided);
                    break;
                }
                case COLOR: {
                    sortVal = w.getWaypointColor();
                    break;
                }
                case NAME: {
                    sortVal = w.getComparisonName();
                    break;
                }
                case SYMBOL: {
                    sortVal = w.getInitials();
                    break;
                }
                case DISTANCE: {
                    sortVal = w.getComparisonDistance(camera, GuiWaypoints.distanceDivided);
                }
            }
            sortableKeys.add(new KeySortableByOther((Object)w, new Comparable[]{sortVal}));
        }
        Collections.sort(sortableKeys);
        for (KeySortableByOther k : sortableKeys) {
            waypointsSorted.add((Waypoint)k.getKey());
        }
        if (this.displayedWorld.getContainer().getRootConfig().isSortReversed()) {
            Collections.reverse(waypointsSorted);
        }
        return waypointsSorted;
    }
}

