/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import java.text.NumberFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.common.gui.GuiWaypoints;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.hud.minimap.waypoint.set.WaypointSet;
import xaero.hud.minimap.world.MinimapWorld;
import xaeroplus.mixin.client.AccessorGuiWaypoints;
import xaeroplus.settings.Settings;

@Mixin(targets={"xaero/common/gui/GuiWaypoints$List"}, remap=false)
public abstract class MixinGuiWaypointsList {
    @Unique
    private final WaypointSet waypointsSortedSet = WaypointSet.Builder.begin().setName("xp-wp-sorted").build();
    @Unique
    private GuiWaypoints thisGuiWaypoints;

    @Inject(method={"<init>(Lxaero/common/gui/GuiWaypoints;)V"}, at={@At(value="RETURN")})
    public void init(GuiWaypoints this$0, CallbackInfo ci) throws NoSuchFieldException, IllegalAccessException {
        this.thisGuiWaypoints = this$0;
    }

    @Inject(method={"getWaypointCount()I"}, at={@At(value="HEAD")}, cancellable=true)
    public void getWaypointCount(CallbackInfoReturnable<Integer> cir) {
        try {
            int size = ((AccessorGuiWaypoints)this.thisGuiWaypoints).getWaypointsSorted().size();
            cir.setReturnValue((Object)size);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Redirect(method={"getWaypoint(I)Lxaero/common/minimap/waypoints/Waypoint;"}, at=@At(value="INVOKE", target="Lxaero/hud/minimap/world/MinimapWorld;getCurrentWaypointSet()Lxaero/hud/minimap/waypoint/set/WaypointSet;"))
    public WaypointSet getWaypointList(MinimapWorld instance) {
        this.waypointsSortedSet.clear();
        this.waypointsSortedSet.addAll(((AccessorGuiWaypoints)this.thisGuiWaypoints).getWaypointsSorted());
        return this.waypointsSortedSet;
    }

    @Inject(method={"drawWaypointSlot(Lnet/minecraft/client/gui/GuiGraphics;Lxaero/common/minimap/waypoints/Waypoint;II)V"}, at={@At(value="INVOKE", target="Lxaero/common/minimap/waypoints/Waypoint;isGlobal()Z")}, remap=false)
    public void shiftIconsLeft(GuiGraphics guiGraphics, Waypoint w, int x, int y, CallbackInfo ci, @Local(name={"rectX"}) LocalIntRef rectX) {
        rectX.set(rectX.get() - 30);
    }

    @Inject(method={"drawWaypointSlot(Lnet/minecraft/client/gui/GuiGraphics;Lxaero/common/minimap/waypoints/Waypoint;II)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;endBatch()V")}, remap=true)
    public void drawWaypointDistances(GuiGraphics guiGraphics, Waypoint w, int x, int y, CallbackInfo ci) {
        if (Settings.REGISTRY.showWaypointDistances.get() && w != null) {
            Entity renderViewEntity = Minecraft.getInstance().getCameraEntity();
            double playerX = renderViewEntity.getX();
            double playerZ = renderViewEntity.getZ();
            double playerY = renderViewEntity.getY();
            double dimensionDivision = GuiWaypoints.distanceDivided;
            int wpX = w.getX(dimensionDivision);
            int wpY = w.getY();
            int wpZ = w.getZ(dimensionDivision);
            double distance = Math.sqrt(Math.pow(playerX - (double)wpX, 2.0) + Math.pow(playerY - (double)wpY, 2.0) + Math.pow(playerZ - (double)wpZ, 2.0));
            String text = NumberFormat.getIntegerInstance().format(distance) + "m";
            Font fontRenderer = Minecraft.getInstance().font;
            guiGraphics.drawString(fontRenderer, text, x + 250, y + 1, 0xFFFFFF);
        }
    }
}

