/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CustomVertexConsumers;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.graphics.shader.FramebufferLinesShaderHelper;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.render.MinimapFBORenderer;
import xaero.common.minimap.render.MinimapRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.mods.SupportXaeroWorldmap;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.Minimap;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.compass.render.CompassRenderer;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.render.WaypointMapRenderer;
import xaeroplus.Globals;
import xaeroplus.feature.extensions.CustomMinimapFBORenderer;
import xaeroplus.settings.Settings;
import xaeroplus.util.ColorHelper;

@Mixin(value={MinimapFBORenderer.class}, remap=false)
public abstract class MixinMinimapFBORenderer
extends MinimapRenderer
implements CustomMinimapFBORenderer {
    @Shadow
    private ImprovedFramebuffer scalingFramebuffer;
    @Shadow
    private ImprovedFramebuffer rotationFramebuffer;
    @Shadow
    private boolean loadedFBO;

    public MixinMinimapFBORenderer(IXaeroMinimap modMain, Minecraft mc, WaypointsGuiRenderer waypointsGuiRenderer, Minimap minimap, CompassRenderer compassRenderer) {
        super(modMain, mc, (WaypointMapRenderer)waypointsGuiRenderer, minimap, compassRenderer);
    }

    @ModifyConstant(method={"loadFrameBuffer(Lxaero/common/minimap/MinimapProcessor;)V"}, constant={@Constant(intValue=512)})
    public int overrideFrameBufferSize(int size) {
        return Globals.minimapScaleMultiplier * 512;
    }

    @Override
    public void reloadMapFrameBuffers() {
        if (!((MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession()).getProcessor().canUseFrameBuffer()) {
            MinimapLogs.LOGGER.info("FBO mode not supported! Using minimap safe mode.");
        } else {
            if (this.scalingFramebuffer != null) {
                this.scalingFramebuffer.destroyBuffers();
            }
            if (this.rotationFramebuffer != null) {
                this.rotationFramebuffer.destroyBuffers();
            }
            int scaledSize = Globals.minimapScaleMultiplier * 512;
            this.scalingFramebuffer = new ImprovedFramebuffer(scaledSize, scaledSize, false);
            this.rotationFramebuffer = new ImprovedFramebuffer(scaledSize, scaledSize, true);
            this.rotationFramebuffer.setFilterMode(9729);
            this.loadedFBO = this.scalingFramebuffer.frameBufferId != -1 && this.rotationFramebuffer.frameBufferId != -1;
        }
    }

    @ModifyArg(method={"renderChunks(Lxaero/hud/minimap/module/MinimapSession;Lnet/minecraft/client/gui/GuiGraphics;Lxaero/common/minimap/MinimapProcessor;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/resources/ResourceKey;DIIFFIZZIDDZZLxaero/common/settings/ModSettings;Lxaero/common/graphics/CustomVertexConsumers;)V"}, at=@At(value="INVOKE", target="Lxaero/common/minimap/render/MinimapFBORenderer;renderChunksToFBO(Lxaero/hud/minimap/module/MinimapSession;Lnet/minecraft/client/gui/GuiGraphics;Lxaero/common/minimap/MinimapProcessor;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/resources/ResourceKey;DIFIZZIDDZLxaero/common/graphics/CustomVertexConsumers;)V"), index=6, remap=false)
    public int modifyViewW(int viewW) {
        return viewW * Globals.minimapScaleMultiplier;
    }

    @Inject(method={"renderChunksToFBO(Lxaero/hud/minimap/module/MinimapSession;Lnet/minecraft/client/gui/GuiGraphics;Lxaero/common/minimap/MinimapProcessor;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/resources/ResourceKey;DIFIZZIDDZLxaero/common/graphics/CustomVertexConsumers;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;pose()Lcom/mojang/blaze3d/vertex/PoseStack;")}, remap=true)
    public void modifyScaledSize(MinimapSession minimapSession, GuiGraphics guiGraphics, MinimapProcessor minimap, Vec3 renderPos, ResourceKey<Level> mapDimension, double mapDimensionScale, int viewW, float partial, int level, boolean useWorldMap, boolean lockedNorth, int shape, double ps, double pc, boolean cave, CustomVertexConsumers cvc, CallbackInfo ci, @Share(value="scaledSize") LocalIntRef scaledSize) {
        int s = 256 * Globals.minimapScaleMultiplier * Globals.minimapSizeMultiplier;
        if (Globals.minimapSizeMultiplier > 1) {
            int f = (Globals.minimapSizeMultiplier - 1) * Globals.minimapScaleMultiplier;
            s -= f * 6;
            int scaledMinimapSize = this.modMain.getSettings().getMinimapSize();
            int minimapNormalSize = scaledMinimapSize / Globals.minimapSizeMultiplier;
            int minimapScaledSizeDiff = 250 - minimapNormalSize;
            s -= minimapScaledSizeDiff * f;
        }
        scaledSize.set(s);
    }

    @Redirect(method={"renderChunksToFBO(Lxaero/hud/minimap/module/MinimapSession;Lnet/minecraft/client/gui/GuiGraphics;Lxaero/common/minimap/MinimapProcessor;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/resources/ResourceKey;DIFIZZIDDZLxaero/common/graphics/CustomVertexConsumers;)V"}, at=@At(value="INVOKE", target="Lorg/joml/Matrix4fStack;translate(FFF)Lorg/joml/Matrix4f;", ordinal=0), remap=false)
    public Matrix4f modifyShaderMatrixStackTranslate(Matrix4fStack instance, float x, float y, float z, @Share(value="scaledSize") LocalIntRef scaledSize) {
        float translate = 256.0f * (float)Globals.minimapScaleMultiplier;
        return instance.translate(translate, translate, -2000.0f);
    }

    @Redirect(method={"renderChunksToFBO(Lxaero/hud/minimap/module/MinimapSession;Lnet/minecraft/client/gui/GuiGraphics;Lxaero/common/minimap/MinimapProcessor;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/resources/ResourceKey;DIFIZZIDDZLxaero/common/graphics/CustomVertexConsumers;)V"}, at=@At(value="INVOKE", target="Lxaero/common/minimap/render/MinimapRendererHelper;drawMyColoredRect(Lorg/joml/Matrix4f;FFFFI)V"), remap=true)
    public void modifyMMBackgroundFill(MinimapRendererHelper instance, Matrix4f matrix, float x1, float y1, float x2, float y2, int color, @Share(value="scaledSize") LocalIntRef scaledSize) {
        if (!Settings.REGISTRY.transparentMinimapBackground.get()) {
            instance.drawMyColoredRect(matrix, (float)(-scaledSize.get()), (float)(-scaledSize.get()), (float)scaledSize.get(), (float)scaledSize.get(), ColorHelper.getColor(0, 0, 0, 255));
        } else {
            instance.drawMyColoredRect(matrix, (float)(-scaledSize.get()), (float)(-scaledSize.get()), (float)scaledSize.get(), (float)scaledSize.get(), ColorHelper.getColor(0, 0, 0, 0));
        }
    }

    @ModifyArg(method={"renderChunksToFBO(Lxaero/hud/minimap/module/MinimapSession;Lnet/minecraft/client/gui/GuiGraphics;Lxaero/common/minimap/MinimapProcessor;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/resources/ResourceKey;DIFIZZIDDZLxaero/common/graphics/CustomVertexConsumers;)V"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;lineWidth(F)V"), remap=false)
    public float modifyChunkGridLineWidth(float original) {
        return Math.max(1.0f, original * (float)Globals.minimapScaleMultiplier / (float)Globals.minimapSizeMultiplier);
    }

    @Redirect(method={"renderChunksToFBO(Lxaero/hud/minimap/module/MinimapSession;Lnet/minecraft/client/gui/GuiGraphics;Lxaero/common/minimap/MinimapProcessor;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/resources/ResourceKey;DIFIZZIDDZLxaero/common/graphics/CustomVertexConsumers;)V"}, at=@At(value="INVOKE", target="Lorg/joml/Matrix4fStack;translate(FFF)Lorg/joml/Matrix4f;", ordinal=0), slice=@Slice(from=@At(value="INVOKE", target="Lxaero/common/graphics/ImprovedFramebuffer;bindRead()V")), remap=true)
    public Matrix4f correctPreRotationTranslationForSizeMult(Matrix4fStack instance, float x, float y, float z) {
        return instance.translate(x / (float)Globals.minimapSizeMultiplier, y / (float)Globals.minimapSizeMultiplier, z);
    }

    @Inject(method={"renderChunksToFBO(Lxaero/hud/minimap/module/MinimapSession;Lnet/minecraft/client/gui/GuiGraphics;Lxaero/common/minimap/MinimapProcessor;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/resources/ResourceKey;DIFIZZIDDZLxaero/common/graphics/CustomVertexConsumers;)V"}, at={@At(value="INVOKE", target="Lorg/joml/Matrix4fStack;translate(FFF)Lorg/joml/Matrix4f;", ordinal=1, shift=At.Shift.BEFORE)}, slice={@Slice(from=@At(value="INVOKE", target="Lxaero/common/graphics/ImprovedFramebuffer;bindRead()V"))}, remap=true)
    public void correctPostRotationTranslationForSizeMult(MinimapSession minimapSession, GuiGraphics guiGraphics, MinimapProcessor minimap, Vec3 renderPos, ResourceKey<Level> mapDimension, double mapDimensionScale, int viewW, float partial, int level, boolean useWorldMap, boolean lockedNorth, int shape, double ps, double pc, boolean cave, CustomVertexConsumers cvc, CallbackInfo ci, @Local(name={"halfWView"}) float halfWView, @Local(name={"shaderMatrixStack"}) Matrix4fStack shaderMatrixStack) {
        float sizeMultTranslation = halfWView / (float)Globals.minimapSizeMultiplier * (float)(Globals.minimapSizeMultiplier - 1);
        shaderMatrixStack.translate(sizeMultTranslation, sizeMultTranslation, 0.0f);
    }

    @Redirect(method={"renderChunksToFBO(Lxaero/hud/minimap/module/MinimapSession;Lnet/minecraft/client/gui/GuiGraphics;Lxaero/common/minimap/MinimapProcessor;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/resources/ResourceKey;DIFIZZIDDZLxaero/common/graphics/CustomVertexConsumers;)V"}, at=@At(value="INVOKE", target="Lxaero/common/minimap/render/MinimapRendererHelper;drawMyTexturedModalRect(Lcom/mojang/blaze3d/vertex/PoseStack;FFIIFFFF)V"), remap=false)
    public void redirectModelViewDraw(MinimapRendererHelper instance, PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, @Share(value="scaledSize") LocalIntRef scaledSize) {
        float scaledSizeM = (float)Globals.minimapScaleMultiplier * 512.0f;
        this.helper.drawMyTexturedModalRect(matrixStack, (float)(-scaledSize.get()), (float)(-scaledSize.get()), 0, 0, scaledSizeM, scaledSizeM, scaledSizeM, scaledSizeM);
    }

    @WrapOperation(method={"renderChunksToFBO(Lxaero/hud/minimap/module/MinimapSession;Lnet/minecraft/client/gui/GuiGraphics;Lxaero/common/minimap/MinimapProcessor;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/resources/ResourceKey;DIFIZZIDDZLxaero/common/graphics/CustomVertexConsumers;)V"}, at={@At(value="INVOKE", target="Lxaero/common/mods/SupportXaeroWorldmap;drawMinimap(Lxaero/hud/minimap/module/MinimapSession;Lcom/mojang/blaze3d/vertex/PoseStack;Lxaero/common/minimap/render/MinimapRendererHelper;IIIIIIZDDLcom/mojang/blaze3d/vertex/VertexConsumer;Lxaero/common/graphics/renderer/multitexture/MultiTextureRenderTypeRendererProvider;)V")}, remap=false)
    public void drawMinimapFeatures(SupportXaeroWorldmap instance, MinimapSession minimapSession, PoseStack matrixStack, MinimapRendererHelper helper, int xFloored, int zFloored, int minViewX, int minViewZ, int maxViewX, int maxViewZ, boolean zooming, double zoom, double mapDimensionScale, VertexConsumer overlayBufferBuilder, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers, Operation<Void> original, @Local(name={"renderTypeBuffers"}) MultiBufferSource.BufferSource renderTypeBuffers) {
        original.call(new Object[]{instance, minimapSession, matrixStack, helper, xFloored, zFloored, minViewX, minViewZ, maxViewX, maxViewZ, zooming, zoom, mapDimensionScale, overlayBufferBuilder, multiTextureRenderTypeRenderers});
        int mapX = xFloored >> 4;
        int mapZ = zFloored >> 4;
        int chunkX = mapX >> 2;
        int chunkZ = mapZ >> 2;
        int tileX = mapX & 3;
        int tileZ = mapZ & 3;
        int insideX = xFloored & 0xF;
        int insideZ = zFloored & 0xF;
        FramebufferLinesShaderHelper.setFrameSize((float)this.scalingFramebuffer.viewWidth, (float)this.scalingFramebuffer.viewHeight);
        Globals.drawManager.drawMinimapFeatures(chunkX, chunkZ, tileX, tileZ, insideX, insideZ, matrixStack, renderTypeBuffers);
    }

    @WrapOperation(method={"renderChunksToFBO(Lxaero/hud/minimap/module/MinimapSession;Lnet/minecraft/client/gui/GuiGraphics;Lxaero/common/minimap/MinimapProcessor;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/resources/ResourceKey;DIFIZZIDDZLxaero/common/graphics/CustomVertexConsumers;)V"}, at={@At(value="INVOKE", target="Lxaero/common/graphics/renderer/multitexture/MultiTextureRenderTypeRendererProvider;draw(Lxaero/common/graphics/renderer/multitexture/MultiTextureRenderTypeRenderer;)V")})
    public void drawMinimapFeaturesCaveMode(MultiTextureRenderTypeRendererProvider instance, MultiTextureRenderTypeRenderer renderer, Operation<Void> original, @Local(name={"xFloored"}) int xFloored, @Local(name={"zFloored"}) int zFloored, @Local(name={"matrixStack"}) PoseStack matrixStack, @Local(name={"renderTypeBuffers"}) MultiBufferSource.BufferSource renderTypeBuffers) {
        original.call(new Object[]{instance, renderer});
        FramebufferLinesShaderHelper.setFrameSize((float)this.scalingFramebuffer.viewWidth, (float)this.scalingFramebuffer.viewHeight);
        int mapX = xFloored >> 4;
        int mapZ = zFloored >> 4;
        int chunkX = mapX >> 2;
        int chunkZ = mapZ >> 2;
        int tileX = mapX & 3;
        int tileZ = mapZ & 3;
        int insideX = xFloored & 0xF;
        int insideZ = zFloored & 0xF;
        Globals.drawManager.drawMinimapFeatures(chunkX, chunkZ, tileX, tileZ, insideX, insideZ, matrixStack, renderTypeBuffers);
    }
}

