/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xaero.map.gui.ConfigSettingEntry;
import xaero.map.gui.GuiSettings;
import xaero.map.gui.ISettingEntry;
import xaero.map.gui.MyTinyButton;
import xaero.map.gui.ScreenBase;
import xaero.map.misc.KeySortableByOther;
import xaero.map.settings.ModOptions;
import xaeroplus.XaeroPlus;
import xaeroplus.settings.Settings;
import xaeroplus.settings.XaeroPlusSetting;

@Mixin(value={GuiSettings.class}, remap=false)
public abstract class MixinWorldMapGuiSettings
extends ScreenBase {
    @Shadow
    protected int entriesPerPage;
    @Unique
    private int xaeroPlus$settingEntryWidth = 200;
    @Shadow
    private MyTinyButton nextButton;
    @Shadow
    private MyTinyButton prevButton;

    protected MixinWorldMapGuiSettings(Screen parent, Screen escape, Component titleIn) {
        super(parent, escape, titleIn);
    }

    @Inject(method={"init()V"}, at={@At(value="HEAD")})
    public void adjustEntriesPerPage(CallbackInfo ci) {
        this.xaeroPlus$settingEntryWidth = 200;
        this.entriesPerPage = 12;
        if (Settings.REGISTRY.expandSettingEntries.get()) {
            if (this.height > 350) {
                int extraRows = Math.min((this.height - 240) / 50, 6);
                this.entriesPerPage = 12 + 2 * extraRows;
            }
            if (this.width > 800) {
                this.xaeroPlus$settingEntryWidth = 250;
            }
        }
    }

    @Inject(method={"init()V"}, at={@At(value="RETURN")})
    public void adjustForwardBackButtonPositionsForExtraRows(CallbackInfo ci) {
        if (!Settings.REGISTRY.expandSettingEntries.get()) {
            return;
        }
        int extraRows = (this.entriesPerPage - 12) / 2;
        int yAdjust = extraRows * 24;
        this.nextButton.setY(this.nextButton.getY() + yAdjust);
        this.prevButton.setY(this.prevButton.getY() + yAdjust);
        this.children().stream().filter(child -> child instanceof Button).map(child -> (Button)child).filter(button -> button.getMessage().getContents() instanceof TranslatableContents).filter(button -> ((TranslatableContents)button.getMessage().getContents()).getKey().equals("gui.xaero_back")).findFirst().ifPresent(button -> button.setY(button.getY() + yAdjust));
    }

    @Redirect(method={"init()V"}, at=@At(value="INVOKE", target="Ljava/util/ArrayList;add(Ljava/lang/Object;)Z"), remap=true)
    public boolean settingListToRenderRedirect(ArrayList instance, Object entryObject) {
        KeySortableByOther entry = (KeySortableByOther)entryObject;
        ISettingEntry settingEntry = (ISettingEntry)entry.getKey();
        if (settingEntry instanceof ConfigSettingEntry) {
            try {
                Field option = ConfigSettingEntry.class.getDeclaredField("option");
                option.setAccessible(true);
                ModOptions modOptions = (ModOptions)option.get(settingEntry);
                String settingName = modOptions.getEnumString();
                XaeroPlusSetting xpSetting = Settings.REGISTRY.getSettingByName(settingName);
                if (xpSetting != null && !xpSetting.isVisible()) {
                    return false;
                }
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.warn("Failed to edit settings gui", (Throwable)e);
            }
        }
        instance.add(entryObject);
        return false;
    }

    @WrapOperation(method={"init()V"}, slice={@Slice(from=@At(value="FIELD", opcode=181, target="Lxaero/map/gui/GuiSettings;foundSomething:Z"))}, at={@At(value="INVOKE", target="Lxaero/map/gui/ISettingEntry;createWidget(IIIZ)Lnet/minecraft/client/gui/components/AbstractWidget;", ordinal=0)}, remap=true)
    public AbstractWidget adjustSettingEntryWidth(ISettingEntry instance, int x, int y, int w, boolean canEditIngameSettings, Operation<AbstractWidget> original, @Local(name={"i"}) int i) {
        if (!Settings.REGISTRY.expandSettingEntries.get()) {
            return (AbstractWidget)original.call(new Object[]{instance, x, y, w, canEditIngameSettings});
        }
        int xOffset = (i % 2 == 0 ? -1 : 1) * ((this.xaeroPlus$settingEntryWidth - 200) / 2);
        return (AbstractWidget)original.call(new Object[]{instance, x + xOffset, y, this.xaeroPlus$settingEntryWidth, canEditIngameSettings});
    }
}

